/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.block.food;

import com.github.ysbbbbbb.kaleidoscopecookery.block.food.FoodBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.init.registry.FoodBiteAnimateTicks;
import com.mojang.datafixers.util.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class FoodBiteBlock
extends FoodBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private final FoodProperties foodProperties;
    private final IntegerProperty bites;
    private final int maxBites;
    private FoodBiteAnimateTicks.AnimateTick animateTick = null;

    public FoodBiteBlock(FoodProperties foodProperties, int maxBites, FoodBiteAnimateTicks.AnimateTick animateTick) {
        this.maxBites = maxBites;
        this.foodProperties = foodProperties;
        this.bites = IntegerProperty.m_61631_((String)"bites", (int)0, (int)maxBites);
        StateDefinition.Builder builder = new StateDefinition.Builder((Object)this);
        this.createBitesBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder);
        this.f_49792_ = builder.m_61101_(Block::m_49966_, BlockState::new);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)this.bites, (Comparable)Integer.valueOf(0))).m_61124_((Property)FACING, (Comparable)Direction.SOUTH));
        this.animateTick = animateTick;
    }

    public FoodBiteBlock(FoodProperties foodProperties) {
        this(foodProperties, 3, null);
    }

    public IntegerProperty getBites() {
        return this.bites;
    }

    public int getMaxBites() {
        return this.maxBites;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (this.animateTick != null) {
            this.animateTick.animateTick(state, level, pos, random);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemInHand = player.m_21120_(hand);
        int bites = (Integer)state.m_61143_((Property)this.bites);
        if (bites >= this.getMaxBites()) {
            level.m_46953_(pos, true, (Entity)player);
            return InteractionResult.SUCCESS;
        }
        if (level.f_46443_) {
            if (this.eat(level, pos, state, player).m_19077_()) {
                return InteractionResult.SUCCESS;
            }
            if (itemInHand.m_41619_()) {
                return InteractionResult.CONSUME;
            }
        }
        return this.eat(level, pos, state, player);
    }

    private InteractionResult eat(Level level, BlockPos pos, BlockState state, Player player) {
        if (!player.m_36391_(this.foodProperties.m_38747_())) {
            return InteractionResult.PASS;
        }
        player.m_36324_().m_38707_(this.foodProperties.m_38744_(), this.foodProperties.m_38745_());
        for (Pair pair : this.foodProperties.m_38749_()) {
            if (level.f_46443_ || pair.getFirst() == null || !(level.f_46441_.m_188501_() < ((Float)pair.getSecond()).floatValue())) continue;
            player.m_7292_(new MobEffectInstance((MobEffectInstance)pair.getFirst()));
        }
        level.m_5594_(null, pos, SoundEvents.f_11912_, SoundSource.PLAYERS, 0.5f, level.m_213780_().m_188501_() * 0.1f + 0.9f);
        int bites = (Integer)state.m_61143_((Property)this.bites);
        level.m_142346_((Entity)player, GameEvent.f_157806_, pos);
        if (bites < this.getMaxBites()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)this.bites, (Comparable)Integer.valueOf(bites + 1)), 3);
        }
        return InteractionResult.SUCCESS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    private void createBitesBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{this.bites, FACING});
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        int value = (Integer)state.m_61143_((Property)this.bites);
        return (3 - value) * 5;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public boolean m_7357_(BlockState state, BlockGetter blockGetter, BlockPos pos, PathComputationType pathType) {
        return false;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }
}

