/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen;

import com.github.ysbbbbbb.kaleidoscopecookery.api.blockentity.IShawarmaSpit;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen.ShawarmaSpitBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ShawarmaSpitBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final VoxelShape UPPER_AABB = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)14.0, (double)10.0));
    public static final VoxelShape LOWER_AABB = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0), (VoxelShape)Block.m_49796_((double)6.0, (double)7.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0));

    public ShawarmaSpitBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60955_().m_280658_(NoteBlockInstrument.BASS).m_60913_(2.0f, 3.0f).m_60953_(state -> (Boolean)state.m_61143_((Property)POWERED) != false ? 8 : 0).m_60918_(SoundType.f_56743_));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @javax.annotation.Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> serverType, BlockEntityType<E> clientType, BlockEntityTicker<? super E> ticker) {
        return clientType == serverType ? ticker : null;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player.m_6144_()) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IShawarmaSpit) {
            IShawarmaSpit shawarmaSpit = (IShawarmaSpit)blockEntity;
            ItemStack heldItem = player.m_21120_(hand);
            if (shawarmaSpit.onPutCookingItem(level, heldItem)) {
                return InteractionResult.SUCCESS;
            }
            if (shawarmaSpit.onTakeCookedItem(level, (LivingEntity)player)) {
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return ShawarmaSpitBlock.createTickerHelper(blockEntityType, (BlockEntityType)ModBlocks.SHAWARMA_SPIT_BE.get(), (levelIn, blockPos, blockState, spit) -> {
            if (((Boolean)blockState.m_61143_((Property)POWERED)).booleanValue()) {
                spit.tick();
            }
        });
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        return state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? LOWER_AABB : UPPER_AABB;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor levelAccessor, BlockPos currentPos, BlockPos neighborPos) {
        boolean isUpperHalf;
        DoubleBlockHalf half;
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        boolean isLowerHalf = (half = (DoubleBlockHalf)state.m_61143_(HALF)) == DoubleBlockHalf.LOWER && direction == Direction.UP;
        boolean bl = isUpperHalf = half == DoubleBlockHalf.UPPER && direction == Direction.DOWN;
        if (direction.m_122434_() == Direction.Axis.Y && (isLowerHalf || isUpperHalf)) {
            if (neighborState.m_60713_((Block)this) && neighborState.m_61143_(HALF) != half) {
                return (BlockState)((BlockState)state.m_61124_((Property)f_54117_, (Comparable)((Direction)neighborState.m_61143_((Property)f_54117_)))).m_61124_((Property)POWERED, (Comparable)((Boolean)neighborState.m_61143_((Property)POWERED)));
            }
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, levelAccessor, currentPos, neighborPos);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean powered;
        Direction direction = state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? Direction.UP : Direction.DOWN;
        boolean bl = powered = level.m_276867_(pos) || level.m_276867_(pos.m_121945_(direction));
        if (!state.m_60713_(block) && powered != (Boolean)state.m_61143_((Property)POWERED)) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 2);
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.f_46443_ && player.m_7500_()) {
            if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
                BlockPos below = pos.m_7495_();
                BlockState belowState = level.m_8055_(below);
                if (belowState.m_60713_(state.m_60734_()) && belowState.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
                    this.dropCookItems(level, below);
                    BlockState airBlockState = belowState.m_60819_().m_192917_((Fluid)Fluids.f_76193_) ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
                    level.m_7731_(below, airBlockState, 35);
                    level.m_5898_(player, 2001, below, Block.m_49956_((BlockState)belowState));
                }
            } else {
                this.dropCookItems(level, pos);
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    private void dropCookItems(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ShawarmaSpitBlockEntity) {
            ShawarmaSpitBlockEntity shawarmaSpit = (ShawarmaSpitBlockEntity)blockEntity;
            if (!shawarmaSpit.cookingItem.m_41619_()) {
                ShawarmaSpitBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)shawarmaSpit.cookingItem.m_41777_());
                shawarmaSpit.cookingItem = ItemStack.f_41583_;
            } else if (!shawarmaSpit.cookedItem.m_41619_()) {
                ShawarmaSpitBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)shawarmaSpit.cookedItem.m_41777_());
                shawarmaSpit.cookedItem = ItemStack.f_41583_;
            }
        }
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        FluidState fluidState = context.m_43725_().m_6425_(pos);
        if (pos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(pos.m_7494_()).m_60629_(context)) {
            boolean isPowered = level.m_276867_(pos) || level.m_276867_(pos.m_7494_());
            return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_())).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(isPowered))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        FluidState fluidState = level.m_6425_(pos);
        BlockState blockState = (BlockState)((BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        level.m_46597_(pos.m_7494_(), blockState);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, HALF, WATERLOGGED, POWERED});
    }

    @javax.annotation.Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ShawarmaSpitBlockEntity(pos, state);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder lootParamsBuilder) {
        List drops = state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? super.m_49635_(state, lootParamsBuilder) : Lists.newArrayList();
        BlockEntity parameter = (BlockEntity)lootParamsBuilder.m_287159_(LootContextParams.f_81462_);
        if (parameter instanceof ShawarmaSpitBlockEntity) {
            ShawarmaSpitBlockEntity shawarmaSpit = (ShawarmaSpitBlockEntity)parameter;
            if (!shawarmaSpit.cookingItem.m_41619_()) {
                drops.add(shawarmaSpit.cookingItem.m_41777_());
            } else if (!shawarmaSpit.cookedItem.m_41619_()) {
                drops.add(shawarmaSpit.cookedItem.m_41777_());
            }
        }
        return drops;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.kaleidoscope_cookery.shawarma_spit").m_130940_(ChatFormatting.GRAY));
    }
}

