/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen;

import com.github.ysbbbbbb.kaleidoscopecookery.api.blockentity.IChoppingBoard;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.BaseBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.recipe.ChoppingBoardRecipe;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModRecipes;
import com.github.ysbbbbbb.kaleidoscopecookery.init.tag.TagMod;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemHandlerHelper;

public class ChoppingBoardBlockEntity
extends BaseBlockEntity
implements IChoppingBoard {
    private static final String MODEL_ID = "ModelId";
    private static final String CURRENT_CUT_STACK = "CurrentCutStack";
    private static final String RESULT_ITEM = "ResultItem";
    private static final String MAX_CUT_COUNT = "MaxCutCount";
    private static final String CURRENT_CUT_COUNT = "CurrentCutCount";
    @Nullable
    public ResourceLocation[] cacheModels = null;
    @Nullable
    public ResourceLocation previousModel = null;
    @Nullable
    private ResourceLocation modelId = null;
    private int maxCutCount = 0;
    private int currentCutCount = 0;
    private ItemStack currentCutStack = ItemStack.f_41583_;
    private ItemStack result = ItemStack.f_41583_;

    public ChoppingBoardBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModBlocks.CHOPPING_BOARD_BE.get(), pos, blockState);
    }

    public static void popResource(Level level, BlockPos pos, ItemStack stack) {
        if (!level.f_46443_ && !stack.m_41619_()) {
            ItemEntity entity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.25, (double)pos.m_123343_() + 0.5, stack, 0.0, 0.0, 0.0);
            entity.m_32060_();
            level.m_7967_((Entity)entity);
        }
    }

    @Override
    public boolean onPutItem(Level level, LivingEntity user, ItemStack putOnItem) {
        if (!this.result.m_41619_()) {
            return false;
        }
        SimpleContainer container = new SimpleContainer(new ItemStack[]{putOnItem});
        Optional recipeOptional = level.m_7465_().m_44015_(ModRecipes.CHOPPING_BOARD_RECIPE, (Container)container, level);
        if (recipeOptional.isPresent()) {
            ChoppingBoardRecipe recipe = (ChoppingBoardRecipe)((Object)recipeOptional.get());
            this.modelId = recipe.getModelId();
            this.maxCutCount = recipe.getCutCount();
            this.currentCutCount = 0;
            this.currentCutStack = putOnItem.m_41620_(1);
            this.result = recipe.m_5874_((Container)container, level.m_9598_());
            this.refresh();
            level.m_5594_(null, this.f_58858_, SoundEvents.f_12635_, SoundSource.BLOCKS, 1.0f, 1.2f);
            return true;
        }
        return false;
    }

    @Override
    public boolean onCutItem(Level level, LivingEntity user, ItemStack cutterItem) {
        if (this.result.m_41619_()) {
            return false;
        }
        if (this.currentCutCount >= this.maxCutCount) {
            ChoppingBoardBlockEntity.popResource(level, this.f_58858_, this.result.m_41777_());
            this.resetBoardData();
            level.m_5594_(null, this.f_58858_, SoundEvents.f_12635_, SoundSource.BLOCKS, 1.0f, 2.0f + level.f_46441_.m_188501_() * 0.2f);
            return true;
        }
        if (cutterItem.m_204117_(TagMod.KITCHEN_KNIFE)) {
            ++this.currentCutCount;
            this.playParticlesSound();
            this.refresh();
            return true;
        }
        return false;
    }

    @Override
    public boolean onTakeOut(Level level, LivingEntity user) {
        if (this.currentCutCount == 0 && !this.currentCutStack.m_41619_()) {
            if (user instanceof Player) {
                Player player = (Player)user;
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.currentCutStack);
            } else {
                ChoppingBoardBlockEntity.popResource(level, this.f_58858_, this.currentCutStack);
            }
            this.resetBoardData();
            level.m_5594_(null, this.f_58858_, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, 1.2f + level.f_46441_.m_188501_() * 0.2f);
            return true;
        }
        return false;
    }

    @Override
    public void playParticlesSound() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            RandomSource random = serverLevel.m_213780_();
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, (double)this.f_58858_.m_123341_() + 0.25 + random.m_188500_() / 2.0, (double)this.f_58858_.m_123342_() + 0.25, (double)this.f_58858_.m_123343_() + 0.25 + random.m_188500_() / 2.0, 2, 0.0, 0.0, 0.0, 0.1);
            serverLevel.m_5594_(null, this.f_58858_, SoundEvents.f_12635_, SoundSource.BLOCKS, 1.0f, 1.5f + this.f_58857_.f_46441_.m_188501_() * 0.4f);
        }
    }

    private void resetBoardData() {
        this.modelId = null;
        this.result = ItemStack.f_41583_;
        this.currentCutStack = ItemStack.f_41583_;
        this.currentCutCount = 0;
        this.maxCutCount = 0;
        this.refresh();
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.modelId != null) {
            tag.m_128359_(MODEL_ID, this.modelId.toString());
        }
        tag.m_128405_(MAX_CUT_COUNT, this.maxCutCount);
        tag.m_128405_(CURRENT_CUT_COUNT, this.currentCutCount);
        tag.m_128365_(CURRENT_CUT_STACK, (Tag)this.currentCutStack.serializeNBT());
        tag.m_128365_(RESULT_ITEM, (Tag)this.result.serializeNBT());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_(MODEL_ID)) {
            this.modelId = new ResourceLocation(tag.m_128461_(MODEL_ID));
        }
        this.maxCutCount = tag.m_128451_(MAX_CUT_COUNT);
        this.currentCutCount = tag.m_128451_(CURRENT_CUT_COUNT);
        if (tag.m_128441_(CURRENT_CUT_STACK)) {
            this.currentCutStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_(CURRENT_CUT_STACK));
        }
        if (tag.m_128441_(RESULT_ITEM)) {
            this.result = ItemStack.m_41712_((CompoundTag)tag.m_128469_(RESULT_ITEM));
        }
    }

    @Nullable
    public ResourceLocation getModelId() {
        return this.modelId;
    }

    public int getMaxCutCount() {
        return this.maxCutCount;
    }

    public int getCurrentCutCount() {
        return this.currentCutCount;
    }

    public ItemStack getCurrentCutStack() {
        return this.currentCutStack;
    }
}

