/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen;

import com.github.ysbbbbbb.kaleidoscopecookery.api.blockentity.IMillstone;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.BaseBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.recipe.MillstoneRecipe;
import com.github.ysbbbbbb.kaleidoscopecookery.datamap.MillstoneBindableData;
import com.github.ysbbbbbb.kaleidoscopecookery.datamap.resources.MillstoneBindableDataReloadListener;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModRecipes;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModSounds;
import com.github.ysbbbbbb.kaleidoscopecookery.init.tag.TagMod;
import java.util.List;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class MillstoneBlockEntity
extends BaseBlockEntity
implements IMillstone {
    public static final int MAX_INPUT_COUNT = 8;
    private static final String ENTITY_ID_KEY = "EntityId";
    private static final String CACHE_ROT_KEY = "CacheRot";
    private static final String ROT_SPEED_TICK_KEY = "RotSpeedTick";
    private static final String LIFT_ANGLE_KEY = "LiftAngle";
    private static final String INPUT_ITEM_KEY = "InputItem";
    private static final String OUTPUT_ITEM_KEY = "OutputItem";
    private static final String CARRIER_INGREDIENT_KEY = "CarrierIngredient";
    private static final String PROGRESS_KEY = "Progress";
    private final RecipeManager.CachedCheck<Container, MillstoneRecipe> quickCheck = RecipeManager.m_220267_(ModRecipes.MILLSTONE_RECIPE);
    private UUID entityId = Util.f_137441_;
    private float cacheRot = 0.0f;
    private float rotSpeedTick = 200.0f;
    private float liftAngle = 5.0f;
    private ItemStack input = ItemStack.f_41583_;
    private ItemStack output = ItemStack.f_41583_;
    private int progress = 0;
    @Nullable
    private Mob bindEntity;
    private Vec3 offset = Vec3.f_82478_;

    public MillstoneBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlocks.MILLSTONE_BE.get(), pos, state);
    }

    public float getRotation(Level level, float partialTick) {
        float degPerTick = 360.0f / Math.max(this.rotSpeedTick, 1.0f);
        float gameTime = (float)level.m_46467_() + partialTick;
        return (this.cacheRot + gameTime * degPerTick) % 360.0f;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void tick(Level level) {
        Vec3 center;
        float rot;
        ServerLevel serverLevel;
        block19: {
            Level level2 = this.f_58857_;
            if (!(level2 instanceof ServerLevel)) {
                return;
            }
            serverLevel = (ServerLevel)level2;
            if (Util.f_137441_.equals(this.entityId)) {
                return;
            }
            if (serverLevel.m_46467_() % 20L == 9L && !this.output.m_41619_()) {
                Direction direction = (Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
                BlockPos outputPos = this.f_58858_.m_121945_(direction);
                ItemStack outputStack = this.output.m_278832_();
                ItemEntity entity = new ItemEntity((Level)serverLevel, (double)outputPos.m_123341_() + 0.5, (double)outputPos.m_123342_(), (double)outputPos.m_123343_() + 0.5, outputStack, 0.0, 0.0, 0.0);
                entity.m_32060_();
                serverLevel.m_7967_((Entity)entity);
                this.resetWhenTakeout();
            }
            rot = this.getRotation(level, 0.0f);
            center = Vec3.m_82539_((Vec3i)this.m_58899_());
            double maxDistanceSqr = 25.0;
            if (this.bindEntity == null) {
                Mob mob;
                Entity entity = serverLevel.m_8791_(this.entityId);
                if (entity instanceof Mob && (mob = (Mob)entity).m_6084_() && mob.m_20238_(center) < maxDistanceSqr && this.canBindEntity(mob)) {
                    this.bindEntity(mob);
                    break block19;
                } else {
                    this.entityId = Util.f_137441_;
                    this.cacheRot = 0.0f;
                    this.liftAngle = 0.0f;
                    this.refresh();
                    return;
                }
            }
            if (!this.bindEntity.m_6084_() || this.bindEntity.m_20238_(center) >= maxDistanceSqr || this.bindEntity.f_19789_ > 0.5f || this.bindEntity.m_5830_() || this.saddleEntityIsControlling(this.bindEntity)) {
                this.entityId = Util.f_137441_;
                this.bindEntity = null;
                this.cacheRot = rot;
                this.liftAngle = 0.0f;
                this.refresh();
                return;
            }
        }
        Vec3 pos = new Vec3(0.0, 0.0, 2.0).m_82549_(this.offset).m_82524_(rot * ((float)Math.PI / 180)).m_82549_(center);
        this.bindEntity.m_7678_(pos.f_82479_, pos.f_82480_, pos.f_82481_, -rot - 90.0f, 0.0f);
        if (this.bindEntity.f_19797_ % 10 == 0 && this.output.m_41619_() && this.input.m_41619_() && this.progress <= 0) {
            boolean[] entityHasInventory = new boolean[1];
            LazyOptional capability = this.bindEntity.getCapability(ForgeCapabilities.ITEM_HANDLER);
            capability.ifPresent(handler -> {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack stack;
                    ItemStack stackInSlot = handler.getStackInSlot(i);
                    if (stackInSlot.m_41619_() || !this.onPutItem(level, stack = handler.extractItem(i, 8, true))) continue;
                    handler.extractItem(i, 8, false);
                    entityHasInventory[0] = true;
                    return;
                }
            });
            if (!entityHasInventory[0]) {
                BlockPos above = this.f_58858_.m_7494_();
                Vec3 startPos = new Vec3((double)above.m_123341_() - 0.3125, (double)above.m_123342_(), (double)above.m_123343_() - 0.3125);
                Vec3 endPos = new Vec3((double)above.m_123341_() + 1.3125, (double)above.m_123342_() + 0.5, (double)above.m_123343_() + 1.3125);
                AABB aabb = new AABB(startPos, endPos);
                List entities = serverLevel.m_45976_(ItemEntity.class, aabb);
                for (ItemEntity itemEntity : entities) {
                    int countCanInsert;
                    ItemStack stackToInsert;
                    ItemStack stack = itemEntity.m_32055_();
                    if (stack.m_41619_() || !this.onPutItem(level, stackToInsert = stack.m_255036_(countCanInsert = Math.min(stack.m_41613_(), 8)))) continue;
                    stack.m_41774_(countCanInsert);
                    if (stack.m_41619_()) {
                        itemEntity.m_146870_();
                        break;
                    }
                    itemEntity.m_32045_(stack);
                    break;
                }
            }
        }
        if (serverLevel.m_46467_() % 5L == 2L) {
            Item item;
            Item item2 = !this.output.m_41619_() ? this.output.m_41720_() : (item = !this.input.m_41619_() ? this.input.m_41720_() : Items.f_41852_);
            if (item != Items.f_41852_) {
                Vec3 particlePos = new Vec3(0.0, 1.0, 1.0).m_82524_(rot * ((float)Math.PI / 180)).m_82549_(center);
                if (item instanceof BlockItem) {
                    BlockItem blockItem = (BlockItem)item;
                    BlockState block = blockItem.m_40614_().m_49966_();
                    BlockParticleOption option = new BlockParticleOption(ParticleTypes.f_123794_, block);
                    serverLevel.m_8767_((ParticleOptions)option, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 5, 0.1, 0.1, 0.1, 0.05);
                } else {
                    ItemParticleOption option = new ItemParticleOption(ParticleTypes.f_123752_, item.m_7968_());
                    serverLevel.m_8767_((ParticleOptions)option, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 5, 0.1, 0.1, 0.1, 0.05);
                }
            }
        }
        if (serverLevel.m_46467_() % 25L == 0L) {
            float pitch = level.f_46441_.m_188501_() * 0.2f + 0.9f;
            serverLevel.m_5594_(null, this.f_58858_, (SoundEvent)ModSounds.BLOCK_MILLSTONE.get(), SoundSource.BLOCKS, 0.5f, pitch);
        }
        if (this.progress > 0 && this.output.m_41619_()) {
            --this.progress;
            if (this.progress % 10 == 0) {
                this.refresh();
            }
        }
        if (this.progress <= 0 && !this.input.m_41619_() && this.output.m_41619_()) {
            SimpleContainer container = new SimpleContainer(new ItemStack[]{this.input});
            this.quickCheck.m_213657_((Container)container, level).ifPresentOrElse(recipe -> {
                this.output = recipe.m_5874_((Container)container, level.m_9598_());
                this.output.m_41764_(this.output.m_41613_() * this.input.m_41613_());
                this.input = ItemStack.f_41583_;
                this.refresh();
            }, () -> {
                this.output = this.input.m_278832_();
                this.input = ItemStack.f_41583_;
                this.refresh();
            });
        }
    }

    @Override
    public boolean onPutItem(Level level, ItemStack putOnItem) {
        if (!this.output.m_41619_()) {
            return false;
        }
        if (this.progress > 0 && !this.input.m_41619_()) {
            return false;
        }
        SimpleContainer container = new SimpleContainer(new ItemStack[]{putOnItem});
        return this.quickCheck.m_213657_((Container)container, level).map(recipe -> {
            this.input = putOnItem.m_41620_(8);
            this.progress = Math.max(Math.round(this.rotSpeedTick), 1);
            this.refresh();
            level.m_5594_(null, this.f_58858_, SoundEvents.f_12446_, SoundSource.BLOCKS, 0.8f, level.f_46441_.m_188501_() * 0.2f + 0.9f);
            return true;
        }).orElse(false);
    }

    public void resetWhenTakeout() {
        this.output = ItemStack.f_41583_;
        this.progress = 0;
        this.refresh();
    }

    public boolean saddleEntityIsControlling(Mob mob) {
        if (!(mob instanceof Saddleable)) {
            return false;
        }
        Saddleable saddleable = (Saddleable)mob;
        return saddleable.m_6254_() && mob.m_6688_() != null;
    }

    public boolean canBindEntity(Mob mob) {
        if (!mob.m_6095_().m_204039_(TagMod.MILLSTONE_BINDABLE)) {
            return false;
        }
        if (mob.m_20202_() != null) {
            return false;
        }
        if (mob.m_6162_()) {
            return false;
        }
        if (this.saddleEntityIsControlling(mob)) {
            return false;
        }
        if (mob instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)mob;
            return horse.m_30614_();
        }
        if (mob instanceof TamableAnimal) {
            TamableAnimal tamableAnimal = (TamableAnimal)mob;
            return tamableAnimal.m_21824_();
        }
        if (mob instanceof OwnableEntity) {
            OwnableEntity ownable = (OwnableEntity)mob;
            return ownable.m_21805_() != null;
        }
        return true;
    }

    public void bindEntity(Mob mob) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (!mob.m_6084_()) {
            return;
        }
        this.entityId = mob.m_20148_();
        this.bindEntity = mob;
        float rot = this.getRotation(this.f_58857_, 0.0f);
        this.cacheRot -= rot - this.cacheRot;
        MillstoneBindableData data = MillstoneBindableDataReloadListener.INSTANCE.getOrDefault(mob.m_6095_(), MillstoneBindableData.DEFAULT);
        this.rotSpeedTick = data.rotSpeedTick();
        this.liftAngle = data.liftAngle();
        this.offset = data.offset();
        this.refresh();
    }

    public void sendActionBarMessage(LivingEntity user, String key, Object ... args) {
        if (user instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)user;
            MutableComponent message = Component.m_237110_((String)key, (Object[])args);
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)message));
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128362_(ENTITY_ID_KEY, this.entityId);
        tag.m_128350_(CACHE_ROT_KEY, this.cacheRot);
        tag.m_128350_(ROT_SPEED_TICK_KEY, this.rotSpeedTick);
        tag.m_128350_(LIFT_ANGLE_KEY, this.liftAngle);
        if (!this.input.m_41619_()) {
            tag.m_128365_(INPUT_ITEM_KEY, (Tag)this.input.m_41739_(new CompoundTag()));
        } else {
            tag.m_128365_(INPUT_ITEM_KEY, (Tag)new CompoundTag());
        }
        if (!this.output.m_41619_()) {
            tag.m_128365_(OUTPUT_ITEM_KEY, (Tag)this.output.m_41739_(new CompoundTag()));
        } else {
            tag.m_128365_(OUTPUT_ITEM_KEY, (Tag)new CompoundTag());
        }
        tag.m_128405_(PROGRESS_KEY, this.progress);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.entityId = tag.m_128342_(ENTITY_ID_KEY);
        this.cacheRot = tag.m_128457_(CACHE_ROT_KEY);
        this.rotSpeedTick = tag.m_128457_(ROT_SPEED_TICK_KEY);
        this.liftAngle = tag.m_128457_(LIFT_ANGLE_KEY);
        this.input = tag.m_128469_(INPUT_ITEM_KEY).m_128456_() ? ItemStack.f_41583_ : ItemStack.m_41712_((CompoundTag)tag.m_128469_(INPUT_ITEM_KEY));
        this.output = tag.m_128469_(OUTPUT_ITEM_KEY).m_128456_() ? ItemStack.f_41583_ : ItemStack.m_41712_((CompoundTag)tag.m_128469_(OUTPUT_ITEM_KEY));
        this.progress = tag.m_128451_(PROGRESS_KEY);
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_.m_7918_(-3, 0, -3), this.f_58858_.m_7918_(3, 2, 3));
    }

    public boolean hasEntity() {
        return !Util.f_137441_.equals(this.entityId);
    }

    public float getCacheRot() {
        return this.cacheRot;
    }

    public float getLiftAngle() {
        return this.liftAngle;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public float getProgressPercent() {
        float total = Math.max(this.rotSpeedTick, 1.0f);
        return (total - (float)this.progress) / total;
    }
}

