/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.client.gui.overlay;

import com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen.PotBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen.PotBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class PotOverlay
implements IGuiOverlay {
    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        Minecraft minecraft = gui.getMinecraft();
        if (minecraft.f_91072_ == null || minecraft.f_91072_.m_105295_() == GameType.SPECTATOR) {
            return;
        }
        HitResult hitResult = minecraft.f_91077_;
        if (!(hitResult instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult result = (BlockHitResult)hitResult;
        if (result.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        Level level = player.m_9236_();
        BlockPos blockPos = result.m_82425_();
        BlockState blockState = player.m_9236_().m_8055_(blockPos);
        if (!blockState.m_60713_((Block)ModBlocks.POT.get())) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (!(blockEntity instanceof PotBlockEntity)) {
            return;
        }
        PotBlockEntity pot = (PotBlockEntity)blockEntity;
        Font font = Minecraft.m_91087_().f_91062_;
        int x = screenWidth / 2;
        int y = screenHeight - 72;
        if (minecraft.f_91065_.f_92991_ > 0) {
            y -= 12;
        }
        if (((Boolean)blockState.m_61143_((Property)PotBlock.HAS_OIL)).booleanValue() && pot.hasHeatSource(level)) {
            int status = pot.getStatus();
            if (status == 0) {
                PotOverlay.drawWordWrap(guiGraphics, font, Component.m_237115_((String)"tip.kaleidoscope_cookery.pot.add_ingredient"), x, y, 0xFFFFFF);
                return;
            }
            if (status == 1) {
                PotOverlay.drawWordWrap(guiGraphics, font, Component.m_237115_((String)"tip.kaleidoscope_cookery.pot.need_stir_fry"), x, y, 0xFFFFFF);
                return;
            }
            if (status == 2) {
                PotOverlay.drawWordWrap(guiGraphics, font, Component.m_237115_((String)"tip.kaleidoscope_cookery.pot.done"), x, y, ChatFormatting.RED.m_126665_());
            }
        }
    }

    private static void drawWordWrap(GuiGraphics graphics, Font font, MutableComponent text, int pX, int pY, int color) {
        for (FormattedCharSequence sequence : font.m_92923_((FormattedText)text, 100)) {
            graphics.m_280648_(font, sequence, pX - font.m_92724_(sequence) / 2, pY, color);
            Objects.requireNonNull(font);
            pY += 9;
        }
    }
}

