/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.client.render.block;

import com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen.MillstoneBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen.MillstoneBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.client.model.MillstoneModel;
import com.github.ysbbbbbb.kaleidoscopecookery.client.resources.ItemRenderReplacer;
import com.github.ysbbbbbb.kaleidoscopecookery.client.resources.ItemRenderReplacerReloadListener;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;

public class MillstoneBlockEntityRender
implements BlockEntityRenderer<MillstoneBlockEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("kaleidoscope_cookery", "textures/block/millstone.png");
    private final BlockEntityRendererProvider.Context context;
    private final MillstoneModel bodyModel;

    public MillstoneBlockEntityRender(BlockEntityRendererProvider.Context context) {
        this.context = context;
        this.bodyModel = new MillstoneModel(context.m_173582_(MillstoneModel.LAYER_LOCATION));
    }

    public void render(MillstoneBlockEntity millstone, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Level level = millstone.m_58904_();
        if (level == null) {
            return;
        }
        Direction facing = (Direction)millstone.m_58900_().m_61143_((Property)MillstoneBlock.f_54117_);
        this.renderBody(poseStack, buffer, packedLight, packedOverlay, partialTick, facing, millstone, level);
        if (!millstone.getOutput().m_41619_()) {
            this.renderItems(millstone, poseStack, buffer, packedLight, packedOverlay, millstone.getOutput(), this.context.m_234447_());
        } else if (!millstone.getInput().m_41619_()) {
            this.renderItems(millstone, poseStack, buffer, packedLight, packedOverlay, millstone.getInput(), this.context.m_234447_());
        }
    }

    private void renderBody(PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, float partialTick, Direction facing, MillstoneBlockEntity millstone, Level level) {
        int facingDeg = facing.m_122416_() * 90;
        if (millstone.hasEntity()) {
            rot = (float)facingDeg + millstone.getRotation(level, partialTick);
            this.bodyModel.getWheel().f_104204_ = -rot * ((float)Math.PI / 180);
            this.bodyModel.getRoll().f_104205_ = rot * ((float)Math.PI / 180);
            this.bodyModel.getRotStick().f_104203_ = -millstone.getLiftAngle() * ((float)Math.PI / 180);
        } else {
            rot = (float)facingDeg + millstone.getCacheRot();
            this.bodyModel.getWheel().f_104204_ = -rot * ((float)Math.PI / 180);
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 1.5, 0.5);
        poseStack.m_252781_(Axis.f_252393_.m_252977_(180.0f));
        poseStack.m_252781_(Axis.f_252392_.m_252977_((float)(180 - facingDeg)));
        VertexConsumer checkerBoardBuff = bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)TEXTURE));
        this.bodyModel.m_7695_(poseStack, checkerBoardBuff, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
        this.bodyModel.getWheel().f_104204_ = 0.0f;
        this.bodyModel.getRoll().f_104205_ = 0.0f;
        this.bodyModel.getRotStick().f_104203_ = 0.0f;
    }

    private void renderItems(MillstoneBlockEntity millstone, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, ItemStack renderItem, ItemRenderer itemRenderer) {
        RandomSource source = RandomSource.m_216335_((long)millstone.hashCode());
        int maxCount = Math.min(renderItem.m_41613_(), 8);
        BakedModel model = ItemRenderReplacer.getModel(millstone.m_58904_(), renderItem, ItemRenderReplacerReloadListener.INSTANCE.millstone());
        for (int i = 0; i < maxCount; ++i) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.875, 0.0);
            poseStack.m_272245_(Axis.f_252436_.m_252977_((float)(i * 45 + source.m_188503_(15))), 0.5f, 0.0f, 0.5f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_((float)source.m_188503_(20)));
            poseStack.m_252781_(Axis.f_252495_.m_252977_((float)(80 + source.m_188503_(20))));
            poseStack.m_85841_(0.65f, 0.65f, 0.65f);
            itemRenderer.m_115143_(renderItem, ItemDisplayContext.FIXED, false, poseStack, buffer, packedLight, packedOverlay, model);
            poseStack.m_85849_();
        }
    }

    public boolean shouldRenderOffScreen(MillstoneBlockEntity millstone) {
        return true;
    }
}

