/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.client.render.block;

import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen.PotBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.client.resources.ItemRenderReplacer;
import com.github.ysbbbbbb.kaleidoscopecookery.client.resources.ItemRenderReplacerReloadListener;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class PotBlockEntityRender
implements BlockEntityRenderer<PotBlockEntity> {
    private final BlockEntityRendererProvider.Context context;

    public PotBlockEntityRender(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public void render(PotBlockEntity pot, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        boolean showInputs;
        RandomSource source = RandomSource.m_216335_((long)pot.getSeed());
        PotBlockEntity.StirFryAnimationData data = pot.animationData;
        long time = System.currentTimeMillis() - data.timestamp;
        if (data.preSeed == -1L) {
            data.preSeed = pot.getSeed();
        }
        if (data.preSeed != pot.getSeed()) {
            data.preSeed = pot.getSeed();
            if (time > 1000L) {
                data.timestamp = System.currentTimeMillis();
                data.randomHeights = new float[9];
                for (int i = 0; i < 9; ++i) {
                    data.randomHeights[i] = 0.25f + source.m_188501_() * 1.0f;
                }
            }
        }
        ItemRenderer itemRenderer = this.context.m_234447_();
        int rotation = ((Direction)pot.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_)).m_122416_() * 90;
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.1, 0.5);
        poseStack.m_252781_(Axis.f_252392_.m_252977_((float)rotation));
        poseStack.m_252781_(Axis.f_252495_.m_252977_(90.0f));
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        boolean bl = showInputs = pot.getStatus() != 2 && pot.getStatus() != 3;
        if (showInputs || pot.hasCarrier()) {
            List<ItemStack> items = pot.getInputs();
            for (int i = 0; i < items.size(); ++i) {
                ItemStack item = items.get(i);
                if (item.m_41619_()) continue;
                this.renderItem(pot, poseStack, buffer, packedLight, packedOverlay, source, i, time, data, itemRenderer, item);
                poseStack.m_85837_(0.0, 0.0, 0.025);
            }
        } else {
            this.renderItem(pot, poseStack, buffer, packedLight, packedOverlay, source, 0, time, data, itemRenderer, pot.getResult());
        }
        poseStack.m_85849_();
    }

    private void renderItem(PotBlockEntity pot, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, RandomSource source, int index, long time, PotBlockEntity.StirFryAnimationData data, ItemRenderer itemRenderer, ItemStack item) {
        poseStack.m_85836_();
        int count = 90 + source.m_188503_(90);
        poseStack.m_252781_(Axis.f_252393_.m_252977_((float)(index * count)));
        if (time < 1000L) {
            poseStack.m_252880_(0.0f, 0.0f, data.randomHeights[index] * Mth.m_14031_((float)((float)Math.PI * (float)time / 1000.0f)));
            poseStack.m_252781_(Axis.f_252495_.m_252977_(0.72f * (float)time));
        }
        if (pot.getStatus() == 3) {
            int tick = pot.getCurrentTick();
            int burntLevel = Mth.m_14045_((int)(tick / 25), (int)0, (int)16);
            packedLight = OverlayTexture.m_118088_((float)burntLevel);
        }
        BakedModel model = ItemRenderReplacer.getModel(pot.m_58904_(), item, ItemRenderReplacerReloadListener.INSTANCE.pot());
        itemRenderer.m_115143_(item, ItemDisplayContext.FIXED, false, poseStack, buffer, packedLight, packedOverlay, model);
        poseStack.m_85849_();
    }
}

