/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.client.render.block;

import com.github.ysbbbbbb.kaleidoscopecookery.block.decoration.TableBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.decoration.TableBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.ItemStackHandler;

public class TableBlockEntityRender
implements BlockEntityRenderer<TableBlockEntity> {
    private static final BiFunction<DyeColor, Integer, ResourceLocation> CACHE_MODEL = Util.m_143821_((color, position) -> {
        String name = color.m_41065_();
        if (position == 0) {
            return new ResourceLocation("kaleidoscope_cookery", "block/carpet/table/" + name + "_single");
        }
        if (position == 2) {
            return new ResourceLocation("kaleidoscope_cookery", "block/carpet/table/" + name + "_middle");
        }
        if (position == 1) {
            return new ResourceLocation("kaleidoscope_cookery", "block/carpet/table/" + name + "_left");
        }
        return new ResourceLocation("kaleidoscope_cookery", "block/carpet/table/" + name + "_right");
    });
    private final BlockEntityRendererProvider.Context context;

    public TableBlockEntityRender(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public void render(TableBlockEntity table, float pPartialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        ItemRenderer itemRenderer = this.context.m_234447_();
        BlockState blockState = table.m_58900_();
        Direction.Axis axis = (Direction.Axis)blockState.m_61143_(TableBlock.AXIS);
        if (((Boolean)blockState.m_61143_((Property)TableBlock.HAS_CARPET)).booleanValue()) {
            int position = (Integer)blockState.m_61143_((Property)TableBlock.POSITION);
            ResourceLocation cacheModel = CACHE_MODEL.apply(table.getColor(), position);
            int rotation = axis == Direction.Axis.X ? 180 : 270;
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.0, 0.5);
            poseStack.m_252781_(Axis.f_252436_.m_252977_((float)(-rotation)));
            poseStack.m_85837_(-0.5, 0.0, -0.5);
            BakedModel model = itemRenderer.m_115103_().m_109393_().getModel(cacheModel);
            RenderType renderType = RenderType.m_110458_((ResourceLocation)InventoryMenu.f_39692_);
            VertexConsumer vertexConsumer = ItemRenderer.m_115222_((MultiBufferSource)buffer, (RenderType)renderType, (boolean)true, (boolean)false);
            itemRenderer.m_115189_(model, ItemStack.f_41583_, packedLight, packedOverlay, poseStack, vertexConsumer);
            poseStack.m_85849_();
        }
        ItemStackHandler items = table.getItems();
        int count = 0;
        for (int i = 0; i < items.getSlots(); ++i) {
            if (items.getStackInSlot(i).m_41619_()) continue;
            ++count;
        }
        if (count == 0) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 1.3125, 0.5);
        poseStack.m_85841_(0.65f, 0.65f, 0.65f);
        if (count == 1) {
            this.rotation(poseStack, axis);
            ItemStack stack1 = items.getStackInSlot(0);
            this.offsetBlockItem(stack1, poseStack);
            itemRenderer.m_269128_(stack1, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, buffer, table.m_58904_(), 0);
        } else if (count == 2) {
            poseStack.m_85836_();
            this.rotation(poseStack, axis);
            poseStack.m_85837_(-0.25, 0.0, 0.1);
            ItemStack stack1 = items.getStackInSlot(0);
            this.offsetBlockItem(stack1, poseStack);
            itemRenderer.m_269128_(stack1, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, buffer, table.m_58904_(), 0);
            poseStack.m_85849_();
            poseStack.m_85836_();
            this.rotation(poseStack, axis);
            poseStack.m_85837_(0.25, 0.01, -0.1);
            stack2 = items.getStackInSlot(1);
            this.offsetBlockItem(stack2, poseStack);
            itemRenderer.m_269128_(stack2, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, buffer, table.m_58904_(), 0);
            poseStack.m_85849_();
        } else if (count == 3) {
            poseStack.m_85836_();
            this.rotation(poseStack, axis);
            poseStack.m_85837_(0.25, 0.0, -0.2);
            ItemStack stack1 = items.getStackInSlot(0);
            this.offsetBlockItem(stack1, poseStack);
            itemRenderer.m_269128_(stack1, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, buffer, table.m_58904_(), 0);
            poseStack.m_85849_();
            poseStack.m_85836_();
            this.rotation(poseStack, axis);
            poseStack.m_85837_(-0.25, 0.01, 0.0);
            stack2 = items.getStackInSlot(1);
            this.offsetBlockItem(stack2, poseStack);
            itemRenderer.m_269128_(stack2, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, buffer, table.m_58904_(), 0);
            poseStack.m_85849_();
            poseStack.m_85836_();
            this.rotation(poseStack, axis);
            poseStack.m_85837_(0.24, 0.02, 0.2);
            stack3 = items.getStackInSlot(2);
            this.offsetBlockItem(stack3, poseStack);
            itemRenderer.m_269128_(stack3, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, buffer, table.m_58904_(), 0);
            poseStack.m_85849_();
        } else {
            poseStack.m_85836_();
            this.rotation(poseStack, axis);
            poseStack.m_85837_(0.25, 0.0, -0.3);
            ItemStack stack1 = items.getStackInSlot(0);
            this.offsetBlockItem(stack1, poseStack);
            itemRenderer.m_269128_(stack1, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, buffer, table.m_58904_(), 0);
            poseStack.m_85849_();
            poseStack.m_85836_();
            this.rotation(poseStack, axis);
            poseStack.m_85837_(-0.24, 0.01, -0.1);
            stack2 = items.getStackInSlot(1);
            this.offsetBlockItem(stack2, poseStack);
            itemRenderer.m_269128_(stack2, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, buffer, table.m_58904_(), 0);
            poseStack.m_85849_();
            poseStack.m_85836_();
            this.rotation(poseStack, axis);
            poseStack.m_85837_(0.24, 0.02, 0.1);
            stack3 = items.getStackInSlot(2);
            this.offsetBlockItem(stack3, poseStack);
            itemRenderer.m_269128_(stack3, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, buffer, table.m_58904_(), 0);
            poseStack.m_85849_();
            poseStack.m_85836_();
            this.rotation(poseStack, axis);
            poseStack.m_85837_(-0.25, 0.03, 0.3);
            ItemStack stack4 = items.getStackInSlot(3);
            this.offsetBlockItem(stack4, poseStack);
            itemRenderer.m_269128_(stack4, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, buffer, table.m_58904_(), 0);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    private void rotation(PoseStack poseStack, Direction.Axis axis) {
        if (axis == Direction.Axis.X) {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        } else {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        }
    }

    private void offsetBlockItem(ItemStack stack, PoseStack poseStack) {
        if (stack.m_41720_() instanceof BlockItem) {
            poseStack.m_85837_(0.0, -0.25, 0.0);
        }
    }
}

