/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.compat.emi.category;

import com.github.ysbbbbbb.kaleidoscopecookery.api.recipe.soupbase.ISoupBase;
import com.github.ysbbbbbb.kaleidoscopecookery.compat.farmersdelight.FarmersDelightCompat;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.recipe.StockpotRecipe;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.soupbase.SoupBaseManager;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModRecipes;
import com.google.common.collect.Lists;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class EmiStockpotRecipe
extends BasicEmiRecipe {
    public static final EmiRecipeCategory CATEGORY = new EmiRecipeCategory(new ResourceLocation(ModRecipes.STOCKPOT_RECIPE.toString()), (EmiRenderable)EmiIngredient.of((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.STOCKPOT.get()})));
    private static final ResourceLocation BG = new ResourceLocation("kaleidoscope_cookery", "textures/gui/jei/stockpot.png");
    public static final int WIDTH = 176;
    public static final int HEIGHT = 102;
    private final EmiStack soupBase;

    public EmiStockpotRecipe(ResourceLocation id, List<EmiIngredient> inputs, List<EmiStack> outputs, List<EmiIngredient> catalysts, EmiStack soupBase) {
        super(CATEGORY, id, 176, 102);
        this.inputs = inputs;
        this.outputs = outputs;
        this.catalysts = catalysts;
        this.soupBase = soupBase;
    }

    public static void register(EmiRegistry registry) {
        registry.addCategory(CATEGORY);
        registry.addWorkstation(CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)ModItems.STOCKPOT.get())));
        registry.addWorkstation(CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)ModItems.STOCKPOT_LID.get())));
        registry.getRecipeManager().m_44013_(ModRecipes.STOCKPOT_RECIPE).forEach(r -> EmiStockpotRecipe.registerRecipe(registry, r));
        ArrayList compatRecipes = Lists.newArrayList();
        FarmersDelightCompat.getTransformRecipeForJei((Level)Minecraft.m_91087_().f_91073_, compatRecipes);
        if (!compatRecipes.isEmpty()) {
            compatRecipes.forEach(r -> EmiStockpotRecipe.registerRecipe(registry, r));
        }
    }

    private static void registerRecipe(EmiRegistry registry, StockpotRecipe r) {
        List<EmiIngredient> inputs = r.m_7527_().stream().map(EmiIngredient::of).toList();
        List<EmiStack> outputs = List.of(EmiStack.of((ItemStack)r.m_8043_((RegistryAccess)RegistryAccess.f_243945_)));
        List<EmiIngredient> catalysts = List.of(EmiIngredient.of((Ingredient)r.carrier()));
        ISoupBase soupBase = SoupBaseManager.getSoupBase(r.soupBase());
        if (soupBase == null) {
            throw new RuntimeException("No soup found for " + r.soupBase());
        }
        EmiStack soupBaseItem = EmiStack.of((ItemStack)soupBase.getDisplayStack());
        registry.addRecipe((EmiRecipe)new EmiStockpotRecipe(r.m_6423_(), inputs, outputs, catalysts, soupBaseItem));
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(BG, 1, 1, 176, 102, 0, 0);
        for (int i = 0; i < this.inputs.size(); ++i) {
            int xOffset = i % 3 * 18 + 15;
            int yOffset = i / 3 * 18 + 25;
            widgets.addSlot((EmiIngredient)this.inputs.get(i), xOffset, yOffset).drawBack(false);
        }
        if (!this.soupBase.isEmpty()) {
            widgets.addSlot((EmiIngredient)this.soupBase, 72, 61).drawBack(false);
        }
        if (!this.catalysts.isEmpty()) {
            widgets.addSlot((EmiIngredient)this.catalysts.get(0), 133, 18).drawBack(false);
        }
        widgets.addSlot((EmiIngredient)this.outputs.get(0), 143, 60).drawBack(false).recipeContext((EmiRecipe)this);
    }
}

