/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.compat.jei.category;

import com.github.ysbbbbbb.kaleidoscopecookery.api.recipe.soupbase.ISoupBase;
import com.github.ysbbbbbb.kaleidoscopecookery.compat.farmersdelight.FarmersDelightCompat;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.recipe.StockpotRecipe;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.soupbase.SoupBaseManager;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModRecipes;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class StockpotRecipeCategory
implements IRecipeCategory<StockpotRecipe> {
    public static final RecipeType<StockpotRecipe> TYPE = RecipeType.create((String)"kaleidoscope_cookery", (String)"stockpot", StockpotRecipe.class);
    private static final ResourceLocation BG = new ResourceLocation("kaleidoscope_cookery", "textures/gui/jei/stockpot.png");
    private static final MutableComponent TITLE = Component.m_237115_((String)"block.kaleidoscope_cookery.stockpot");
    public static final int WIDTH = 176;
    public static final int HEIGHT = 102;
    private final IDrawable bgDraw;
    private final IDrawable iconDraw;
    private final IDrawable slotDraw;
    private final IGuiHelper guiHelper;

    public StockpotRecipeCategory(IGuiHelper guiHelper) {
        this.bgDraw = guiHelper.createDrawable(BG, 0, 0, 176, 102);
        this.iconDraw = guiHelper.createDrawableItemLike((ItemLike)ModItems.STOCKPOT.get());
        this.slotDraw = guiHelper.getSlotDrawable();
        this.guiHelper = guiHelper;
    }

    public static List<StockpotRecipe> getRecipes() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return List.of();
        }
        ArrayList stockpotRecipes = Lists.newArrayList();
        stockpotRecipes.addAll(level.m_7465_().m_44013_(ModRecipes.STOCKPOT_RECIPE));
        FarmersDelightCompat.getTransformRecipeForJei((Level)level, stockpotRecipes);
        return stockpotRecipes;
    }

    public void draw(StockpotRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.bgDraw.draw(guiGraphics);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, StockpotRecipe recipe, IFocusGroup focuses) {
        NonNullList<Ingredient> inputs = recipe.m_7527_();
        ItemStack output = recipe.result();
        for (int i = 0; i < inputs.size(); ++i) {
            int xOffset = i % 3 * 18 + 15;
            int yOffset = i / 3 * 18 + 25;
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, xOffset, yOffset).addIngredients((Ingredient)inputs.get(i))).setBackground(this.slotDraw, -1, -1);
        }
        ISoupBase soupBase = SoupBaseManager.getSoupBase(recipe.soupBase());
        if (soupBase == null) {
            throw new RuntimeException("No soup found for " + recipe.soupBase());
        }
        ItemStack displayStack = soupBase.getDisplayStack();
        if (!displayStack.m_41619_()) {
            builder.addSlot(RecipeIngredientRole.INPUT, 72, 61).addIngredients(Ingredient.m_43927_((ItemStack[])new ItemStack[]{displayStack}));
        }
        if (!recipe.carrier().m_43947_()) {
            builder.addSlot(RecipeIngredientRole.INPUT, 133, 18).addIngredients(recipe.carrier());
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 143, 60).addItemStack(output);
    }

    public RecipeType<StockpotRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return TITLE;
    }

    public int getWidth() {
        return 176;
    }

    public int getHeight() {
        return 102;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.iconDraw;
    }
}

