/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.crafting.serializer;

import com.github.ysbbbbbb.kaleidoscopecookery.crafting.recipe.PotRecipe;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.crafting.CraftingHelper;
import org.jetbrains.annotations.Nullable;

public class PotRecipeSerializer
implements RecipeSerializer<PotRecipe> {
    public PotRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        int time = GsonHelper.m_13824_((JsonObject)json, (String)"time", (int)200);
        int stirFryCount = GsonHelper.m_13824_((JsonObject)json, (String)"stir_fry_count", (int)3);
        Ingredient carrier = json.has("carrier") ? Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"carrier")) : Ingredient.f_43901_;
        JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
        ArrayList inputs = Lists.newArrayList();
        for (JsonElement e : ingredients) {
            inputs.add(Ingredient.m_43917_((JsonElement)e));
        }
        ItemStack result = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (boolean)true, (boolean)true);
        return new PotRecipe(recipeId, time, stirFryCount, carrier, inputs, result);
    }

    @Nullable
    public PotRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buf) {
        int time = buf.m_130242_();
        int stirFryCount = buf.m_130242_();
        Ingredient carrier = Ingredient.m_43940_((FriendlyByteBuf)buf);
        int ingredientsSize = buf.m_130242_();
        ArrayList inputs = Lists.newArrayList();
        for (int i = 0; i < ingredientsSize; ++i) {
            inputs.add(Ingredient.m_43940_((FriendlyByteBuf)buf));
        }
        ItemStack result = buf.m_130267_();
        return new PotRecipe(recipeId, time, stirFryCount, carrier, inputs, result);
    }

    public void toNetwork(FriendlyByteBuf buf, PotRecipe recipe) {
        buf.m_130130_(recipe.time());
        buf.m_130130_(recipe.stirFryCount());
        recipe.carrier().m_43923_(buf);
        buf.m_130130_(recipe.m_7527_().size());
        recipe.m_7527_().forEach(i -> i.m_43923_(buf));
        buf.m_130055_(recipe.result());
    }
}

