/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.crafting.serializer;

import com.github.ysbbbbbb.kaleidoscopecookery.crafting.recipe.StockpotRecipe;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModSoupBases;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import org.jetbrains.annotations.Nullable;

public class StockpotRecipeSerializer
implements RecipeSerializer<StockpotRecipe> {
    public static final int DEFAULT_TIME = 300;
    public static final int DEFAULT_COOKING_BUBBLE_COLOR = 16772291;
    public static final int DEFAULT_FINISHED_BUBBLE_COLOR = 16034443;
    public static final Ingredient DEFAULT_CARRIER = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42399_});
    public static final ResourceLocation DEFAULT_SOUP_BASE = ModSoupBases.WATER;
    public static final ResourceLocation EMPTY_ID = new ResourceLocation("kaleidoscope_cookery", "stockpot/empty");
    public static final ResourceLocation DEFAULT_COOKING_TEXTURE = new ResourceLocation("kaleidoscope_cookery", "stockpot/default_cooking");
    public static final ResourceLocation DEFAULT_FINISHED_TEXTURE = new ResourceLocation("kaleidoscope_cookery", "stockpot/default_finished");

    public static StockpotRecipe getEmptyRecipe() {
        return new StockpotRecipe(EMPTY_ID, Lists.newArrayList(), DEFAULT_SOUP_BASE, ItemStack.f_41583_, 300, DEFAULT_CARRIER, DEFAULT_COOKING_TEXTURE, DEFAULT_FINISHED_TEXTURE, 16772291, 16034443);
    }

    public StockpotRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
        ArrayList inputs = Lists.newArrayList();
        for (JsonElement e : ingredients) {
            inputs.add(Ingredient.m_43917_((JsonElement)e));
        }
        ResourceLocation soupBase = DEFAULT_SOUP_BASE;
        if (json.has("soup_base")) {
            soupBase = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"soup_base"));
        }
        ItemStack result = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (boolean)true, (boolean)true);
        int time = GsonHelper.m_13824_((JsonObject)json, (String)"time", (int)300);
        Ingredient carrier = DEFAULT_CARRIER;
        if (json.has("carrier")) {
            carrier = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"carrier"));
        }
        ResourceLocation cookingTexture = new ResourceLocation(GsonHelper.m_13851_((JsonObject)json, (String)"cooking_texture", (String)DEFAULT_COOKING_TEXTURE.toString()));
        ResourceLocation finishedTexture = new ResourceLocation(GsonHelper.m_13851_((JsonObject)json, (String)"finished_texture", (String)DEFAULT_FINISHED_TEXTURE.toString()));
        int cookingBubbleColor = GsonHelper.m_13824_((JsonObject)json, (String)"cooking_bubble_color", (int)16772291);
        int finishedBubbleColor = GsonHelper.m_13824_((JsonObject)json, (String)"finished_bubble_color", (int)16034443);
        return new StockpotRecipe(recipeId, inputs, soupBase, result, time, carrier, cookingTexture, finishedTexture, cookingBubbleColor, finishedBubbleColor);
    }

    @Nullable
    public StockpotRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buf) {
        int ingredientsSize = buf.m_130242_();
        ArrayList inputs = Lists.newArrayList();
        for (int i = 0; i < ingredientsSize; ++i) {
            inputs.add(Ingredient.m_43940_((FriendlyByteBuf)buf));
        }
        ResourceLocation soupBase = buf.m_130281_();
        ItemStack result = buf.m_130267_();
        int time = buf.m_130242_();
        Ingredient carrier = Ingredient.m_43940_((FriendlyByteBuf)buf);
        ResourceLocation cookingTexture = buf.m_130281_();
        ResourceLocation finishedTexture = buf.m_130281_();
        int cookingBubbleColor = buf.m_130242_();
        int finishedBubbleColor = buf.m_130242_();
        return new StockpotRecipe(recipeId, inputs, soupBase, result, time, carrier, cookingTexture, finishedTexture, cookingBubbleColor, finishedBubbleColor);
    }

    public void toNetwork(FriendlyByteBuf buffer, StockpotRecipe recipe) {
        buffer.m_130130_(recipe.m_7527_().size());
        recipe.m_7527_().forEach(i -> i.m_43923_(buffer));
        buffer.m_130085_(recipe.soupBase());
        buffer.m_130055_(recipe.result());
        buffer.m_130130_(recipe.time());
        recipe.carrier().m_43923_(buffer);
        buffer.m_130085_(recipe.cookingTexture());
        buffer.m_130085_(recipe.finishedTexture());
        buffer.m_130130_(recipe.cookingBubbleColor());
        buffer.m_130130_(recipe.finishedBubbleColor());
    }
}

