/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.datagen.builder;

import com.github.ysbbbbbb.kaleidoscopecookery.init.ModRecipes;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public class PotRecipeBuilder
implements RecipeBuilder {
    private static final String NAME = "pot";
    private int time = 200;
    private int stirFryCount = 3;
    private Ingredient carrier = Ingredient.f_43901_;
    private List<Ingredient> ingredients = Lists.newArrayList();
    private ItemStack result = ItemStack.f_41583_;

    public static PotRecipeBuilder builder() {
        return new PotRecipeBuilder();
    }

    public PotRecipeBuilder setTime(int time) {
        this.time = time;
        return this;
    }

    public PotRecipeBuilder setStirFryCount(int stirFryCount) {
        this.stirFryCount = stirFryCount;
        return this;
    }

    public PotRecipeBuilder setCarrier(Ingredient ingredient) {
        this.carrier = ingredient;
        return this;
    }

    public PotRecipeBuilder setCarrier(TagKey<Item> tagKey) {
        this.carrier = Ingredient.m_204132_(tagKey);
        return this;
    }

    public PotRecipeBuilder setCarrier(ItemLike itemLike) {
        this.carrier = Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike});
        return this;
    }

    public PotRecipeBuilder setBowlCarrier() {
        this.carrier = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42399_});
        return this;
    }

    public PotRecipeBuilder addInput(Object ... ingredients) {
        for (Object ingredient : ingredients) {
            if (ingredient instanceof ItemLike) {
                ItemLike itemLike = (ItemLike)ingredient;
                this.ingredients.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike}));
                continue;
            }
            if (ingredient instanceof ItemStack) {
                ItemStack stack = (ItemStack)ingredient;
                this.ingredients.add(Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack}));
                continue;
            }
            if (ingredient instanceof TagKey) {
                TagKey tagKey = (TagKey)ingredient;
                this.ingredients.add(Ingredient.m_204132_((TagKey)tagKey));
                continue;
            }
            if (ingredient instanceof Ingredient) {
                Ingredient ingredientObj = (Ingredient)ingredient;
                this.ingredients.add(ingredientObj);
                continue;
            }
            if (!(ingredient instanceof RegistryObject)) continue;
            RegistryObject registryObject = (RegistryObject)ingredient;
            this.ingredients.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)registryObject.get()}));
        }
        return this;
    }

    public PotRecipeBuilder setResult(Item result) {
        this.result = new ItemStack((ItemLike)result);
        return this;
    }

    public PotRecipeBuilder setResult(ResourceLocation result) {
        this.result = new ItemStack((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(result)));
        return this;
    }

    public PotRecipeBuilder setResult(Item result, int count) {
        this.result = new ItemStack((ItemLike)result, count);
        return this;
    }

    public PotRecipeBuilder setResult(ResourceLocation result, int count) {
        this.result = new ItemStack((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(result)), count);
        return this;
    }

    public PotRecipeBuilder setResult(ItemStack result) {
        this.result = result;
        return this;
    }

    public RecipeBuilder m_126132_(String criterionName, CriterionTriggerInstance criterionTrigger) {
        return this;
    }

    public RecipeBuilder m_126145_(@Nullable String groupName) {
        return this;
    }

    public Item m_142372_() {
        return this.result.m_41720_();
    }

    public void m_176498_(Consumer<FinishedRecipe> output) {
        String path = RecipeBuilder.m_176493_((ItemLike)this.m_142372_()).m_135815_();
        ResourceLocation filePath = new ResourceLocation("kaleidoscope_cookery", "pot/" + path);
        this.m_126140_(output, filePath);
    }

    public void m_176500_(Consumer<FinishedRecipe> output, String recipeId) {
        ResourceLocation filePath = new ResourceLocation("kaleidoscope_cookery", "pot/" + recipeId);
        this.m_126140_(output, filePath);
    }

    public void m_126140_(Consumer<FinishedRecipe> recipeOutput, ResourceLocation id) {
        recipeOutput.accept(new PotFinishedRecipe(id, this.time, this.stirFryCount, this.carrier, this.ingredients, this.result));
    }

    public static class PotFinishedRecipe
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final int time;
        private final int stirFryCount;
        private final Ingredient carrier;
        private final List<Ingredient> ingredients;
        private final ItemStack result;

        public PotFinishedRecipe(ResourceLocation id, int time, int stirFryCount, Ingredient carrier, List<Ingredient> ingredients, ItemStack result) {
            this.id = id;
            this.time = time;
            this.stirFryCount = stirFryCount;
            this.carrier = carrier;
            this.ingredients = ingredients;
            this.result = result;
        }

        public void m_7917_(JsonObject json) {
            json.addProperty("time", (Number)this.time);
            json.addProperty("stir_fry_count", (Number)this.stirFryCount);
            if (!this.carrier.m_43947_()) {
                json.add("carrier", this.carrier.m_43942_());
            }
            JsonArray ingredientsJson = new JsonArray();
            this.ingredients.stream().filter(i -> i != Ingredient.f_43901_).forEach(i -> ingredientsJson.add(i.m_43942_()));
            json.add("ingredients", (JsonElement)ingredientsJson);
            JsonObject itemJson = new JsonObject();
            itemJson.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)this.result.m_41720_())).toString());
            if (this.result.m_41613_() > 1) {
                itemJson.addProperty("count", (Number)this.result.m_41613_());
            }
            json.add("result", (JsonElement)itemJson);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModRecipes.POT_SERIALIZER.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

