/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.datagen.builder;

import com.github.ysbbbbbb.kaleidoscopecookery.crafting.serializer.StockpotRecipeSerializer;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModRecipes;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public class StockpotRecipeBuilder
implements RecipeBuilder {
    private static final String NAME = "stockpot";
    private List<Ingredient> ingredients = Lists.newArrayList();
    private ItemStack result = ItemStack.f_41583_;
    private int time = 300;
    private Ingredient carrier = StockpotRecipeSerializer.DEFAULT_CARRIER;
    private ResourceLocation soupBase = StockpotRecipeSerializer.DEFAULT_SOUP_BASE;
    private ResourceLocation cookingTexture = StockpotRecipeSerializer.DEFAULT_COOKING_TEXTURE;
    private ResourceLocation finishedTexture = StockpotRecipeSerializer.DEFAULT_FINISHED_TEXTURE;
    private int cookingBubbleColor = 16772291;
    private int finishedBubbleColor = 16034443;

    public static StockpotRecipeBuilder builder() {
        return new StockpotRecipeBuilder();
    }

    public StockpotRecipeBuilder addInput(Object ... ingredients) {
        for (Object ingredient : ingredients) {
            if (ingredient instanceof ItemLike) {
                ItemLike itemLike = (ItemLike)ingredient;
                this.ingredients.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike}));
                continue;
            }
            if (ingredient instanceof ItemStack) {
                ItemStack stack = (ItemStack)ingredient;
                this.ingredients.add(Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack}));
                continue;
            }
            if (ingredient instanceof TagKey) {
                TagKey tagKey = (TagKey)ingredient;
                this.ingredients.add(Ingredient.m_204132_((TagKey)tagKey));
                continue;
            }
            if (ingredient instanceof Ingredient) {
                Ingredient ingredientObj = (Ingredient)ingredient;
                this.ingredients.add(ingredientObj);
                continue;
            }
            if (!(ingredient instanceof RegistryObject)) continue;
            this.ingredients.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)((RegistryObject)ingredient).get()}));
        }
        return this;
    }

    public StockpotRecipeBuilder setSoupBase(ResourceLocation soupBase) {
        this.soupBase = soupBase;
        return this;
    }

    public StockpotRecipeBuilder setResult(Item result) {
        this.result = new ItemStack((ItemLike)result, 3);
        return this;
    }

    public StockpotRecipeBuilder setResult(Item result, int count) {
        return this.setResult(new ItemStack((ItemLike)result, count));
    }

    public StockpotRecipeBuilder setResult(ResourceLocation result) {
        this.result = new ItemStack((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(result)));
        return this;
    }

    public StockpotRecipeBuilder setResult(ItemStack result) {
        this.result = result;
        return this;
    }

    public StockpotRecipeBuilder setTime(int time) {
        this.time = time;
        return this;
    }

    public StockpotRecipeBuilder setCarrier(ItemLike carrier) {
        this.carrier = Ingredient.m_43929_((ItemLike[])new ItemLike[]{carrier});
        return this;
    }

    public StockpotRecipeBuilder setCookingTexture(ResourceLocation cookingTexture) {
        this.cookingTexture = cookingTexture;
        return this;
    }

    public StockpotRecipeBuilder setFinishedTexture(ResourceLocation finishedTexture) {
        this.finishedTexture = finishedTexture;
        return this;
    }

    public StockpotRecipeBuilder setCookingBubbleColor(int cookingBubbleColor) {
        this.cookingBubbleColor = cookingBubbleColor;
        return this;
    }

    public StockpotRecipeBuilder setFinishedBubbleColor(int finishedBubbleColor) {
        this.finishedBubbleColor = finishedBubbleColor;
        return this;
    }

    public StockpotRecipeBuilder setBubbleColors(int cookingBubbleColor, int finishedBubbleColor) {
        this.cookingBubbleColor = cookingBubbleColor;
        this.finishedBubbleColor = finishedBubbleColor;
        return this;
    }

    public RecipeBuilder m_126132_(String criterionName, CriterionTriggerInstance criterionTrigger) {
        return this;
    }

    public RecipeBuilder m_126145_(@Nullable String groupName) {
        return this;
    }

    public Item m_142372_() {
        return this.result.m_41720_();
    }

    public void m_176498_(Consumer<FinishedRecipe> output) {
        String path = RecipeBuilder.m_176493_((ItemLike)this.m_142372_()).m_135815_();
        ResourceLocation filePath = new ResourceLocation("kaleidoscope_cookery", "stockpot/" + path);
        this.m_126140_(output, filePath);
    }

    public void m_176500_(Consumer<FinishedRecipe> output, String recipeId) {
        ResourceLocation filePath = new ResourceLocation("kaleidoscope_cookery", "stockpot/" + recipeId);
        this.m_126140_(output, filePath);
    }

    public void m_126140_(Consumer<FinishedRecipe> recipeOutput, ResourceLocation id) {
        recipeOutput.accept(new StockpotFinishedRecipe(id, this.ingredients, this.soupBase, this.result, this.time, this.carrier, this.cookingTexture, this.finishedTexture, this.cookingBubbleColor, this.finishedBubbleColor));
    }

    public static class StockpotFinishedRecipe
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final List<Ingredient> ingredients;
        private final ResourceLocation soupBase;
        private final ItemStack result;
        private final int time;
        private final Ingredient carrier;
        private final ResourceLocation cookingTexture;
        private final ResourceLocation finishedTexture;
        private final int cookingBubbleColor;
        private final int finishedBubbleColor;

        public StockpotFinishedRecipe(ResourceLocation id, List<Ingredient> ingredients, ResourceLocation soupBase, ItemStack result, int time, Ingredient carrier, ResourceLocation cookingTexture, ResourceLocation finishedTexture, int cookingBubbleColor, int finishedBubbleColor) {
            this.id = id;
            this.ingredients = ingredients;
            this.soupBase = soupBase;
            this.result = result;
            this.time = time;
            this.carrier = carrier;
            this.cookingTexture = cookingTexture;
            this.finishedTexture = finishedTexture;
            this.cookingBubbleColor = cookingBubbleColor;
            this.finishedBubbleColor = finishedBubbleColor;
        }

        public void m_7917_(JsonObject json) {
            JsonArray ingredientsJson = new JsonArray();
            this.ingredients.stream().filter(i -> i != Ingredient.f_43901_).forEach(i -> ingredientsJson.add(i.m_43942_()));
            json.add("ingredients", (JsonElement)ingredientsJson);
            json.addProperty("soup_base", this.soupBase.toString());
            JsonObject itemJson = new JsonObject();
            itemJson.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)this.result.m_41720_())).toString());
            if (this.result.m_41613_() > 1) {
                itemJson.addProperty("count", (Number)this.result.m_41613_());
            }
            json.add("result", (JsonElement)itemJson);
            json.addProperty("time", (Number)this.time);
            if (!this.carrier.m_43947_()) {
                json.add("carrier", this.carrier.m_43942_());
            }
            json.addProperty("cooking_texture", this.cookingTexture.toString());
            json.addProperty("finished_texture", this.finishedTexture.toString());
            json.addProperty("cooking_bubble_color", (Number)this.cookingBubbleColor);
            json.addProperty("finished_bubble_color", (Number)this.finishedBubbleColor);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModRecipes.STOCKPOT_SERIALIZER.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

