/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.event;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="kaleidoscope_cookery")
public class AddVillageStructuresEvent {
    private static final ResourceKey<StructureProcessorList> CROP_REPLACE_PROCESSOR_LIST_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_257011_, (ResourceLocation)new ResourceLocation("kaleidoscope_cookery", "crop_replace"));
    private static final ResourceLocation PLAINS = new ResourceLocation("minecraft:village/plains/houses");
    private static final ResourceLocation SNOWY = new ResourceLocation("minecraft:village/snowy/houses");
    private static final ResourceLocation SAVANNA = new ResourceLocation("minecraft:village/savanna/houses");
    private static final ResourceLocation DESERT = new ResourceLocation("minecraft:village/desert/houses");
    private static final ResourceLocation TAIGA = new ResourceLocation("minecraft:village/taiga/houses");

    @SubscribeEvent
    public static void addVillageStructures(ServerAboutToStartEvent event) {
        RegistryAccess.Frozen registryAccess = event.getServer().m_206579_();
        AddVillageStructuresEvent.addBuildingToPool((RegistryAccess)registryAccess, PLAINS, "village/houses/plains_kitchen", 4);
        AddVillageStructuresEvent.addBuildingToPool((RegistryAccess)registryAccess, SNOWY, "village/houses/snowy_kitchen", 4);
        AddVillageStructuresEvent.addBuildingToPool((RegistryAccess)registryAccess, SAVANNA, "village/houses/savanna_kitchen", 4);
        AddVillageStructuresEvent.addBuildingToPool((RegistryAccess)registryAccess, DESERT, "village/houses/desert_kitchen", 4);
        AddVillageStructuresEvent.addBuildingToPool((RegistryAccess)registryAccess, TAIGA, "village/houses/taiga_kitchen", 4);
    }

    public static void addBuildingToPool(RegistryAccess registryAccess, ResourceLocation poolId, String structId, int weight) {
        Optional templatePools = registryAccess.m_6632_(Registries.f_256948_);
        if (templatePools.isEmpty()) {
            return;
        }
        Optional processorLists = registryAccess.m_6632_(Registries.f_257011_);
        if (processorLists.isEmpty()) {
            return;
        }
        StructureTemplatePool pool = (StructureTemplatePool)((Registry)templatePools.get()).m_7745_(poolId);
        if (pool == null) {
            return;
        }
        Holder.Reference holder = ((Registry)processorLists.get()).m_246971_(CROP_REPLACE_PROCESSOR_LIST_KEY);
        ResourceLocation structLocation = new ResourceLocation("kaleidoscope_cookery", structId);
        SinglePoolElement piece = (SinglePoolElement)SinglePoolElement.m_210512_((String)structLocation.toString(), (Holder)holder).apply(StructureTemplatePool.Projection.RIGID);
        for (int i = 0; i < weight; ++i) {
            pool.f_210560_.add((Object)piece);
        }
        ArrayList newRawTemplates = Lists.newArrayList((Iterable)pool.f_210559_);
        newRawTemplates.add(Pair.of((Object)piece, (Object)weight));
        pool.f_210559_ = newRawTemplates;
    }
}

