/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.item;

import com.github.ysbbbbbb.kaleidoscopecookery.block.crop.RiceCropBlock;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeTier;
import org.jetbrains.annotations.Nullable;

public class SickleItem
extends SwordItem {
    private static final ForgeTier SICKLE_TIER = new ForgeTier(1, 2000, 4.0f, 1.0f, 5, BlockTags.f_144286_, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42484_}));

    public SickleItem() {
        super((Tier)SICKLE_TIER, 0, -2.4f, new Item.Properties());
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return super.m_6225_(context);
        }
        Level level = context.m_43725_();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos pos = context.m_8083_();
        int breakCount = 0;
        for (int x = -2; x <= 2; ++x) {
            for (int y = 0; y <= 1; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    if (!this.harvest(pos, x, y, z, level, player)) continue;
                    ++breakCount;
                }
            }
        }
        ItemStack stack = context.m_43722_();
        serverLevel.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12317_, player.m_5720_(), 1.0f, 1.0f);
        player.m_36346_();
        stack.m_41622_(breakCount, (LivingEntity)player, p -> p.m_21166_(EquipmentSlot.MAINHAND));
        player.m_36335_().m_41524_((Item)this, 10);
        return InteractionResult.SUCCESS;
    }

    private boolean harvest(BlockPos pos, int x, int y, int z, Level level, Player player) {
        BlockPos newPos = pos.m_7918_(x, y, z);
        if (!level.m_7966_(player, newPos)) {
            return false;
        }
        BlockState blockState = level.m_8055_(newPos);
        if (blockState.m_60795_()) {
            return false;
        }
        Block block = blockState.m_60734_();
        if (block instanceof CropBlock) {
            CropBlock cropBlock = (CropBlock)block;
            if (block instanceof RiceCropBlock) {
                int position = (Integer)blockState.m_61143_((Property)RiceCropBlock.LOCATION);
                newPos = newPos.m_6625_(position);
                blockState = level.m_8055_(newPos);
            }
            if (cropBlock.m_52307_(blockState)) {
                cropBlock.m_6240_(level, player, newPos, blockState, null, ItemStack.f_41583_);
                BlockState stateForAge = cropBlock.m_52289_(0);
                BooleanProperty waterlogged = BlockStateProperties.f_61362_;
                if (stateForAge.m_61138_((Property)waterlogged)) {
                    stateForAge = (BlockState)stateForAge.m_61124_((Property)waterlogged, (Comparable)((Boolean)blockState.m_61143_((Property)waterlogged)));
                }
                level.m_7731_(newPos, stateForAge, 3);
                level.m_5898_(null, 2001, newPos, Block.m_49956_((BlockState)blockState));
                return true;
            }
            return false;
        }
        if (block instanceof BushBlock && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.f_8941_.m_9280_(newPos);
            level.m_5898_(null, 2001, newPos, Block.m_49956_((BlockState)blockState));
            return true;
        }
        return false;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.kaleidoscope_cookery.sickle").m_130940_(ChatFormatting.GRAY));
    }
}

