/*
 * Decompiled with CFR 0.152.
 */
package com.tryken.trydeas_meleez.block;

import com.tryken.trydeas_meleez.block.entity.InventorTableEntity;
import com.tryken.trydeas_meleez.block.entity.ModBlockEntities;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;

public class InventorTable
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final Map<Direction, VoxelShape> SHAPES = InventorTable.createRotatedShapes();

    public InventorTable() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283818_).m_60913_(2.0f, 4.0f).m_60918_(SoundType.f_56743_).m_278166_(PushReaction.PUSH_ONLY).m_60955_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING});
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPES.get(pState.m_61143_((Property)FACING));
    }

    private static Map<Direction, VoxelShape> createRotatedShapes() {
        VoxelShape shapeNorth = Shapes.m_83040_();
        shapeNorth = Shapes.m_83113_((VoxelShape)shapeNorth, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.75, (double)0.0, (double)1.0, (double)1.0, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shapeNorth = Shapes.m_83113_((VoxelShape)shapeNorth, (VoxelShape)Shapes.m_83048_((double)0.15625, (double)1.0, (double)0.5625, (double)0.84375, (double)1.015625, (double)0.625), (BooleanOp)BooleanOp.f_82695_);
        shapeNorth = Shapes.m_83113_((VoxelShape)shapeNorth, (VoxelShape)Shapes.m_83048_((double)0.15625, (double)1.0, (double)0.1875, (double)0.84375, (double)1.015625, (double)0.25), (BooleanOp)BooleanOp.f_82695_);
        shapeNorth = Shapes.m_83113_((VoxelShape)shapeNorth, (VoxelShape)Shapes.m_83048_((double)0.15625, (double)1.0, (double)0.375, (double)0.84375, (double)1.015625, (double)0.4375), (BooleanOp)BooleanOp.f_82695_);
        shapeNorth = Shapes.m_83113_((VoxelShape)shapeNorth, (VoxelShape)Shapes.m_83048_((double)0.84375, (double)1.0, (double)0.1875, (double)0.90625, (double)1.015625, (double)0.625), (BooleanOp)BooleanOp.f_82695_);
        shapeNorth = Shapes.m_83113_((VoxelShape)shapeNorth, (VoxelShape)Shapes.m_83048_((double)0.09375, (double)1.0, (double)0.1875, (double)0.15625, (double)1.015625, (double)0.625), (BooleanOp)BooleanOp.f_82695_);
        shapeNorth = Shapes.m_83113_((VoxelShape)shapeNorth, (VoxelShape)Shapes.m_83048_((double)0.65625, (double)1.0, (double)0.25, (double)0.71875, (double)1.015625, (double)0.375), (BooleanOp)BooleanOp.f_82695_);
        shapeNorth = Shapes.m_83113_((VoxelShape)shapeNorth, (VoxelShape)Shapes.m_83048_((double)0.46875, (double)1.0, (double)0.25, (double)0.53125, (double)1.015625, (double)0.375), (BooleanOp)BooleanOp.f_82695_);
        shapeNorth = Shapes.m_83113_((VoxelShape)shapeNorth, (VoxelShape)Shapes.m_83048_((double)0.28125, (double)1.0, (double)0.25, (double)0.34375, (double)1.015625, (double)0.375), (BooleanOp)BooleanOp.f_82695_);
        shapeNorth = Shapes.m_83113_((VoxelShape)shapeNorth, (VoxelShape)Shapes.m_83048_((double)0.28125, (double)1.0, (double)0.4375, (double)0.34375, (double)1.015625, (double)0.5625), (BooleanOp)BooleanOp.f_82695_);
        shapeNorth = Shapes.m_83113_((VoxelShape)shapeNorth, (VoxelShape)Shapes.m_83048_((double)0.46875, (double)1.0, (double)0.4375, (double)0.53125, (double)1.015625, (double)0.5625), (BooleanOp)BooleanOp.f_82695_);
        shapeNorth = Shapes.m_83113_((VoxelShape)shapeNorth, (VoxelShape)Shapes.m_83048_((double)0.65625, (double)1.0, (double)0.4375, (double)0.71875, (double)1.015625, (double)0.5625), (BooleanOp)BooleanOp.f_82695_);
        shapeNorth = Shapes.m_83113_((VoxelShape)shapeNorth, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.4375, (double)0.9375, (double)1.0, (double)1.5625, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shapeNorth = Shapes.m_83113_((VoxelShape)shapeNorth, (VoxelShape)Shapes.m_83048_((double)0.065625, (double)0.3125, (double)0.0640625, (double)0.934375, (double)0.4375, (double)0.934375), (BooleanOp)BooleanOp.f_82695_);
        shapeNorth = Shapes.m_83113_((VoxelShape)shapeNorth, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0625, (double)0.1875, (double)0.75, (double)0.1875), (BooleanOp)BooleanOp.f_82695_);
        shapeNorth = Shapes.m_83113_((VoxelShape)shapeNorth, (VoxelShape)Shapes.m_83048_((double)0.8125, (double)0.0, (double)0.0625, (double)0.9375, (double)0.75, (double)0.1875), (BooleanOp)BooleanOp.f_82695_);
        shapeNorth = Shapes.m_83113_((VoxelShape)shapeNorth, (VoxelShape)Shapes.m_83048_((double)0.8125, (double)0.0, (double)0.8125, (double)0.9375, (double)0.75, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shapeNorth = Shapes.m_83113_((VoxelShape)shapeNorth, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.8125, (double)0.1875, (double)0.75, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shapeNorth = shapeNorth.m_83296_();
        VoxelShape shapeEast = InventorTable.rotateShape(shapeNorth, Direction.EAST).m_83296_();
        VoxelShape shapeSouth = InventorTable.rotateShape(shapeNorth, Direction.SOUTH).m_83296_();
        VoxelShape shapeWest = InventorTable.rotateShape(shapeNorth, Direction.WEST).m_83296_();
        return Map.of(Direction.NORTH, shapeNorth, Direction.EAST, shapeEast, Direction.SOUTH, shapeSouth, Direction.WEST, shapeWest);
    }

    private static VoxelShape rotateShape(VoxelShape shape, Direction to) {
        if (to == Direction.NORTH) {
            return shape;
        }
        Stream<VoxelShape> rotatedShapeStream = shape.m_83299_().stream().map(aabb -> {
            double minX = aabb.f_82288_;
            double minY = aabb.f_82289_;
            double minZ = aabb.f_82290_;
            double maxX = aabb.f_82291_;
            double maxY = aabb.f_82292_;
            double maxZ = aabb.f_82293_;
            switch (to) {
                case SOUTH: {
                    return new AABB(1.0 - maxX, minY, 1.0 - maxZ, 1.0 - minX, maxY, 1.0 - minZ);
                }
                case WEST: {
                    return new AABB(minZ, minY, 1.0 - maxX, maxZ, maxY, 1.0 - minX);
                }
                case EAST: {
                    return new AABB(1.0 - maxZ, minY, minX, 1.0 - minZ, maxY, maxX);
                }
            }
            return aabb;
        }).map(Shapes::m_83064_);
        return rotatedShapeStream.reduce(Shapes.m_83040_(), Shapes::m_83110_);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)ModBlockEntities.INVENTOR_TABLE_ENTITY.get()).m_155264_(pPos, pState);
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pState.m_60713_(pNewState.m_60734_())) {
            super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (!pLevel.m_5776_()) {
            BlockEntity entity = pLevel.m_7702_(pPos);
            if (entity instanceof InventorTableEntity) {
                InventorTableEntity inventorTableEntity = (InventorTableEntity)entity;
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)pPlayer), (MenuProvider)inventorTableEntity, (BlockPos)pPos);
            } else {
                throw new IllegalStateException("Entidad de Bloque Inventor Table no encontrada");
            }
        }
        return InteractionResult.SUCCESS;
    }
}

