/*
 * Decompiled with CFR 0.152.
 */
package com.tryken.trydeas_meleez.client.screen;

import com.google.common.collect.Multimap;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.tryken.trydeas_meleez.client.gui.widget.CustomColorButton;
import com.tryken.trydeas_meleez.container.InventorTableContainer;
import com.tryken.trydeas_meleez.network.ModMessages;
import com.tryken.trydeas_meleez.network.PacketCraftItemC2S;
import com.tryken.trydeas_meleez.recipe.GuiRecipeLoader;
import com.tryken.trydeas_meleez.util.WeaponList;
import com.tryken.trydeas_meleez.util.WeaponStats;
import com.tryken.trydeas_meleez.weapon.ModWeapons;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class InventorTableScreen
extends AbstractContainerScreen<InventorTableContainer> {
    private int lastInventoryUpdateCount = -1;
    private final List<ItemStack[]> recipeDisplayList = new ArrayList<ItemStack[]>();
    private final List<Boolean> ingredientStatusList = new ArrayList<Boolean>();
    private ItemStack hoveredIngredientStack = ItemStack.f_41583_;
    private int hoveredIngredientIndex = -1;
    private final List<String> ingredientTagNames = new ArrayList<String>();
    private static final int INGREDIENT_ROWS = 2;
    private static final int INGREDIENT_COLUMNS = 4;
    private static final int INGREDIENT_SLOT_SIZE = 18;
    private static final ResourceLocation TEXTURE = new ResourceLocation("trydeas_meleez", "textures/gui/inventor_table_gui.png");
    private static final int TEX_W = 255;
    private static final int TEX_H = 166;
    private static final int LIST_X = 12;
    private static final int LIST_Y = 18;
    private static final int LIST_W = 72;
    private static final int LIST_H = 133;
    private static final int ITEM_SIZE = 18;
    private static final int ITEMS_PER_ROW = 4;
    private static final int ROW_H_NEW = 18;
    private static final int BORDER_COLOR = -13421773;
    private static final int BORDER_COLOR_SLOT = -12303292;
    private static final int BORDER_COLOR_OUT = -5855578;
    private static final int ITEM_POS_X = 170;
    private static final int ITEM_POS_Y = 52;
    private static final float ITEM_SCALE = 40.0f;
    private static final int VIEWER_AREA_W = 130;
    private static final int VIEWER_AREA_H = 70;
    private ItemStack hoveredStack = ItemStack.f_41583_;
    private boolean showStats = true;
    private boolean dragging = false;
    private double lastMouseX;
    private double lastMouseY;
    private float rotX = 0.0f;
    private boolean draggingScrollbar = false;
    private float scrollbarDragStartOffset;
    private double scrollbarDragStartY;
    private static final int SCROLLBAR_WIDTH = 6;
    private static final int SCROLLBAR_X_OFFSET = 0;
    private static final int SCROLLBAR_COLOR_TRACK = -13421773;
    private static final int SCROLLBAR_COLOR_THUMB = -7829368;
    private static final int SCROLLBAR_COLOR_THUMB_HOVER = -4473925;
    private List<ItemStack> weaponList = new ArrayList<ItemStack>();
    private int selectedIndex = -1;
    private ItemStack selectedStack = ItemStack.f_41583_;
    private float scrollOffset = 0.0f;
    private Button craftButton;

    private int getDurability(ItemStack stack) {
        return stack.m_41776_() - stack.m_41773_();
    }

    public InventorTableScreen(InventorTableContainer menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.f_97726_ = 255;
        this.f_97727_ = 166;
    }

    public static double getWeaponSpeed(ItemStack stack) {
        Multimap modifiers = stack.m_41638_(EquipmentSlot.MAINHAND);
        Iterator iterator = modifiers.get((Object)Attributes.f_22283_).iterator();
        if (iterator.hasNext()) {
            AttributeModifier modifier = (AttributeModifier)iterator.next();
            return modifier.m_22218_();
        }
        return Attributes.f_22283_.m_22082_();
    }

    private double getWeaponDamage(ItemStack stack) {
        if (stack.m_41619_()) {
            return 0.0;
        }
        Multimap attributes = stack.m_41638_(EquipmentSlot.MAINHAND);
        Collection damageModifiers = attributes.get((Object)Attributes.f_22281_);
        if (damageModifiers.isEmpty()) {
            return 0.0;
        }
        double totalDamage = 0.0;
        for (AttributeModifier modifier : damageModifiers) {
            totalDamage += modifier.m_22218_();
        }
        return totalDamage;
    }

    private void loadRecipeFor(ItemStack weapon) {
        this.recipeDisplayList.clear();
        this.ingredientStatusList.clear();
        this.ingredientTagNames.clear();
        if (weapon == null || weapon.m_41619_()) {
            return;
        }
        List<GuiRecipeLoader.RecipeIngredient> ingredients = GuiRecipeLoader.getRecipeFor(weapon);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        Inventory playerInventory = player.m_150109_();
        for (GuiRecipeLoader.RecipeIngredient ing : ingredients) {
            Ingredient ingredient = ing.ingredient();
            ItemStack[] itemsFromIngredient = ingredient.m_43908_();
            if (itemsFromIngredient.length <= 0) continue;
            this.ingredientTagNames.add(ing.tagName());
            ItemStack[] displayStacks = new ItemStack[itemsFromIngredient.length];
            for (int i = 0; i < itemsFromIngredient.length; ++i) {
                displayStacks[i] = new ItemStack((ItemLike)itemsFromIngredient[i].m_41720_(), ing.count());
            }
            this.recipeDisplayList.add(displayStacks);
            int countNeeded = ing.count();
            int countFound = 0;
            for (ItemStack stackInInventory : playerInventory.f_35974_) {
                if (!ingredient.test(stackInInventory)) continue;
                countFound += stackInInventory.m_41613_();
            }
            this.ingredientStatusList.add(player.m_7500_() || countFound >= countNeeded);
        }
    }

    private void drawScaledString(GuiGraphics g, Component text, int x, int y, int color, float scale) {
        PoseStack ps = g.m_280168_();
        ps.m_85836_();
        ps.m_252880_((float)x, (float)y, 0.0f);
        ps.m_85841_(scale, scale, 1.0f);
        g.m_280614_(this.f_96547_, text, 0, 0, color, false);
        ps.m_85849_();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97728_ = 10;
        this.f_97729_ = 6;
        this.weaponList = WeaponList.WEAPONS_TO_DISPLAY;
        if (!this.weaponList.isEmpty()) {
            this.selectedIndex = 0;
            this.selectedStack = this.weaponList.get(0).m_41777_();
            this.loadRecipeFor(this.selectedStack);
        }
        int buttonX = this.f_97735_ + 166;
        int buttonY = this.f_97736_ + 139;
        int baseColor = -12566464;
        int hoverColor = -11184811;
        this.m_142416_((GuiEventListener)new CustomColorButton(buttonX, buttonY, 65, 14, (Component)Component.m_237115_((String)"gui.trydeas_meleez.inventor_table.craft_button"), this::onCraftButtonPressed, baseColor, hoverColor, -5855578));
    }

    private void onCraftButtonPressed(Button button) {
        Item selectedItem;
        ResourceLocation itemId;
        if (this.selectedIndex != -1 && (itemId = ForgeRegistries.ITEMS.getKey((Object)(selectedItem = this.weaponList.get(this.selectedIndex).m_41720_()))) != null) {
            ModMessages.sendToServer(new PacketCraftItemC2S(itemId));
        }
        this.m_7522_(null);
    }

    protected void m_7286_(GuiGraphics g, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        g.m_280163_(TEXTURE, this.f_97735_, this.f_97736_, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 255, 166);
        this.renderScrollableList(g, mouseX, mouseY);
        this.renderSelectedItem3D(g);
        this.renderIngredientGrid(g, mouseX, mouseY);
        if (this.showStats && this.selectedStack != null) {
            int x = this.f_97735_ + 20;
            int y = this.f_97736_ + 101;
            DecimalFormat df = new DecimalFormat("#.#");
            double damage = this.getWeaponDamage(this.selectedStack) + 1.0;
            String damageText = df.format(damage);
            double speed = InventorTableScreen.getWeaponSpeed(this.selectedStack) + 4.0;
            String speedText = df.format(speed);
            float s = 0.5f;
            float m = 0.65f;
            this.drawScaledString(g, (Component)Component.m_237115_((String)"gui.trydeas_meleez.inventor_table.stats"), x + 84, y + -8, -13421773, m);
            this.drawScaledString(g, (Component)Component.m_237115_((String)"gui.trydeas_meleez.inventor_table.ingredients"), x + 141, y + -8, -13421773, m);
            this.drawScaledString(g, (Component)Component.m_237110_((String)"gui.trydeas_meleez.inventor_table.damage", (Object[])new Object[]{damageText}), x + 87, y + 7, 0xBBBBBB, s);
            this.drawScaledString(g, (Component)Component.m_237110_((String)"gui.trydeas_meleez.inventor_table.durability", (Object[])new Object[]{this.getDurability(this.selectedStack)}), x + 87, y + 14, 0xBBBBBB, s);
            this.drawScaledString(g, (Component)Component.m_237110_((String)"gui.trydeas_meleez.inventor_table.speed", (Object[])new Object[]{speedText}), x + 87, y + 21, 0xBBBBBB, s);
            try {
                Class.forName("net.bettercombat.api.WeaponAttributesHelper");
                double reach = WeaponStats.getReach(this.selectedStack.m_41720_());
                if (reach > 0.0) {
                    this.drawScaledString(g, (Component)Component.m_237110_((String)"gui.trydeas_meleez.inventor_table.reach", (Object[])new Object[]{new DecimalFormat("#.#").format(reach)}), x + 87, y + 28, 0xBBBBBB, s);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    private void renderScrollableList(GuiGraphics g, int mouseX, int mouseY) {
        int itemsToSkip;
        int x = this.f_97735_ + 12;
        int y = this.f_97736_ + 18;
        this.hoveredStack = ItemStack.f_41583_;
        g.m_280509_(x, y, x + 72, y + 133, -13750738);
        g.m_280509_(x - 2, y - 2, x + 72 + 7, y - 1, -5855578);
        g.m_280509_(x - 2, y - 1, x - 1, y + 133 + 2, -5855578);
        g.m_280509_(x + 72 + 1, y - 1, x + 72 + 7, y + 133 + 2, -5855578);
        g.m_280509_(x - 2, y + 133 + 1, x + 72 + 5, y + 133 + 2, -5855578);
        g.m_280509_(x - 1, y - 1, x + 72 + 6, y, -13421773);
        g.m_280509_(x - 1, y, x, y + 133, -13421773);
        g.m_280509_(x - 1, y + 133, x + 72 + 6, y + 133 + 1, -13421773);
        this.enableScissor(x, y, 72, 133);
        int firstRowVisible = (int)(this.scrollOffset / 18.0f);
        for (int i = itemsToSkip = firstRowVisible * 4; i < this.weaponList.size(); ++i) {
            int localIndexInView = i - itemsToSkip;
            int col = localIndexInView % 4;
            int row = localIndexInView / 4;
            int itemRenderX = x + col * 18;
            int itemRenderY = y + row * 18 - (int)(this.scrollOffset % 18.0f);
            if (itemRenderY >= y + 133) break;
            boolean isSelected = i == this.selectedIndex;
            boolean isHover = this.isPointInRect(mouseX, mouseY, itemRenderX, itemRenderY, 18, 18);
            if (isHover) {
                this.hoveredStack = this.weaponList.get(i);
            }
            int bg = isSelected ? -9141634 : (isHover ? 0x22FFFFFF : 0x11000000);
            g.m_280509_(itemRenderX, itemRenderY, itemRenderX + 18, itemRenderY + 18, bg);
            g.m_280509_(itemRenderX + 18 - 1, itemRenderY, itemRenderX + 18, itemRenderY + 18, -12303292);
            g.m_280509_(itemRenderX, itemRenderY + 18 - 1, itemRenderX + 18, itemRenderY + 18, -12303292);
            ItemStack stack = this.weaponList.get(i);
            g.m_280480_(stack, itemRenderX + 1, itemRenderY + 1);
        }
        this.disableScissor();
        int scrollbarX = x + 72 + 0;
        int scrollbarY = y;
        int scrollbarHeight = 133;
        g.m_280509_(scrollbarX, scrollbarY, scrollbarX + 6, scrollbarY + scrollbarHeight, -13421773);
        int totalContentHeight = (int)Math.ceil((double)this.weaponList.size() / 4.0) * 18;
        if (totalContentHeight > 133) {
            float scrollRatio;
            float thumbHeightRatio = 133.0f / (float)totalContentHeight;
            int thumbHeight = (int)((float)scrollbarHeight * thumbHeightRatio);
            int thumbY = scrollbarY + (int)((float)(scrollbarHeight - (thumbHeight = Math.max(10, thumbHeight))) * (scrollRatio = this.scrollOffset / (float)(totalContentHeight - 133)));
            boolean isHoveringScrollbar = this.isPointInRect(mouseX, mouseY, scrollbarX, thumbY, 6, thumbHeight);
            int thumbColor = isHoveringScrollbar ? -4473925 : -7829368;
            g.m_280509_(scrollbarX + 1, thumbY, scrollbarX + 6 - 1, thumbY + thumbHeight, thumbColor);
        }
    }

    private void enableScissor(int x, int y, int w, int h) {
        Minecraft mc = Minecraft.m_91087_();
        Window window = mc.m_91268_();
        double scale = window.m_85449_();
        int sx = (int)((double)x * scale);
        int sy = (int)((double)window.m_85442_() - (double)(y + h) * scale);
        int sw = (int)((double)w * scale);
        int sh = (int)((double)h * scale);
        RenderSystem.enableScissor((int)sx, (int)sy, (int)sw, (int)sh);
    }

    private void disableScissor() {
        RenderSystem.disableScissor();
    }

    private boolean isPointInRect(double mx, double my, int rx, int ry, int rw, int rh) {
        return mx >= (double)rx && mx < (double)(rx + rw) && my >= (double)ry && my < (double)(ry + rh);
    }

    private void renderSelectedItem3D(GuiGraphics g) {
        if (this.selectedStack.m_41619_()) {
            return;
        }
        int viewerX = this.f_97735_ + 170 - 65;
        int viewerY = this.f_97736_ + 52 - 35;
        int viewerWidth = 130;
        int viewerHeight = 70;
        int borderWidth = 1;
        g.m_280509_(viewerX - borderWidth, viewerY - borderWidth, viewerX + viewerWidth + borderWidth, viewerY + viewerHeight + borderWidth, -5855578);
        int backgroundColor = -14540254;
        g.m_280509_(viewerX, viewerY, viewerX + 130, viewerY + 70, backgroundColor);
        int brightnessBaseColor = 0x10DDDDDD;
        int steps = 8;
        for (int i = 0; i < steps; ++i) {
            int inset = (int)((float)i * ((float)Math.min(130, 70) * 0.075f));
            int originalAlpha = brightnessBaseColor >>> 24;
            int alpha = originalAlpha * (steps - i) / steps;
            int colorWithAlpha = alpha << 24 | brightnessBaseColor & 0xFFFFFF;
            g.m_280509_(viewerX + inset, viewerY + inset, viewerX + 130 - inset, viewerY + 70 - inset, colorWithAlpha);
        }
        PoseStack pose = g.m_280168_();
        pose.m_85836_();
        pose.m_252880_((float)(this.f_97735_ + 170), (float)(this.f_97736_ + 52), 100.0f);
        pose.m_85841_(40.0f, 40.0f, 40.0f);
        long time = System.currentTimeMillis() / 20L;
        pose.m_252781_(Axis.f_252436_.m_252977_((float)(time % 360L)));
        pose.m_252781_(Axis.f_252529_.m_252977_(30.0f));
        pose.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        RenderSystem.enableCull();
        if (this.selectedStack.m_150930_((Item)ModWeapons.STOP_SIGN.get())) {
            pose.m_85841_(-1.0f, 1.0f, 1.0f);
        }
        MultiBufferSource.BufferSource renderBuffer = Minecraft.m_91087_().m_91269_().m_110104_();
        Minecraft.m_91087_().m_91291_().m_269128_(this.selectedStack, ItemDisplayContext.FIXED, 0xF000F0, OverlayTexture.f_118083_, pose, (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), (Level)Minecraft.m_91087_().f_91073_, 0);
        RenderSystem.disableCull();
        pose.m_85849_();
    }

    private void renderIngredientGrid(GuiGraphics g, int mouseX, int mouseY) {
        if (this.recipeDisplayList.isEmpty()) {
            return;
        }
        int startX = this.f_97735_ + 162;
        int startY = this.f_97736_ + 101;
        for (int row = 0; row < 2; ++row) {
            for (int col = 0; col < 4; ++col) {
                int index = row * 4 + col;
                if (index >= this.recipeDisplayList.size()) {
                    return;
                }
                int x = startX + col * 18;
                int y = startY + row * 18;
                ItemStack[] displayStacks = this.recipeDisplayList.get(index);
                if (displayStacks.length == 0) continue;
                int displayIndex = (int)(System.currentTimeMillis() / 1000L % (long)displayStacks.length);
                ItemStack stackToRender = displayStacks[displayIndex];
                boolean playerHasIngredient = this.ingredientStatusList.get(index);
                if (!playerHasIngredient) {
                    g.m_280509_(x + 1, y + 1, x + 18, y + 18, 0x55FF0000);
                }
                g.m_280656_(x, x + 18, y, -12303292);
                g.m_280656_(x, x + 18, y + 18, -12303292);
                g.m_280315_(x, y, y + 18, -12303292);
                g.m_280315_(x + 18, y, y + 18, -12303292);
                g.m_280480_(stackToRender, x + 1, y + 1);
                g.m_280370_(this.f_96547_, stackToRender, x + 1, y + 1);
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            float scrollRatio;
            float thumbHeightRatio;
            int thumbHeight;
            int currentThumbY;
            int localX;
            int col;
            int localY;
            int row;
            int clickedIndex;
            int listX = this.f_97735_ + 12;
            int listY = this.f_97736_ + 18;
            if (this.isPointInRect(mouseX, mouseY, listX, listY, 72, 133) && (clickedIndex = (row = (localY = (int)(mouseY - (double)listY + (double)this.scrollOffset)) / 18) * 4 + (col = (localX = (int)(mouseX - (double)listX)) / 18)) >= 0 && clickedIndex < this.weaponList.size()) {
                this.selectedIndex = clickedIndex;
                this.selectedStack = this.weaponList.get(clickedIndex).m_41777_();
                this.loadRecipeFor(this.selectedStack);
                this.f_96541_.f_91074_.m_5496_((SoundEvent)SoundEvents.f_12490_.get(), 0.2f, 1.0f);
                return true;
            }
            int viewerLeft = this.f_97735_ + 170 - 65;
            int viewerTop = this.f_97736_ + 52 - 35;
            if (this.isPointInRect(mouseX, mouseY, viewerLeft, viewerTop, 130, 70)) {
                this.dragging = true;
                this.lastMouseX = mouseX;
                return true;
            }
            int scrollbarX = listX + 72 + 0;
            int scrollbarY = listY;
            int scrollbarHeight = 133;
            int totalContentHeight = (int)Math.ceil((double)this.weaponList.size() / 4.0) * 18;
            if (totalContentHeight > 133 && this.isPointInRect(mouseX, mouseY, scrollbarX, currentThumbY = scrollbarY + (int)((float)(scrollbarHeight - (thumbHeight = (int)Math.max(10.0f, (float)scrollbarHeight * (thumbHeightRatio = 133.0f / (float)totalContentHeight)))) * (scrollRatio = this.scrollOffset / (float)(totalContentHeight - 133))), 6, thumbHeight)) {
                this.draggingScrollbar = true;
                this.scrollbarDragStartY = mouseY;
                this.scrollbarDragStartOffset = this.scrollOffset;
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.dragging = false;
            this.draggingScrollbar = false;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.dragging && button == 0) {
            this.rotX += (float)(mouseX - this.lastMouseX);
            this.lastMouseX = mouseX;
            return true;
        }
        if (this.draggingScrollbar && button == 0) {
            int y;
            int x = this.f_97735_ + 12;
            int scrollbarY = y = this.f_97736_ + 18;
            int scrollbarHeight = 133;
            int totalContentHeight = (int)Math.ceil((double)this.weaponList.size() / 4.0) * 18;
            int maxScroll = Math.max(0, totalContentHeight - 133);
            float thumbHeightRatio = 133.0f / (float)totalContentHeight;
            int thumbHeight = (int)((float)scrollbarHeight * thumbHeightRatio);
            thumbHeight = Math.max(10, thumbHeight);
            double dragDeltaY = mouseY - this.scrollbarDragStartY;
            float scrollFactor = (float)maxScroll / (float)(scrollbarHeight - thumbHeight);
            float newScrollOffset = this.scrollbarDragStartOffset + (float)(dragDeltaY * (double)scrollFactor);
            this.scrollOffset = Math.max(0.0f, Math.min((float)maxScroll, newScrollOffset));
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int x = this.f_97735_ + 12;
        int y = this.f_97736_ + 18;
        if (this.isPointInRect(mouseX, mouseY, x, y, 72, 133)) {
            int totalRows = (int)Math.ceil((double)this.weaponList.size() / 4.0);
            int contentHeight = totalRows * 18;
            int maxScroll = Math.max(0, contentHeight - 133);
            this.scrollOffset = (float)Math.max(0.0, Math.min((double)maxScroll, (double)this.scrollOffset - delta * 18.0));
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private List<Component> getHoveredTooltipLines(ItemStack stack) {
        List tooltipLines = stack.m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)TooltipFlag.f_256752_);
        if (!tooltipLines.isEmpty()) {
            return List.of((Component)tooltipLines.get(0));
        }
        return List.of();
    }

    public void m_181908_() {
        super.m_181908_();
        Inventory playerInventory = Minecraft.m_91087_().f_91074_.m_150109_();
        if (playerInventory.m_36072_() != this.lastInventoryUpdateCount) {
            this.loadRecipeFor(this.selectedStack);
            this.lastInventoryUpdateCount = playerInventory.m_36072_();
        }
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        this.hoveredIngredientStack = ItemStack.f_41583_;
        this.hoveredIngredientIndex = -1;
        this.m_280273_(g);
        if (!this.recipeDisplayList.isEmpty()) {
            int startX = this.f_97735_ + 162;
            int startY = this.f_97736_ + 101;
            for (int row = 0; row < 2; ++row) {
                for (int col = 0; col < 4; ++col) {
                    int y;
                    int x;
                    int index = row * 4 + col;
                    if (index >= this.recipeDisplayList.size() || !this.isPointInRect(mouseX, mouseY, x = startX + col * 18, y = startY + row * 18, 18, 18)) continue;
                    ItemStack[] displayStacks = this.recipeDisplayList.get(index);
                    int displayIndex = (int)(System.currentTimeMillis() / 1000L % (long)displayStacks.length);
                    this.hoveredIngredientStack = displayStacks[displayIndex];
                    this.hoveredIngredientIndex = index;
                }
            }
        }
        super.m_88315_(g, mouseX, mouseY, partialTick);
        if (!this.hoveredIngredientStack.m_41619_() && this.hoveredIngredientIndex != -1) {
            String tagName = this.ingredientTagNames.get(this.hoveredIngredientIndex);
            if (tagName != null) {
                ArrayList<Object> tooltipLines = new ArrayList<Object>();
                tooltipLines.add(this.hoveredIngredientStack.m_41786_());
                tooltipLines.add(Component.m_237113_((String)""));
                String boniatoTagName = tagName;
                tooltipLines.add(Component.m_237110_((String)"gui.trydeas_meleez.tooltip.accepts_tag", (Object[])new Object[]{boniatoTagName}).m_130940_(ChatFormatting.GRAY));
                ItemStack[] allItems = this.recipeDisplayList.get(this.hoveredIngredientIndex);
                int limit = 5;
                for (int i = 0; i < Math.min(allItems.length, limit); ++i) {
                    tooltipLines.add(Component.m_237113_((String)" - ").m_7220_(allItems[i].m_41786_()).m_130940_(ChatFormatting.DARK_GRAY));
                }
                if (allItems.length > limit) {
                    tooltipLines.add(Component.m_237110_((String)"gui.trydeas_meleez.tooltip.and_x_more", (Object[])new Object[]{allItems.length - limit}).m_130940_(ChatFormatting.DARK_GRAY));
                }
                g.m_280677_(this.f_96547_, tooltipLines, Optional.empty(), mouseX, mouseY);
            } else {
                g.m_280153_(this.f_96547_, this.hoveredIngredientStack, mouseX, mouseY);
            }
        } else if (!this.hoveredStack.m_41619_()) {
            g.m_280677_(this.f_96547_, this.getHoveredTooltipLines(this.hoveredStack), Optional.empty(), mouseX, mouseY);
        }
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, 0x404040, false);
        if (!this.selectedStack.m_41619_()) {
            Component weaponName = this.selectedStack.m_41786_();
            int color = 0x404040;
            int centerPointX = 170;
            int textWidth = this.f_96547_.m_92852_((FormattedText)weaponName);
            float scale = 1.0f;
            int maxAllowedWidth = (centerPointX - (this.f_97728_ + this.f_96547_.m_92852_((FormattedText)this.f_96539_) + 5)) * 2;
            if (textWidth > maxAllowedWidth) {
                scale = (float)maxAllowedWidth / (float)textWidth;
                scale = Math.max(0.5f, scale);
            }
            int scaledWidth = (int)((float)textWidth * scale);
            int finalX = centerPointX - scaledWidth / 2;
            Objects.requireNonNull(this.f_96547_);
            int finalY = this.f_97729_ + (int)((1.0f - scale) * (9.0f / 2.0f));
            PoseStack ps = guiGraphics.m_280168_();
            ps.m_85836_();
            ps.m_252880_((float)finalX, (float)finalY, 0.0f);
            ps.m_85841_(scale, scale, 1.0f);
            guiGraphics.m_280614_(this.f_96547_, weaponName, 0, 0, color, false);
            ps.m_85849_();
        }
    }
}

