/*
 * Decompiled with CFR 0.152.
 */
package com.tryken.trydeas_meleez.compat.jei;

import com.tryken.trydeas_meleez.block.ModBlocks;
import com.tryken.trydeas_meleez.recipe.GuiRecipeLoader;
import java.util.ArrayList;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class InventorTableRecipeCategory
implements IRecipeCategory<GuiRecipeLoader.RecipeDefinition> {
    public static final ResourceLocation UID = new ResourceLocation("trydeas_meleez", "inventor_crafting");
    public static final RecipeType<GuiRecipeLoader.RecipeDefinition> RECIPE_TYPE = new RecipeType(UID, GuiRecipeLoader.RecipeDefinition.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable craftingArrow;
    private final IGuiHelper guiHelper;

    public InventorTableRecipeCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
        this.background = guiHelper.createBlankDrawable(170, 50);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.INVENTOR_TABLE.get()));
        this.craftingArrow = guiHelper.createDrawable(new ResourceLocation("minecraft", "textures/gui/container/furnace.png"), 79, 35, 24, 17);
    }

    public RecipeType<GuiRecipeLoader.RecipeDefinition> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.m_237113_((String)"Inventor Table");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, GuiRecipeLoader.RecipeDefinition recipe, IFocusGroup focuses) {
        boolean singleRow = recipe.ingredients().size() <= 4;
        int startY = singleRow ? 16 : 8;
        int startX = 20;
        int slotIndex = 0;
        for (GuiRecipeLoader.RecipeIngredient ingredient : recipe.ingredients()) {
            int x = startX + slotIndex % 4 * 18;
            int y = startY + slotIndex / 4 * 18;
            ItemStack[] baseItems = ingredient.ingredient().m_43908_();
            ArrayList<ItemStack> itemsWithCount = new ArrayList<ItemStack>();
            for (ItemStack baseItem : baseItems) {
                itemsWithCount.add(new ItemStack((ItemLike)baseItem.m_41720_(), ingredient.count()));
            }
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, x, y).addItemStacks(itemsWithCount)).setBackground((IDrawable)this.guiHelper.getSlotDrawable(), -1, -1);
            ++slotIndex;
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 134, 16).addItemStack(new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(recipe.resultId())))).setBackground((IDrawable)this.guiHelper.getSlotDrawable(), -1, -1);
    }

    public void draw(GuiRecipeLoader.RecipeDefinition recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.craftingArrow.draw(guiGraphics, 98, 15);
    }
}

