/*
 * Decompiled with CFR 0.152.
 */
package com.tryken.trydeas_meleez.recipe;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.registries.ForgeRegistries;

public class GuiRecipeLoader
extends SimpleJsonResourceReloadListener {
    private static final Map<ResourceLocation, RecipeDefinition> RECIPES = new HashMap<ResourceLocation, RecipeDefinition>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static Collection<RecipeDefinition> getAllRecipes() {
        return RECIPES.values();
    }

    public GuiRecipeLoader() {
        super(GSON, "inventor_table_recipes");
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsonMap, ResourceManager resourceManager, ProfilerFiller profiler) {
        RECIPES.clear();
        jsonMap.forEach((id, json) -> {
            try {
                JsonObject obj = GsonHelper.m_13918_((JsonElement)json, (String)"recipe");
                ResourceLocation resultId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)obj, (String)"result"));
                JsonArray ingredientsArray = GsonHelper.m_13933_((JsonObject)obj, (String)"ingredients");
                ArrayList<RecipeIngredient> ingredients = new ArrayList<RecipeIngredient>();
                for (JsonElement el : ingredientsArray) {
                    JsonObject ingObj = el.getAsJsonObject();
                    JsonObject ingredientJson = GsonHelper.m_13930_((JsonObject)ingObj, (String)"ingredient");
                    Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredientJson);
                    int count = GsonHelper.m_13824_((JsonObject)ingObj, (String)"count", (int)1);
                    String tagName = null;
                    if (ingredientJson.has("tag")) {
                        tagName = GsonHelper.m_13906_((JsonObject)ingredientJson, (String)"tag");
                    }
                    ingredients.add(new RecipeIngredient(ingredient, count, tagName));
                }
                RECIPES.put(resultId, new RecipeDefinition(resultId, ingredients));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public static List<RecipeIngredient> getRecipeFor(ItemStack stack) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        if (id == null) {
            return Collections.emptyList();
        }
        RecipeDefinition def = RECIPES.get(id);
        return def != null ? def.ingredients() : Collections.emptyList();
    }

    public static RecipeDefinition getRecipeByItemId(ResourceLocation resultId) {
        return RECIPES.get(resultId);
    }

    public static boolean playerHasIngredients(Player player, RecipeDefinition recipe) {
        for (RecipeIngredient required : recipe.ingredients()) {
            int countNeeded = required.count();
            int countFound = 0;
            for (ItemStack stackInInventory : player.m_150109_().f_35974_) {
                if (!required.ingredient().test(stackInInventory)) continue;
                countFound += stackInInventory.m_41613_();
            }
            if (countFound >= countNeeded) continue;
            return false;
        }
        return true;
    }

    public static void consumeIngredients(Player player, RecipeDefinition recipe) {
        block0: for (RecipeIngredient required : recipe.ingredients()) {
            int countToRemove = required.count();
            for (ItemStack stackInInventory : player.m_150109_().f_35974_) {
                if (countToRemove <= 0) continue block0;
                if (!required.ingredient().test(stackInInventory)) continue;
                int amountToRemove = Math.min(stackInInventory.m_41613_(), countToRemove);
                stackInInventory.m_41774_(amountToRemove);
                countToRemove -= amountToRemove;
            }
        }
    }

    public record RecipeDefinition(ResourceLocation resultId, List<RecipeIngredient> ingredients) {
    }

    public record RecipeIngredient(Ingredient ingredient, int count, @Nullable String tagName) {
    }
}

