/*
 * Decompiled with CFR 0.152.
 */
package com.tryken.trydeas_meleez.recipe;

import com.tryken.trydeas_meleez.item.ModItems;
import com.tryken.trydeas_meleez.recipe.ModRecipes;
import com.tryken.trydeas_meleez.util.ModTags;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class RefinedChromiteRecipe
extends CustomRecipe {
    public RefinedChromiteRecipe(ResourceLocation pId, CraftingBookCategory pCategory) {
        super(pId, pCategory);
    }

    public boolean matches(CraftingContainer pContainer, Level pLevel) {
        boolean hasChromite = false;
        boolean hasHammer = false;
        int nonEmptyCount = 0;
        for (int i = 0; i < pContainer.m_6643_(); ++i) {
            ItemStack stack = pContainer.m_8020_(i);
            if (stack.m_41619_()) continue;
            ++nonEmptyCount;
            if (stack.m_150930_((Item)ModItems.CHROMITE.get())) {
                hasChromite = true;
                continue;
            }
            if (stack.m_204117_(ModTags.Items.HAMMERS) && stack.m_41763_()) {
                hasHammer = true;
                continue;
            }
            return false;
        }
        return hasChromite && hasHammer && nonEmptyCount == 2;
    }

    public ItemStack assemble(CraftingContainer pContainer, RegistryAccess pRegistryAccess) {
        return new ItemStack((ItemLike)ModItems.REFINED_CHROMITE.get());
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer pContainer) {
        NonNullList remainingItems = NonNullList.m_122780_((int)pContainer.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < remainingItems.size(); ++i) {
            ItemStack stack = pContainer.m_8020_(i);
            if (!stack.m_204117_(ModTags.Items.HAMMERS) || !stack.m_41763_()) continue;
            remainingItems.set(i, (Object)stack.m_41777_());
        }
        return remainingItems;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return new ItemStack((ItemLike)ModItems.REFINED_CHROMITE.get());
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return pWidth * pHeight >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.REFINED_CHROMITE_SERIALIZER.get();
    }

    public static class Serializer
    extends SimpleCraftingRecipeSerializer<RefinedChromiteRecipe> {
        public Serializer() {
            super(RefinedChromiteRecipe::new);
        }
    }
}

