/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import top.ribs.scguns.blockentity.AdvancedComposterBlockEntity;
import top.ribs.scguns.init.ModBlockEntities;
import top.ribs.scguns.init.ModParticleTypes;
import top.ribs.scguns.init.ModTags;

public class AdvancedComposterBlock
extends BaseEntityBlock {
    public static final IntegerProperty LEVEL = IntegerProperty.m_61631_((String)"level", (int)0, (int)11);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final VoxelShape INSIDE = Block.m_49796_((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
    private static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0), Block.m_49796_((double)14.0, (double)4.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.m_49796_((double)2.0, (double)4.0, (double)0.0, (double)14.0, (double)14.0, (double)2.0), Block.m_49796_((double)2.0, (double)4.0, (double)14.0, (double)14.0, (double)14.0, (double)16.0)});

    public AdvancedComposterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(0))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter level, BlockPos pos) {
        return INSIDE;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new AdvancedComposterBlockEntity(pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LEVEL, FACING});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return AdvancedComposterBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.ADVANCED_COMPOSTER.get()), AdvancedComposterBlock::tick);
    }

    private static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        if (blockEntity instanceof AdvancedComposterBlockEntity) {
            AdvancedComposterBlockEntity composter = (AdvancedComposterBlockEntity)blockEntity;
            composter.tick(level, pos, state);
        }
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if ((Integer)state.m_61143_((Property)LEVEL) == 7) {
            level.m_186460_(pos, (Block)this, 20);
        }
    }

    public BlockState addItem(Player player, BlockState state, Level level, BlockPos pos, ItemStack stack) {
        int currentLevel = (Integer)state.m_61143_((Property)LEVEL);
        float chance = this.getCompostChance(stack);
        if ((currentLevel != 0 || chance > 0.0f) && level.f_46441_.m_188500_() < (double)chance) {
            BlockEntity blockEntity;
            int newLevel = Math.min(7, currentLevel + 1);
            BlockState newState = (BlockState)state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(newLevel));
            level.m_7731_(pos, newState, 3);
            if (newLevel == 7 && (blockEntity = level.m_7702_(pos)) instanceof AdvancedComposterBlockEntity) {
                ((AdvancedComposterBlockEntity)blockEntity).startComposting();
            }
            this.playComposterEffects(level, pos, state);
            return newState;
        }
        return state;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        if ((Integer)state.m_61143_((Property)LEVEL) < 7 && this.isCompostable(heldItem)) {
            BlockState newState;
            if (!level.f_46443_ && state != (newState = this.addItem(player, state, level, pos, heldItem))) {
                player.m_36246_(Stats.f_12982_.m_12902_((Object)heldItem.m_41720_()));
                if (!player.m_150110_().f_35937_) {
                    heldItem.m_41774_(1);
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if ((Integer)state.m_61143_((Property)LEVEL) >= 8) {
            if (!level.f_46443_) {
                return this.extractProduce(player, state, level, pos);
            }
            return InteractionResult.m_19078_((boolean)true);
        }
        return InteractionResult.PASS;
    }

    private InteractionResult extractProduce(Player player, BlockState state, Level level, BlockPos pos) {
        AdvancedComposterBlockEntity composter;
        boolean extracted;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof AdvancedComposterBlockEntity && (extracted = (composter = (AdvancedComposterBlockEntity)blockEntity).extractOneItem(player))) {
            level.m_5594_(null, pos, SoundEvents.f_11763_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(composter.getVisualLevel())), 3);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof AdvancedComposterBlockEntity) {
                ((AdvancedComposterBlockEntity)blockEntity).drops();
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        return (Integer)blockState.m_61143_((Property)LEVEL);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        int currentLevel = (Integer)state.m_61143_((Property)LEVEL);
        if (currentLevel > 0) {
            int particleChance;
            double d0 = (double)pos.m_123341_() + 0.5;
            double d1 = (double)pos.m_123342_() + 1.0;
            double d2 = (double)pos.m_123343_() + 0.5;
            int n = particleChance = currentLevel == 7 ? 10 : 5;
            if (random.m_188503_(particleChance) == 0) {
                double offsetX = (random.m_188500_() - 0.5) * 0.5;
                double offsetZ = (random.m_188500_() - 0.5) * 0.5;
                double offsetY = random.m_188500_() * 0.1;
                level.m_7106_((ParticleOptions)ModParticleTypes.SULFUR_DUST.get(), d0 + offsetX, d1 + offsetY, d2 + offsetZ, 0.0, 0.03, 0.0);
            }
        }
    }

    public void playComposterEffects(Level level, BlockPos pos, BlockState state) {
        if (!level.f_46443_) {
            level.m_46796_(1500, pos, (Integer)state.m_61143_((Property)LEVEL) > 0 ? 1 : 0);
        }
    }

    public boolean isCompostable(ItemStack stack) {
        return stack.m_204117_(ModTags.Items.WEAK_COMPOST) || stack.m_204117_(ModTags.Items.NORMAL_COMPOST) || stack.m_204117_(ModTags.Items.STRONG_COMPOST);
    }

    private float getCompostChance(ItemStack stack) {
        if (stack.m_204117_(ModTags.Items.WEAK_COMPOST)) {
            return 0.4f;
        }
        if (stack.m_204117_(ModTags.Items.NORMAL_COMPOST)) {
            return 0.6f;
        }
        if (stack.m_204117_(ModTags.Items.STRONG_COMPOST)) {
            return 0.8f;
        }
        return 0.0f;
    }
}

