/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import top.ribs.scguns.block.AutoTurretBlock;
import top.ribs.scguns.block.BasicTurretBlock;
import top.ribs.scguns.block.ShotgunTurretBlock;
import top.ribs.scguns.block.SniperTurretBlock;

public abstract class BaseTurretModuleBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty CONNECTED = BooleanProperty.m_61465_((String)"connected");
    protected static final VoxelShape SHAPE_CENTERED = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)7.0, (double)14.0);
    protected static final VoxelShape SHAPE_CONNECTED_NORTH = Block.m_49796_((double)2.0, (double)0.0, (double)6.0, (double)14.0, (double)7.0, (double)16.0);
    protected static final VoxelShape SHAPE_CONNECTED_SOUTH = Block.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)7.0, (double)10.0);
    protected static final VoxelShape SHAPE_CONNECTED_EAST = Block.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)10.0, (double)7.0, (double)14.0);
    protected static final VoxelShape SHAPE_CONNECTED_WEST = Block.m_49796_((double)6.0, (double)0.0, (double)2.0, (double)16.0, (double)7.0, (double)14.0);

    public BaseTurretModuleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)CONNECTED, (Comparable)Boolean.valueOf(false)));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, CONNECTED});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Level world = context.m_43725_();
        Direction facing = context.m_8125_().m_122424_();
        boolean isConnected = this.isAdjacentToTurret((BlockGetter)world, pos);
        if (isConnected && world instanceof Level) {
            Level level = world;
            level.m_5594_(null, pos, SoundEvents.f_12444_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)CONNECTED, (Comparable)Boolean.valueOf(isConnected));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        boolean connected = (Boolean)state.m_61143_((Property)CONNECTED);
        if (connected) {
            return switch (facing) {
                case Direction.NORTH -> SHAPE_CONNECTED_NORTH;
                case Direction.SOUTH -> SHAPE_CONNECTED_SOUTH;
                case Direction.EAST -> SHAPE_CONNECTED_EAST;
                case Direction.WEST -> SHAPE_CONNECTED_WEST;
                default -> SHAPE_CENTERED;
            };
        }
        return SHAPE_CENTERED;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos neighborPos, boolean isMoving) {
        super.m_6861_(state, world, pos, block, neighborPos, isMoving);
        if (!world.f_46443_) {
            boolean isConnected = this.isAdjacentToTurret((BlockGetter)world, pos);
            Direction correctFacing = this.getCorrectFacingForTurret((BlockGetter)world, pos);
            if (isConnected) {
                world.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)CONNECTED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)FACING, (Comparable)correctFacing), 3);
            } else {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)CONNECTED, (Comparable)Boolean.valueOf(false)), 3);
            }
        }
    }

    protected Direction getCorrectFacingForTurret(BlockGetter world, BlockPos pos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos neighborPos = pos.m_121945_(direction);
            if (!(world.m_8055_(neighborPos).m_60734_() instanceof BasicTurretBlock) && !(world.m_8055_(neighborPos).m_60734_() instanceof ShotgunTurretBlock) && !(world.m_8055_(neighborPos).m_60734_() instanceof SniperTurretBlock) && !(world.m_8055_(neighborPos).m_60734_() instanceof AutoTurretBlock)) continue;
            return direction.m_122424_();
        }
        return Direction.NORTH;
    }

    protected boolean isAdjacentToTurret(BlockGetter world, BlockPos pos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos neighborPos = pos.m_121945_(direction);
            if (!(world.m_8055_(neighborPos).m_60734_() instanceof BasicTurretBlock) && !(world.m_8055_(neighborPos).m_60734_() instanceof ShotgunTurretBlock) && !(world.m_8055_(neighborPos).m_60734_() instanceof SniperTurretBlock) && !(world.m_8055_(neighborPos).m_60734_() instanceof AutoTurretBlock)) continue;
            return true;
        }
        return false;
    }
}

