/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.blockentity;

import com.mrcrayfish.framework.network.message.IMessage;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import top.ribs.scguns.entity.projectile.turret.TurretProjectileEntity;
import top.ribs.scguns.init.ModBlockEntities;
import top.ribs.scguns.init.ModSounds;
import top.ribs.scguns.network.PacketHandler;
import top.ribs.scguns.network.message.S2CMessageMuzzleFlash;

public class EnemyTurretBlockEntity
extends BlockEntity {
    private static final double TARGETING_RADIUS = 24.0;
    private static final int COOLDOWN = 40;
    private static final float MAX_PITCH = 60.0f;
    private static final float MIN_PITCH = -25.0f;
    private static final float POSITION_SMOOTHING_FACTOR = 0.2f;
    private static final float ROTATION_SPEED = 0.45f;
    private static final float RECOIL_MAX = 4.0f;
    private static final float RECOIL_SPEED = 0.3f;
    private static final double MINIMUM_FIRING_DISTANCE = 1.3;
    private static final float INACCURACY = 0.05f;
    private Player target;
    private float yaw;
    private float pitch;
    private float previousYaw;
    private float previousPitch;
    private double smoothedTargetX;
    private double smoothedTargetY;
    private double smoothedTargetZ;
    private float recoilPitchOffset = 0.0f;
    private int cooldown = 40;
    private boolean disabled = false;
    private int disableCooldown = 0;
    private static final int MAX_DISABLE_TIME = 200;
    private float disabledRotationOffset = 0.0f;
    private float damageMultiplier = 1.0f;
    private float fireRateMultiplier = 1.0f;

    public EnemyTurretBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.ENEMY_TURRET.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, EnemyTurretBlockEntity turret) {
        if (turret.cooldown > 0) {
            --turret.cooldown;
        }
        turret.tickRecoil();
        if (turret.disabled) {
            turret.handleDisabled();
        } else {
            turret.findTarget(level, pos);
            turret.updateRotation();
            if (turret.target != null && turret.cooldown <= 0 && turret.isReadyToFire()) {
                turret.fire();
                turret.cooldown = 40;
            }
        }
    }

    private void handleDisabled() {
        --this.disableCooldown;
        if (this.disableCooldown <= 0) {
            this.disabled = false;
            this.disableCooldown = 0;
            this.disabledRotationOffset = 0.0f;
        } else {
            this.disabledRotationOffset = (float)Math.sin((double)this.disableCooldown * 0.1) * 5.0f;
        }
        this.resetToRestPosition();
    }

    private void findTarget(Level level, BlockPos pos) {
        this.target = null;
        Vec3 turretPos = new Vec3((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.0, (double)this.f_58858_.m_123343_() + 0.5);
        AABB searchBox = new AABB(pos).m_82377_(24.0, 24.0, 24.0);
        List potentialTargets = level.m_6443_(Player.class, searchBox, player -> player != null && player.m_6084_() && !player.m_7500_() && !player.m_5833_() && !player.m_20145_() && this.hasLineOfSight(level, turretPos, (LivingEntity)player));
        if (!potentialTargets.isEmpty()) {
            this.target = potentialTargets.stream().min(Comparator.comparingDouble(player -> player.m_20238_(turretPos))).orElse(null);
            this.updateTargetPosition();
        }
    }

    private void updateTargetPosition() {
        if (this.target != null) {
            double predictedX = this.target.m_20185_() + this.target.m_20184_().f_82479_ * 7.0;
            double predictedY = this.target.m_20186_() + (double)this.target.m_20192_() + this.target.m_20184_().f_82480_ * 7.0;
            double predictedZ = this.target.m_20189_() + this.target.m_20184_().f_82481_ * 7.0;
            this.smoothedTargetX = EnemyTurretBlockEntity.lerp(this.smoothedTargetX, predictedX, 0.2f);
            this.smoothedTargetY = EnemyTurretBlockEntity.lerp(this.smoothedTargetY, predictedY, 0.2f);
            this.smoothedTargetZ = EnemyTurretBlockEntity.lerp(this.smoothedTargetZ, predictedZ, 0.2f);
        }
    }

    private void updateRotation() {
        this.previousYaw = this.yaw;
        this.previousPitch = this.pitch;
        if (this.smoothedTargetX != 0.0 || this.smoothedTargetZ != 0.0) {
            this.updateYaw();
            this.updatePitch();
        }
    }

    private void updateYaw() {
        double dx = this.smoothedTargetX - ((double)this.f_58858_.m_123341_() + 0.5);
        double dz = this.smoothedTargetZ - ((double)this.f_58858_.m_123343_() + 0.5);
        float targetYaw = (float)(Math.atan2(dx, dz) * 57.29577951308232) + 180.0f;
        float yawDifference = (targetYaw = (targetYaw + 360.0f) % 360.0f) - this.yaw;
        if (yawDifference > 180.0f) {
            yawDifference -= 360.0f;
        } else if (yawDifference < -180.0f) {
            yawDifference += 360.0f;
        }
        this.yaw += yawDifference * 0.45f;
        this.yaw %= 360.0f;
        if (this.yaw < 0.0f) {
            this.yaw += 360.0f;
        }
    }

    private void updatePitch() {
        if (this.smoothedTargetY != 0.0) {
            double dx = this.smoothedTargetX - ((double)this.f_58858_.m_123341_() + 0.5);
            double dy = this.smoothedTargetY - ((double)this.f_58858_.m_123342_() + 1.0);
            double dz = this.smoothedTargetZ - ((double)this.f_58858_.m_123343_() + 0.5);
            double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
            float targetPitch = (float)(Math.atan2(dy, horizontalDistance) * 57.29577951308232);
            targetPitch = Mth.m_14036_((float)targetPitch, (float)-25.0f, (float)60.0f);
            float pitchDifference = targetPitch - this.pitch;
            this.pitch += pitchDifference * 0.45f;
            this.pitch = Mth.m_14036_((float)this.pitch, (float)-25.0f, (float)60.0f);
        }
    }

    private boolean isReadyToFire() {
        if (this.target == null) {
            return false;
        }
        double dx = this.smoothedTargetX - ((double)this.f_58858_.m_123341_() + 0.5);
        double dy = this.smoothedTargetY - ((double)this.f_58858_.m_123342_() + 1.0);
        double dz = this.smoothedTargetZ - ((double)this.f_58858_.m_123343_() + 0.5);
        double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
        float targetYaw = (float)(Math.atan2(dx, dz) * 57.29577951308232) + 180.0f;
        targetYaw = (targetYaw + 360.0f) % 360.0f;
        float targetPitch = (float)(Math.atan2(dy, horizontalDistance) * 57.29577951308232);
        targetPitch = Mth.m_14036_((float)targetPitch, (float)-25.0f, (float)60.0f);
        float yawDifference = Math.abs(targetYaw - this.yaw);
        if (yawDifference > 180.0f) {
            yawDifference = 360.0f - yawDifference;
        }
        float pitchDifference = Math.abs(targetPitch - this.pitch);
        double distanceSquared = dx * dx + dy * dy + dz * dz;
        return distanceSquared >= 1.6900000000000002 && yawDifference < 2.0f && pitchDifference < 2.0f;
    }

    private void fire() {
        if (this.f_58857_ == null || this.target == null) {
            return;
        }
        Vec3 muzzlePos = this.getMuzzlePosition(this.yaw, this.pitch);
        if (!this.f_58857_.f_46443_) {
            PacketHandler.getPlayChannel().sendToTrackingChunk(() -> this.f_58857_.m_46745_(this.f_58858_), (IMessage)new S2CMessageMuzzleFlash(muzzlePos, this.yaw, this.pitch));
        }
        Vec3 targetPos = new Vec3(this.target.m_20185_(), this.target.m_20186_() + (double)this.target.m_20192_() * 0.5, this.target.m_20189_());
        Vec3 direction = targetPos.m_82546_(muzzlePos).m_82541_();
        direction = direction.m_82520_(this.f_58857_.f_46441_.m_216328_(0.0, (double)0.05f), this.f_58857_.f_46441_.m_216328_(0.0, (double)0.05f), this.f_58857_.f_46441_.m_216328_(0.0, (double)0.05f)).m_82541_();
        TurretProjectileEntity projectile = new TurretProjectileEntity(this.f_58857_);
        projectile.m_6034_(muzzlePos.f_82479_, muzzlePos.f_82480_, muzzlePos.f_82481_);
        projectile.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, 3.0f, 0.0f);
        projectile.m_36781_(2.5 * (double)this.damageMultiplier);
        this.f_58857_.m_7967_((Entity)projectile);
        this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)ModSounds.IRON_RIFLE_FIRE.get(), SoundSource.BLOCKS, 0.7f, 0.7f);
        this.recoilPitchOffset = 4.0f;
        this.cooldown = (int)(40.0f * this.fireRateMultiplier);
    }

    private Vec3 getMuzzlePosition(float yaw, float pitch) {
        double muzzleLength = 1.0;
        double muzzleOffsetY = 1.4;
        double yawRad = Math.toRadians(yaw);
        double pitchRad = Math.toRadians(pitch);
        double muzzleX = -Math.sin(yawRad) * Math.cos(pitchRad) * muzzleLength;
        double muzzleY = Math.sin(pitchRad) * muzzleLength + muzzleOffsetY;
        double muzzleZ = -Math.cos(yawRad) * Math.cos(pitchRad) * muzzleLength;
        return new Vec3((double)this.f_58858_.m_123341_() + 0.5 + muzzleX, (double)this.f_58858_.m_123342_() + muzzleY, (double)this.f_58858_.m_123343_() + 0.5 + muzzleZ);
    }

    private boolean hasLineOfSight(Level level, Vec3 turretPos, LivingEntity target) {
        Vec3 targetPos = target.m_146892_();
        Vec3 toTarget = targetPos.m_82546_(turretPos);
        double distance = toTarget.m_82553_();
        Vec3 rayVector = toTarget.m_82541_().m_82490_(distance);
        Vec3 adjustedTurretPos = turretPos.m_82520_(0.0, 0.5, 0.0);
        ClipContext clipContext = new ClipContext(adjustedTurretPos, adjustedTurretPos.m_82549_(rayVector), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null);
        BlockHitResult hitResult = level.m_45547_(clipContext);
        return hitResult.m_6662_() == HitResult.Type.MISS;
    }

    private void tickRecoil() {
        if (this.recoilPitchOffset > 0.0f) {
            this.recoilPitchOffset -= 0.3f;
            if (this.recoilPitchOffset < 0.0f) {
                this.recoilPitchOffset = 0.0f;
            }
        }
    }

    private void resetToRestPosition() {
        this.target = null;
        float restingYaw = 0.0f;
        float restingPitch = -30.0f;
        this.previousYaw = this.yaw;
        this.previousPitch = this.pitch;
        float yawDifference = restingYaw + this.disabledRotationOffset - this.yaw;
        if (yawDifference > 180.0f) {
            yawDifference -= 360.0f;
        } else if (yawDifference < -180.0f) {
            yawDifference += 360.0f;
        }
        this.yaw += yawDifference * 0.45f;
        this.yaw %= 360.0f;
        if (this.yaw < 0.0f) {
            this.yaw += 360.0f;
        }
        float pitchDifference = restingPitch - this.pitch;
        this.pitch += pitchDifference * 0.45f;
        this.smoothedTargetX = 0.0;
        this.smoothedTargetY = 0.0;
        this.smoothedTargetZ = 0.0;
    }

    public void onHitByLightningProjectile() {
        this.disabled = true;
        this.disableCooldown = 200;
        this.resetToRestPosition();
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            this.spawnDisableParticles();
            this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12058_, SoundSource.BLOCKS, 1.0f, 0.5f);
        }
    }

    private void spawnDisableParticles() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double x = (double)this.f_58858_.m_123341_() + 0.5;
            double y = (double)this.f_58858_.m_123342_() + 1.0;
            double z = (double)this.f_58858_.m_123343_() + 0.5;
            int particleCount = 20;
            double spread = 0.5;
            for (int i = 0; i < particleCount; ++i) {
                double offsetX = this.f_58857_.f_46441_.m_188500_() * spread - spread / 2.0;
                double offsetY = this.f_58857_.f_46441_.m_188500_() * spread;
                double offsetZ = this.f_58857_.f_46441_.m_188500_() * spread - spread / 2.0;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175830_, x + offsetX, y + offsetY, z + offsetZ, 1, 0.0, 0.0, 0.0, 0.05);
            }
            serverLevel.m_5594_(null, this.f_58858_, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private static double lerp(double a, double b, double t) {
        return a + t * (b - a);
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getPreviousYaw() {
        return this.previousYaw;
    }

    public float getPreviousPitch() {
        return this.previousPitch;
    }

    public float getRecoilPitchOffset() {
        return this.recoilPitchOffset;
    }

    public void setDamageMultiplier(float multiplier) {
        this.damageMultiplier = multiplier;
    }

    public void setFireRateMultiplier(float multiplier) {
        this.fireRateMultiplier = Math.max(0.1f, multiplier);
    }

    public float getFireRateMultiplier() {
        return this.fireRateMultiplier;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128350_("Yaw", this.yaw);
        tag.m_128350_("Pitch", this.pitch);
        tag.m_128379_("Disabled", this.disabled);
        tag.m_128405_("DisableCooldown", this.disableCooldown);
        tag.m_128350_("DamageMultiplier", this.damageMultiplier);
        tag.m_128350_("FireRateMultiplier", this.fireRateMultiplier);
        tag.m_128350_("DisabledRotationOffset", this.disabledRotationOffset);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.previousYaw = this.yaw = tag.m_128457_("Yaw");
        this.previousPitch = this.pitch = tag.m_128457_("Pitch");
        this.disabled = tag.m_128471_("Disabled");
        this.disableCooldown = tag.m_128451_("DisableCooldown");
        this.damageMultiplier = tag.m_128457_("DamageMultiplier");
        this.disabledRotationOffset = tag.m_128457_("DisabledRotationOffset");
        this.fireRateMultiplier = tag.m_128457_("FireRateMultiplier");
        if (this.fireRateMultiplier <= 0.0f) {
            this.fireRateMultiplier = 1.0f;
        }
        this.disabledRotationOffset = tag.m_128457_("DisabledRotationOffset");
    }
}

