/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.blockentity;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.ribs.scguns.block.MaceratorBlock;
import top.ribs.scguns.client.screen.MaceratorMenu;
import top.ribs.scguns.client.screen.MaceratorRecipe;
import top.ribs.scguns.init.ModBlockEntities;

public class MaceratorBlockEntity
extends BlockEntity
implements MenuProvider {
    public final ItemStackHandler itemHandler = new ItemStackHandler(6){

        protected void onContentsChanged(int slot) {
            MaceratorBlockEntity.this.m_6596_();
            if (!MaceratorBlockEntity.this.f_58857_.m_5776_()) {
                MaceratorBlockEntity.this.f_58857_.m_7260_(MaceratorBlockEntity.this.m_58899_(), MaceratorBlockEntity.this.m_58900_(), MaceratorBlockEntity.this.m_58900_(), 3);
                if (MaceratorBlockEntity.this.isInputSlot(slot) && !MaceratorBlockEntity.this.isRecipeValid()) {
                    MaceratorBlockEntity.this.resetProgress();
                }
            }
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            ItemStack existingStack;
            if (slot >= 0 && slot <= 3 && !(existingStack = MaceratorBlockEntity.this.itemHandler.getStackInSlot(slot)).m_41619_() && !ItemStack.m_41656_((ItemStack)existingStack, (ItemStack)stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return MaceratorBlockEntity.this.progress;
                }
                case 1: {
                    return MaceratorBlockEntity.this.maxProgress;
                }
                case 2: {
                    return MaceratorBlockEntity.this.burnTime;
                }
                case 3: {
                    return MaceratorBlockEntity.this.maxBurnTime;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    MaceratorBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    MaceratorBlockEntity.this.maxProgress = value;
                    break;
                }
                case 2: {
                    MaceratorBlockEntity.this.burnTime = value;
                    break;
                }
                case 3: {
                    MaceratorBlockEntity.this.maxBurnTime = value;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };
    private int progress = 0;
    private int maxProgress = 100;
    private int burnTime = 0;
    private int maxBurnTime = 0;
    private static final float WHEEL_ROTATION_SPEED = 20.0f;
    public static final int FIRST_INPUT_SLOT = 0;
    public static final int LAST_INPUT_SLOT = 3;
    public static final int FUEL_SLOT = 4;
    public static final int OUTPUT_SLOT = 5;

    private boolean isInputSlot(int slot) {
        return slot >= 0 && slot <= 3;
    }

    public MaceratorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.MACERATOR.get(), pos, state);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.macerator");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        MaceratorMenu menu = new MaceratorMenu(id, inv, this, this.data);
        return menu;
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            Direction blockFacing = (Direction)this.m_58900_().m_61143_((Property)MaceratorBlock.FACING);
            if (side == Direction.DOWN) {
                return LazyOptional.of(() -> new OutputItemHandler(this.itemHandler)).cast();
            }
            if (side == Direction.UP) {
                return LazyOptional.of(() -> new InputItemHandler(this.itemHandler)).cast();
            }
            if (side == blockFacing.m_122424_()) {
                return LazyOptional.of(() -> new FuelItemHandler(this.itemHandler)).cast();
            }
            return LazyOptional.of(() -> new InputItemHandler(this.itemHandler)).cast();
        }
        return super.getCapability(cap, side);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("macerator.progress", this.progress);
        tag.m_128405_("macerator.burnTime", this.burnTime);
        tag.m_128405_("macerator.maxBurnTime", this.maxBurnTime);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
        this.progress = tag.m_128451_("macerator.progress");
        this.burnTime = tag.m_128451_("macerator.burnTime");
        this.maxBurnTime = tag.m_128451_("macerator.maxBurnTime");
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MaceratorBlockEntity blockEntity) {
        boolean wasLit = (Boolean)state.m_61143_((Property)MaceratorBlock.LIT);
        boolean isLit = false;
        if (!level.f_46443_) {
            boolean hasValidRecipe = blockEntity.hasRecipe();
            if (blockEntity.hasFuel()) {
                --blockEntity.burnTime;
                isLit = true;
            } else if (hasValidRecipe && blockEntity.canBurnFuel()) {
                blockEntity.burnFuel();
                isLit = true;
            } else if (blockEntity.progress > 0) {
                blockEntity.resetProgress();
            }
            if (hasValidRecipe && blockEntity.hasFuel()) {
                ++blockEntity.progress;
                if (blockEntity.progress >= blockEntity.maxProgress) {
                    blockEntity.craftItem();
                    blockEntity.resetProgress();
                }
            } else if (!hasValidRecipe) {
                blockEntity.resetProgress();
            }
            if (wasLit != isLit) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)MaceratorBlock.LIT, (Comparable)Boolean.valueOf(isLit)), 3);
            }
        }
    }

    private boolean hasRecipe() {
        SimpleContainer inventory = new SimpleContainer(4);
        for (int i = 0; i <= 3; ++i) {
            inventory.m_6836_(i - 0, this.itemHandler.getStackInSlot(i));
        }
        assert (this.f_58857_ != null);
        Optional match = this.f_58857_.m_7465_().m_44015_((RecipeType)MaceratorRecipe.Type.INSTANCE, (Container)inventory, this.f_58857_);
        return match.isPresent();
    }

    private void craftItem() {
        SimpleContainer inventory = new SimpleContainer(4);
        for (int i = 0; i <= 3; ++i) {
            inventory.m_6836_(i - 0, this.itemHandler.getStackInSlot(i));
        }
        assert (this.f_58857_ != null);
        Optional match = this.f_58857_.m_7465_().m_44015_((RecipeType)MaceratorRecipe.Type.INSTANCE, (Container)inventory, this.f_58857_);
        if (match.isPresent()) {
            MaceratorRecipe recipe = (MaceratorRecipe)match.get();
            ItemStack resultItem = recipe.m_8043_(this.f_58857_.m_9598_());
            ItemStack outputStack = this.itemHandler.getStackInSlot(5);
            if (outputStack.m_41619_() || outputStack.m_41720_() == resultItem.m_41720_() && outputStack.m_41613_() + resultItem.m_41613_() <= outputStack.m_41741_()) {
                for (int i = 0; i <= 3; ++i) {
                    this.itemHandler.extractItem(i, 1, false);
                }
                if (outputStack.m_41619_()) {
                    this.itemHandler.setStackInSlot(5, resultItem.m_41777_());
                } else {
                    outputStack.m_41769_(resultItem.m_41613_());
                }
            }
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private boolean isRecipeValid() {
        SimpleContainer inventory = new SimpleContainer(4);
        for (int i = 0; i <= 3; ++i) {
            inventory.m_6836_(i - 0, this.itemHandler.getStackInSlot(i));
        }
        Optional<MaceratorRecipe> currentRecipe = this.getCurrentRecipe();
        if (currentRecipe.isPresent()) {
            MaceratorRecipe recipe = currentRecipe.get();
            return recipe.matches(inventory, this.f_58857_);
        }
        return false;
    }

    private Optional<MaceratorRecipe> getCurrentRecipe() {
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        RecipeManager recipeManager = this.f_58857_.m_7465_();
        SimpleContainer inventory = new SimpleContainer(4);
        for (int i = 0; i <= 3; ++i) {
            inventory.m_6836_(i - 0, this.itemHandler.getStackInSlot(i));
        }
        return recipeManager.m_44013_((RecipeType)MaceratorRecipe.Type.INSTANCE).stream().filter(recipe -> recipe.matches(inventory, this.f_58857_)).findFirst();
    }

    private boolean canBurnFuel() {
        ItemStack fuelStack = this.itemHandler.getStackInSlot(4);
        return !fuelStack.m_41619_() && ForgeHooks.getBurnTime((ItemStack)fuelStack, (RecipeType)RecipeType.f_44108_) > 0;
    }

    private void burnFuel() {
        ItemStack fuelStack = this.itemHandler.getStackInSlot(4);
        this.maxBurnTime = this.burnTime = ForgeHooks.getBurnTime((ItemStack)fuelStack, (RecipeType)RecipeType.f_44108_);
        if (fuelStack.hasCraftingRemainingItem()) {
            this.itemHandler.setStackInSlot(4, fuelStack.getCraftingRemainingItem());
        } else {
            fuelStack.m_41774_(1);
            if (fuelStack.m_41619_()) {
                this.itemHandler.setStackInSlot(4, ItemStack.f_41583_);
            }
        }
    }

    private boolean hasFuel() {
        return this.burnTime > 0;
    }

    public float getWheelRotation(float partialTicks) {
        assert (this.f_58857_ != null);
        return ((float)this.f_58857_.m_46467_() + partialTicks) * 20.0f % 360.0f;
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.f_58857_ != null);
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    private class InputItemHandler
    implements IItemHandlerModifiable {
        private final ItemStackHandler itemHandler;

        public InputItemHandler(ItemStackHandler itemHandler) {
            this.itemHandler = itemHandler;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            if (slot >= 0 && slot <= 3) {
                this.itemHandler.setStackInSlot(slot, stack);
            }
        }

        public int getSlots() {
            return 4;
        }

        public ItemStack getStackInSlot(int slot) {
            if (slot >= 0 && slot < this.getSlots()) {
                return this.itemHandler.getStackInSlot(0 + slot);
            }
            return ItemStack.f_41583_;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            int actualSlot;
            ItemStack result;
            if (slot >= 0 && slot < this.getSlots() && !(result = this.itemHandler.insertItem(actualSlot = 0 + slot, stack, simulate)).equals(stack)) {
                return result;
            }
            return this.insertIntoNextAvailableSlot(stack, simulate);
        }

        private ItemStack insertIntoNextAvailableSlot(ItemStack stack, boolean simulate) {
            ItemStack existingStack;
            int i;
            for (i = 0; i <= 3; ++i) {
                ItemStack result;
                existingStack = this.itemHandler.getStackInSlot(i);
                if (existingStack.m_41619_() || !ItemStack.m_41656_((ItemStack)existingStack, (ItemStack)stack) || (result = this.itemHandler.insertItem(i, stack, simulate)).equals(stack)) continue;
                return result;
            }
            for (i = 0; i <= 3; ++i) {
                existingStack = this.itemHandler.getStackInSlot(i);
                if (!existingStack.m_41619_()) continue;
                return this.itemHandler.insertItem(i, stack, simulate);
            }
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            if (slot >= 0 && slot < this.getSlots()) {
                return this.itemHandler.getSlotLimit(0 + slot);
            }
            return 0;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return slot >= 0 && slot < this.getSlots();
        }
    }

    private class FuelItemHandler
    implements IItemHandlerModifiable {
        private final ItemStackHandler itemHandler;

        public FuelItemHandler(ItemStackHandler itemHandler) {
            this.itemHandler = itemHandler;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            this.itemHandler.setStackInSlot(slot, stack);
        }

        public int getSlots() {
            return this.itemHandler.getSlots();
        }

        public ItemStack getStackInSlot(int slot) {
            return this.itemHandler.getStackInSlot(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot == 4 && ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_) > 0) {
                return this.itemHandler.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return this.itemHandler.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return slot == 4 && ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_) > 0;
        }
    }

    private class OutputItemHandler
    implements IItemHandlerModifiable {
        private final ItemStackHandler itemHandler;

        public OutputItemHandler(ItemStackHandler itemHandler) {
            this.itemHandler = itemHandler;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            this.itemHandler.setStackInSlot(slot, stack);
        }

        public int getSlots() {
            return this.itemHandler.getSlots();
        }

        @NotNull
        public ItemStack getStackInSlot(int i) {
            return this.itemHandler.getStackInSlot(i);
        }

        @NotNull
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return stack;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 5) {
                return this.itemHandler.extractItem(slot, amount, simulate);
            }
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return this.itemHandler.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return false;
        }
    }
}

