/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.blockentity;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import top.ribs.scguns.block.ThermolithBlock;
import top.ribs.scguns.client.screen.ThermolithMenu;
import top.ribs.scguns.init.ModBlockEntities;

public class ThermolithBlockEntity
extends BlockEntity
implements MenuProvider {
    private static final ResourceLocation THERMOLITH_INGREDIENT_TAG = new ResourceLocation("scguns", "thermolith_ingredient");
    private static final ResourceLocation MELTABLE_BLOCKS_TAG = new ResourceLocation("scguns", "meltable_blocks");
    private static final int MELT_INTERVAL = 40;
    private static final double MELT_RADIUS = 6.0;
    private static final ThreadLocal<RandomSource> RANDOM = ThreadLocal.withInitial(RandomSource::m_216327_);
    private final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            ThermolithBlockEntity.this.m_6596_();
            ThermolithBlockEntity.this.updateLitState();
        }
    };
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);
    private int tickCounter = 0;
    private boolean isLit = false;

    public ThermolithBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.THERMOLITH.get(), pos, state);
    }

    public void tick() {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        this.updateLitState();
        if (this.isLit) {
            ++this.tickCounter;
            if (this.tickCounter >= 40) {
                this.tickCounter = 0;
                this.meltRandomBlock();
            }
        } else {
            this.tickCounter = 0;
        }
    }

    private void meltRandomBlock() {
        RandomSource rand = RANDOM.get();
        BlockPos startPos = this.findNearestLava();
        if (startPos == null) {
            startPos = this.f_58858_;
        }
        int radius = 1;
        while ((double)radius <= 6.0) {
            ArrayList<BlockPos> candidatesAtRadius = new ArrayList<BlockPos>();
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    for (int dy = -1; dy <= 1; ++dy) {
                        BlockPos targetPos;
                        if (Math.abs(dx) != radius && Math.abs(dz) != radius || !(this.f_58858_.m_123331_((Vec3i)(targetPos = startPos.m_7918_(dx, dy, dz))) <= 36.0) || !this.f_58857_.m_8055_(targetPos).m_204336_(BlockTags.create((ResourceLocation)MELTABLE_BLOCKS_TAG))) continue;
                        candidatesAtRadius.add(targetPos);
                    }
                }
            }
            if (!candidatesAtRadius.isEmpty()) {
                Level level;
                BlockPos targetPos = (BlockPos)candidatesAtRadius.get(rand.m_188503_(candidatesAtRadius.size()));
                this.f_58857_.m_46597_(targetPos, Blocks.f_49991_.m_49966_());
                if (rand.m_188501_() < 0.15f) {
                    this.itemHandler.extractItem(0, 1, false);
                }
                if ((level = this.f_58857_) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123756_, (double)targetPos.m_123341_() + 0.5, (double)targetPos.m_123342_() + 0.5, (double)targetPos.m_123343_() + 0.5, 10, 0.5, 0.5, 0.5, 0.1);
                }
                return;
            }
            ++radius;
        }
    }

    private BlockPos findNearestLava() {
        int radius = 1;
        while ((double)radius <= 6.0) {
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    for (int dy = -1; dy <= 1; ++dy) {
                        BlockPos checkPos;
                        if (Math.abs(dx) != radius && Math.abs(dz) != radius || this.f_58857_.m_8055_(checkPos = this.f_58858_.m_7918_(dx, dy, dz)).m_60734_() != Blocks.f_49991_) continue;
                        return checkPos;
                    }
                }
            }
            ++radius;
        }
        return null;
    }

    private void updateLitState() {
        boolean shouldBeLit;
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        boolean bl = shouldBeLit = !stack.m_41619_() && stack.m_204117_(ItemTags.create((ResourceLocation)THERMOLITH_INGREDIENT_TAG));
        if (this.isLit != shouldBeLit) {
            this.isLit = shouldBeLit;
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)ThermolithBlock.LIT, (Comparable)Boolean.valueOf(this.isLit)), 3);
        }
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)"container.thermolith");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory playerInventory, @NotNull Player player) {
        return new ThermolithMenu(id, playerInventory, this);
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.handler.invalidate();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
        this.isLit = tag.m_128471_("isLit");
        this.tickCounter = tag.m_128451_("tickCounter");
    }

    protected void m_183515_(CompoundTag tag) {
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128379_("isLit", this.isLit);
        tag.m_128405_("tickCounter", this.tickCounter);
        super.m_183515_(tag);
    }

    public int getContainerSize() {
        return this.itemHandler.getSlots();
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.f_58857_ != null);
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public boolean isLit() {
        return this.isLit;
    }
}

