/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import top.ribs.scguns.init.ModEnchantments;

public class HotBarrelCache {
    private static final Map<String, HotBarrelData> HOT_BARREL_CACHE = new ConcurrentHashMap<String, HotBarrelData>();
    private static final float MAX_HOT_BARREL = 100.0f;
    private static final float DECAY_RATE_PER_TICK = 0.7f;
    private static final int DECAY_START_DELAY = 15;

    private static String generateKey(Player player, ItemStack stack) {
        return player.m_20148_() + "_" + stack.m_41720_().m_5524_();
    }

    public static void increaseHotBarrel(Player player, ItemStack stack, int amount) {
        if (!HotBarrelCache.hasHotBarrelEnchantment(stack)) {
            return;
        }
        String key = HotBarrelCache.generateKey(player, stack);
        HotBarrelData data = HOT_BARREL_CACHE.computeIfAbsent(key, k -> new HotBarrelData());
        data.level = Math.min(100.0f, data.level + (float)amount);
        data.ticksSinceLastShot = 0;
        data.lastUpdateTime = System.currentTimeMillis();
        HOT_BARREL_CACHE.put(key, data);
    }

    public static int getHotBarrelLevel(Player player, ItemStack stack) {
        if (!HotBarrelCache.hasHotBarrelEnchantment(stack)) {
            return 0;
        }
        String key = HotBarrelCache.generateKey(player, stack);
        HotBarrelData data = HOT_BARREL_CACHE.get(key);
        if (data == null) {
            return 0;
        }
        return Math.round(data.level);
    }

    public static float getSmoothHotBarrelLevel(Player player, ItemStack stack) {
        if (!HotBarrelCache.hasHotBarrelEnchantment(stack)) {
            return 0.0f;
        }
        String key = HotBarrelCache.generateKey(player, stack);
        HotBarrelData data = HOT_BARREL_CACHE.get(key);
        if (data == null || data.level <= 0.0f) {
            return 0.0f;
        }
        return Math.max(data.level, 0.0f);
    }

    public static void setHotBarrelLevel(Player player, ItemStack stack, int level) {
        if (!HotBarrelCache.hasHotBarrelEnchantment(stack)) {
            return;
        }
        String key = HotBarrelCache.generateKey(player, stack);
        HotBarrelData data = HOT_BARREL_CACHE.computeIfAbsent(key, k -> new HotBarrelData());
        data.level = Math.max(0.0f, Math.min(100.0f, (float)level));
        data.lastUpdateTime = System.currentTimeMillis();
        HOT_BARREL_CACHE.put(key, data);
    }

    public static float getSmoothHotBarrelPercentage(Player player, ItemStack stack) {
        return HotBarrelCache.getSmoothHotBarrelLevel(player, stack) / 100.0f;
    }

    public static void tickHotBarrel(Player player, ItemStack stack) {
        if (!HotBarrelCache.hasHotBarrelEnchantment(stack)) {
            return;
        }
        String key = HotBarrelCache.generateKey(player, stack);
        HotBarrelData data = HOT_BARREL_CACHE.get(key);
        if (data == null || data.level <= 0.0f) {
            return;
        }
        ++data.ticksSinceLastShot;
        if (data.ticksSinceLastShot >= 15) {
            data.level = Math.max(data.level - 0.7f, 0.0f);
            if (data.level <= 0.0f) {
                HOT_BARREL_CACHE.remove(key);
                return;
            }
        }
        data.lastUpdateTime = System.currentTimeMillis();
    }

    public static void clearHotBarrel(Player player, ItemStack stack) {
        String key = HotBarrelCache.generateKey(player, stack);
        HOT_BARREL_CACHE.remove(key);
    }

    public static boolean hasHotBarrelEnchantment(ItemStack stack) {
        return EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.HOT_BARREL.get()), (ItemStack)stack) > 0;
    }

    public static void cleanupOldEntries() {
        long currentTime = System.currentTimeMillis();
        long maxAge = 300000L;
        HOT_BARREL_CACHE.entrySet().removeIf(entry -> currentTime - ((HotBarrelData)entry.getValue()).lastUpdateTime > maxAge);
    }

    public static class HotBarrelData {
        public float level = 0.0f;
        public int ticksSinceLastShot = 0;
        public long lastUpdateTime = System.currentTimeMillis();
    }
}

