/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.client.handler;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import top.ribs.scguns.client.BulletTrail;
import top.ribs.scguns.init.ModTags;

public class BulletTrailRenderingHandler {
    private static BulletTrailRenderingHandler instance;
    private final Map<Integer, BulletTrail> bullets = new HashMap<Integer, BulletTrail>();

    public static BulletTrailRenderingHandler get() {
        if (instance == null) {
            instance = new BulletTrailRenderingHandler();
        }
        return instance;
    }

    private BulletTrailRenderingHandler() {
    }

    public void add(BulletTrail trail) {
        this.bullets.put(trail.getEntityId(), trail);
    }

    public void remove(int entityId) {
        this.bullets.remove(entityId);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world != null) {
            if (event.phase == TickEvent.Phase.END) {
                this.bullets.values().forEach(BulletTrail::tick);
                this.bullets.values().removeIf(BulletTrail::isDead);
            }
        } else if (!this.bullets.isEmpty()) {
            this.bullets.clear();
        }
    }

    public void render(PoseStack stack, float partialSticks) {
        for (BulletTrail bulletTrail : this.bullets.values()) {
            this.renderBulletTrail(bulletTrail, stack, partialSticks);
        }
    }

    @SubscribeEvent
    public void onRespawn(ClientPlayerNetworkEvent.Clone event) {
        this.bullets.clear();
    }

    @SubscribeEvent
    public void onLoggedOut(ClientPlayerNetworkEvent.LoggingOut event) {
        this.bullets.clear();
    }

    private void renderBulletTrail(BulletTrail trail, PoseStack poseStack, float deltaTicks) {
        Minecraft mc = Minecraft.m_91087_();
        Entity entity = mc.m_91288_();
        ClientLevel world = mc.f_91073_;
        if (entity == null || trail.isDead() || world == null) {
            return;
        }
        Entity projectileEntity = world.m_6815_(trail.getEntityId());
        if (projectileEntity == null) {
            return;
        }
        if (projectileEntity.m_6095_().m_204039_(ModTags.Entities.DISABLE_BULLET_TRAIL)) {
            return;
        }
        if (!trail.isTrailVisible()) {
            return;
        }
        poseStack.m_85836_();
        Vec3 view = mc.f_91063_.m_109153_().m_90583_();
        Vec3 position = trail.getPosition();
        Vec3 motion = trail.getMotion();
        double bulletX = position.f_82479_ + motion.f_82479_ * (double)deltaTicks;
        double bulletY = position.f_82480_ + motion.f_82480_ * (double)deltaTicks;
        double bulletZ = position.f_82481_ + motion.f_82481_ * (double)deltaTicks;
        poseStack.m_85837_(bulletX - view.m_7096_(), bulletY - view.m_7098_(), bulletZ - view.m_7094_());
        poseStack.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14179_((float)deltaTicks, (float)trail.getYaw(), (float)trail.getYaw()) - 90.0f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(Mth.m_14179_((float)deltaTicks, (float)trail.getPitch(), (float)trail.getPitch())));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(45.0f));
        poseStack.m_85841_(0.05625f, 0.05625f, 0.05625f);
        poseStack.m_252880_(-4.0f, 0.0f, 0.0f);
        MultiBufferSource.BufferSource renderTypeBuffer = mc.m_91269_().m_110104_();
        VertexConsumer vertexConsumer = renderTypeBuffer.m_6299_(RenderType.m_110436_((ResourceLocation)this.getTexture(projectileEntity), (float)0.0f, (float)0.15625f));
        PoseStack.Pose posestack$pose = poseStack.m_85850_();
        Matrix4f matrix4f = posestack$pose.m_252922_();
        Matrix3f matrix3f = posestack$pose.m_252943_();
        double speed = Math.sqrt(motion.f_82479_ * motion.f_82479_ + motion.f_82480_ * motion.f_82480_ + motion.f_82481_ * motion.f_82481_);
        float speedFactor = (float)Math.max(1.0, speed * 0.4);
        int baseSize = 30;
        int size = (int)Math.min((double)((trail.getAge() + 1) * 30) * trail.getTrailThickness() * (double)speedFactor, (double)baseSize * trail.getTrailThickness() * (double)speedFactor);
        int color = trail.getTrailColor();
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        float brightnessFactor = (float)Math.min(1.2, 1.0 + speed * 0.08);
        red = Math.min(255, (int)((float)red * brightnessFactor));
        green = Math.min(255, (int)((float)green * brightnessFactor));
        blue = Math.min(255, (int)((float)blue * brightnessFactor));
        int light = 0xF000F0;
        if (trail.isTrailVisible()) {
            this.vertex(red, green, blue, matrix4f, matrix3f, vertexConsumer, -1 - size, -1, -1, 0.0f, 0.15625f, -1, 0, 0, light);
            this.vertex(red, green, blue, matrix4f, matrix3f, vertexConsumer, -1 - size, -1, 1, 0.15625f, 0.15625f, -1, 0, 0, light);
            this.vertex(red, green, blue, matrix4f, matrix3f, vertexConsumer, -1 - size, 1, 1, 0.15625f, 0.3125f, -1, 0, 0, light);
            this.vertex(red, green, blue, matrix4f, matrix3f, vertexConsumer, -1 - size, 1, -1, 0.0f, 0.3125f, -1, 0, 0, light);
            this.vertex(red, green, blue, matrix4f, matrix3f, vertexConsumer, -1 - size, -1, -1, 0.0f, 0.15625f, -1, 0, 0, light);
            this.vertex(red, green, blue, matrix4f, matrix3f, vertexConsumer, -1 - size, 1, -1, 0.0f, 0.3125f, -1, 0, 0, light);
            this.vertex(red, green, blue, matrix4f, matrix3f, vertexConsumer, 1, 1, -1, 0.15625f, 0.3125f, 1, 0, 0, light);
            this.vertex(red, green, blue, matrix4f, matrix3f, vertexConsumer, 1, -1, -1, 0.15625f, 0.15625f, 1, 0, 0, light);
            this.vertex(red, green, blue, matrix4f, matrix3f, vertexConsumer, 1, -1, -1, 0.0f, 0.15625f, 0, 0, -1, light);
            this.vertex(red, green, blue, matrix4f, matrix3f, vertexConsumer, 1, 1, -1, 0.0f, 0.3125f, 0, 0, -1, light);
            this.vertex(red, green, blue, matrix4f, matrix3f, vertexConsumer, 1, 1, 1, 0.15625f, 0.3125f, 0, 0, -1, light);
            this.vertex(red, green, blue, matrix4f, matrix3f, vertexConsumer, 1, -1, 1, 0.15625f, 0.15625f, 0, 0, -1, light);
            this.vertex(red, green, blue, matrix4f, matrix3f, vertexConsumer, 1, -1, 1, 0.0f, 0.15625f, 1, 0, 0, light);
            this.vertex(red, green, blue, matrix4f, matrix3f, vertexConsumer, 1, 1, 1, 0.0f, 0.3125f, 1, 0, 0, light);
            this.vertex(red, green, blue, matrix4f, matrix3f, vertexConsumer, -1 - size, 1, 1, 0.15625f, 0.3125f, 1, 0, 0, light);
            this.vertex(red, green, blue, matrix4f, matrix3f, vertexConsumer, -1 - size, -1, 1, 0.15625f, 0.15625f, 1, 0, 0, light);
            this.vertex(red, green, blue, matrix4f, matrix3f, vertexConsumer, -1 - size, -1, 1, 0.0f, 0.15625f, 0, 0, 1, light);
            this.vertex(red, green, blue, matrix4f, matrix3f, vertexConsumer, -1 - size, 1, 1, 0.0f, 0.3125f, 0, 0, 1, light);
            this.vertex(red, green, blue, matrix4f, matrix3f, vertexConsumer, -1 - size, 1, -1, 0.15625f, 0.3125f, 0, 0, 1, light);
            this.vertex(red, green, blue, matrix4f, matrix3f, vertexConsumer, -1 - size, -1, -1, 0.15625f, 0.15625f, 0, 0, 1, light);
            this.vertex(red, green, blue, matrix4f, matrix3f, vertexConsumer, 1, 1, -1, 0.0f, 0.15625f, 1, 0, 0, light);
            this.vertex(red, green, blue, matrix4f, matrix3f, vertexConsumer, 1, 1, 1, 0.15625f, 0.15625f, 1, 0, 0, light);
            this.vertex(red, green, blue, matrix4f, matrix3f, vertexConsumer, 1, -1, 1, 0.15625f, 0.3125f, 1, 0, 0, light);
            this.vertex(red, green, blue, matrix4f, matrix3f, vertexConsumer, 1, -1, -1, 0.0f, 0.3125f, 1, 0, 0, light);
            for (int j = 0; j < 4; ++j) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                this.vertex(red, green, blue, matrix4f, matrix3f, vertexConsumer, -1 - size, -1, 1, 0.0f, 0.0f, 0, 1, 0, light);
                this.vertex(red, green, blue, matrix4f, matrix3f, vertexConsumer, 1, -1, 1, 0.5f, 0.0f, 0, 1, 0, light);
                this.vertex(red, green, blue, matrix4f, matrix3f, vertexConsumer, 1, 1, 1, 0.5f, 0.15625f, 0, 1, 0, light);
                this.vertex(red, green, blue, matrix4f, matrix3f, vertexConsumer, -1 - size, 1, 1, 0.0f, 0.15625f, 0, 1, 0, light);
            }
        }
        renderTypeBuffer.m_109911_();
        poseStack.m_85849_();
    }

    public ResourceLocation getTexture(Entity entity) {
        ResourceLocation id = EntityType.m_20613_((EntityType)entity.m_6095_());
        return new ResourceLocation(String.format("%s:textures/trail/%s.png", id.m_135827_(), id.m_135815_()));
    }

    public void vertex(int red, int green, int blue, Matrix4f pMatrix, Matrix3f pNormal, VertexConsumer pConsumer, int pX, int pY, int pZ, float pU, float pV, int pNormalX, int pNormalZ, int pNormalY, int pPackedLight) {
        pConsumer.m_252986_(pMatrix, (float)pX, (float)pY, (float)pZ).m_6122_(red, green, blue, 255).m_7421_(pU, pV).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_252939_(pNormal, (float)pNormalX, (float)pNormalY, (float)pNormalZ).m_5752_();
    }

    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            BulletTrailRenderingHandler.get().render(event.getPoseStack(), event.getPartialTick());
        }
    }
}

