/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.client.render.crosshair;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import top.ribs.scguns.Config;
import top.ribs.scguns.client.handler.AimingHandler;
import top.ribs.scguns.client.handler.GunRenderingHandler;
import top.ribs.scguns.client.render.crosshair.Crosshair;
import top.ribs.scguns.client.render.crosshair.DotRenderMode;
import top.ribs.scguns.common.ChargeHandler;
import top.ribs.scguns.common.FireMode;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.common.SpreadTracker;
import top.ribs.scguns.item.GunItem;
import top.ribs.scguns.util.GunCompositeStatHelper;

public class DynamicCrosshair
extends Crosshair {
    private static final ResourceLocation DYNAMIC_CROSSHAIR_H = new ResourceLocation("scguns", "textures/crosshair/dynamic_horizontal.png");
    private static final ResourceLocation DYNAMIC_CROSSHAIR_V = new ResourceLocation("scguns", "textures/crosshair/dynamic_vertical.png");
    private static final ResourceLocation DOT_CROSSHAIR = new ResourceLocation("scguns", "textures/crosshair/dot.png");
    private float scale;
    private float prevScale;
    private float fireBloom;
    private float prevFireBloom;

    public DynamicCrosshair() {
        super(new ResourceLocation("scguns", "dynamic"));
    }

    @Override
    public void tick() {
        this.prevScale = this.scale;
        this.scale *= 0.7f;
        this.prevFireBloom = this.fireBloom;
        if (this.fireBloom > 0.0f) {
            float i = (float)((Integer)Config.COMMON.projectileSpread.spreadThreshold.get()).intValue() / 50.0f;
            this.fireBloom -= Math.min(2.0f / Math.max(i, 1.0f), this.fireBloom);
        }
    }

    @Override
    public void onGunFired() {
        this.prevScale = 0.0f;
        this.scale = 1.2f;
        this.fireBloom = 5.0f;
    }

    private float getCurrentChargeProgress(Player player, ItemStack weapon, Gun modifiedGun) {
        int maxChargeTime = modifiedGun.getGeneral().getFireTimer();
        int chargeTime = ChargeHandler.getChargeTime(player.m_20148_());
        if (maxChargeTime > 0 && chargeTime > 0) {
            return Math.min(1.0f, (float)chargeTime / (float)maxChargeTime);
        }
        return 0.0f;
    }

    private float calculateChargeSpreadMultiplier(float chargeProgress, Gun modifiedGun) {
        chargeProgress = Mth.m_14036_((float)chargeProgress, (float)0.0f, (float)1.0f);
        float weaponSpreadPenalty = 3.0f;
        float minSpreadMultiplier = 1.0f + weaponSpreadPenalty;
        float maxSpreadMultiplier = 0.15f;
        float curveValue = chargeProgress * chargeProgress * chargeProgress;
        return minSpreadMultiplier - (minSpreadMultiplier - maxSpreadMultiplier) * curveValue;
    }

    @Override
    public void render(Minecraft mc, PoseStack stack, int windowWidth, int windowHeight, float partialTicks) {
        float finalSpreadTranslate;
        ItemStack heldItem;
        Item var14;
        float alpha = 1.0f;
        float size1 = 7.0f;
        float size2 = 1.0f;
        float spread = 0.0f;
        float scaleMultiplier = 2.0f;
        boolean renderDot = false;
        if (mc.f_91074_ != null && (var14 = (heldItem = mc.f_91074_.m_21205_()).m_41720_()) instanceof GunItem) {
            float minSpread;
            GunItem gun = (GunItem)heldItem.m_41720_();
            Gun modifiedGun = gun.getModifiedGun(heldItem);
            if (Gun.hasLaserSight(heldItem)) {
                return;
            }
            finalSpreadTranslate = (float)AimingHandler.get().getNormalisedAdsProgress();
            float sprintTransition = GunRenderingHandler.get().getSprintTransition(Minecraft.m_91087_().m_91296_());
            float spreadCount = SpreadTracker.get((Player)mc.f_91074_).getNextSpread(gun, finalSpreadTranslate);
            float spreadModifier = (spreadCount + 1.0f / Math.max((float)((Integer)Config.COMMON.projectileSpread.maxCount.get()).intValue(), 1.0f)) * Math.min(Mth.m_14179_((float)partialTicks, (float)this.prevFireBloom, (float)this.fireBloom), 1.0f);
            spreadModifier = (float)Mth.m_14139_((double)((double)sprintTransition * 0.5), (double)spreadModifier, (double)1.0);
            float baseSpread = GunCompositeStatHelper.getCompositeSpread(heldItem, modifiedGun);
            float f = minSpread = modifiedGun.getProjectile().isAlwaysSpread() ? baseSpread : 0.0f;
            if (modifiedGun.getGeneral().getFireMode() == FireMode.PULSE) {
                float chargeProgress = this.getCurrentChargeProgress((Player)mc.f_91074_, heldItem, modifiedGun);
                float chargeSpreadMultiplier = this.calculateChargeSpreadMultiplier(chargeProgress, modifiedGun);
                baseSpread *= chargeSpreadMultiplier;
                minSpread *= chargeSpreadMultiplier;
            }
            float aimingSpreadMultiplier = Mth.m_14179_((float)finalSpreadTranslate, (float)1.0f, (float)0.5f);
            spread = Math.max(Mth.m_14179_((float)spreadModifier, (float)minSpread, (float)baseSpread) * aimingSpreadMultiplier, 0.0f);
            DotRenderMode dotRenderMode = (DotRenderMode)((Object)Config.CLIENT.display.dynamicCrosshairDotMode.get());
            renderDot = dotRenderMode == DotRenderMode.ALWAYS || dotRenderMode == DotRenderMode.AT_MIN_SPREAD && SpreadTracker.get((Player)mc.f_91074_).getNextSpread(gun, finalSpreadTranslate) * spreadModifier <= 0.0f && (double)spread <= (Double)Config.CLIENT.display.dynamicCrosshairDotThreshold.get() || dotRenderMode == DotRenderMode.THRESHOLD && (double)spread <= (Double)Config.CLIENT.display.dynamicCrosshairDotThreshold.get() && ((Boolean)Config.CLIENT.display.onlyRenderDotWhileAiming.get() == false || finalSpreadTranslate > 0.9f);
        }
        float baseScale = 1.0f + Mth.m_14179_((float)partialTicks, (float)this.prevScale, (float)this.scale) * scaleMultiplier;
        float adjustedSpread = spread > 1.0f ? (float)(1.0 + Math.log(spread) / 1.5) : spread;
        float fireBloomScale = Mth.m_14179_((float)partialTicks, (float)this.prevScale, (float)this.scale) * scaleMultiplier;
        float spreadScale = (float)((double)adjustedSpread * 2.0 * (Double)Config.CLIENT.display.dynamicCrosshairSpreadMultiplier.get());
        float scale = baseScale + spreadScale + fireBloomScale;
        scale = Math.min(scale, (float)((Double)Config.CLIENT.display.dynamicCrosshairMaxScale.get()).doubleValue() + fireBloomScale);
        float scaleSize = scale / 6.0f + 1.15f;
        float crosshairBaseTightness = (float)(0.8 - (Double)Config.CLIENT.display.dynamicCrosshairBaseSpread.get() / 2.0);
        finalSpreadTranslate = (float)(Mth.m_14139_((double)0.95, (double)(scaleSize - 1.0f), (double)Math.log(scaleSize)) * (double)2.8f);
        double windowCenteredX = (double)Math.round((float)windowWidth / 2.0f) - 0.5;
        double windowCenteredY = (double)Math.round((float)windowHeight / 2.0f) - 0.5;
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        stack.m_85836_();
        Matrix4f matrix = stack.m_85850_().m_252922_();
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)DYNAMIC_CROSSHAIR_H);
        stack.m_85837_(windowCenteredX, windowCenteredY, 0.0);
        stack.m_85841_(scaleSize, 1.0f, 1.0f);
        stack.m_252880_(-size1 / 2.0f - finalSpreadTranslate + crosshairBaseTightness - 0.0f, -size2 / 2.0f, 0.0f);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        buffer.m_252986_(matrix, 0.0f, size2, 0.0f).m_7421_(0.0f, 0.11111111f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        buffer.m_252986_(matrix, size1, size2, 0.0f).m_7421_(1.0f, 0.11111111f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        buffer.m_252986_(matrix, size1, 0.0f, 0.0f).m_7421_(1.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        buffer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_7421_(0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        stack.m_85849_();
        stack.m_85836_();
        matrix = stack.m_85850_().m_252922_();
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)DYNAMIC_CROSSHAIR_H);
        stack.m_85837_(windowCenteredX, windowCenteredY, 0.0);
        stack.m_85841_(scaleSize, 1.0f, 1.0f);
        stack.m_252880_(-size1 / 2.0f + finalSpreadTranslate - crosshairBaseTightness, -size2 / 2.0f, 0.0f);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        buffer.m_252986_(matrix, 0.0f, size2, 0.0f).m_7421_(0.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        buffer.m_252986_(matrix, size1, size2, 0.0f).m_7421_(1.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        buffer.m_252986_(matrix, size1, 0.0f, 0.0f).m_7421_(1.0f, 0.8888889f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        buffer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_7421_(0.0f, 0.8888889f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        stack.m_85849_();
        stack.m_85836_();
        matrix = stack.m_85850_().m_252922_();
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)DYNAMIC_CROSSHAIR_V);
        stack.m_85837_(windowCenteredX, windowCenteredY, 0.0);
        stack.m_85841_(1.0f, scaleSize, 1.0f);
        stack.m_252880_(-size2 / 2.0f, -size1 / 2.0f - finalSpreadTranslate + crosshairBaseTightness, 0.0f);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        buffer.m_252986_(matrix, 0.0f, size1, 0.0f).m_7421_(0.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        buffer.m_252986_(matrix, size2, size1, 0.0f).m_7421_(0.11111111f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        buffer.m_252986_(matrix, size2, 0.0f, 0.0f).m_7421_(0.11111111f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        buffer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_7421_(0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        stack.m_85849_();
        stack.m_85836_();
        matrix = stack.m_85850_().m_252922_();
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)DYNAMIC_CROSSHAIR_V);
        stack.m_85837_(windowCenteredX, windowCenteredY, 0.0);
        stack.m_85841_(1.0f, scaleSize, 1.0f);
        stack.m_252880_(-size2 / 2.0f - 0.0f, -size1 / 2.0f + finalSpreadTranslate - crosshairBaseTightness, 0.0f);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        buffer.m_252986_(matrix, 0.0f, size1, 0.0f).m_7421_(0.8888889f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        buffer.m_252986_(matrix, size2, size1, 0.0f).m_7421_(1.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        buffer.m_252986_(matrix, size2, 0.0f, 0.0f).m_7421_(1.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        buffer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_7421_(0.8888889f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        stack.m_85849_();
        if (renderDot) {
            stack.m_85836_();
            int dotSize = 9;
            RenderSystem.setShader(GameRenderer::m_172820_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)DOT_CROSSHAIR);
            matrix = stack.m_85850_().m_252922_();
            stack.m_85837_(windowCenteredX, windowCenteredY, 0.0);
            stack.m_252880_((float)(-dotSize) / 2.0f, (float)(-dotSize) / 2.0f, 0.0f);
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            buffer.m_252986_(matrix, 0.0f, (float)dotSize, 0.0f).m_7421_(0.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
            buffer.m_252986_(matrix, (float)dotSize, (float)dotSize, 0.0f).m_7421_(1.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
            buffer.m_252986_(matrix, (float)dotSize, 0.0f, 0.0f).m_7421_(1.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
            buffer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_7421_(0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
            stack.m_85849_();
        }
        RenderSystem.defaultBlendFunc();
    }
}

