/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.client.render.pose;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import top.ribs.scguns.client.handler.GunRenderingHandler;
import top.ribs.scguns.client.render.IHeldAnimation;
import top.ribs.scguns.client.util.RenderUtil;
import top.ribs.scguns.item.animated.AnimatedGunItem;

public class OneHanded2Pose
implements IHeldAnimation {
    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void applyPlayerModelRotation(Player player, ModelPart rightArm, ModelPart leftArm, ModelPart head, InteractionHand hand, float aimProgress) {
        boolean right = Minecraft.m_91087_().f_91066_.m_232107_().m_231551_() == HumanoidArm.RIGHT ? hand == InteractionHand.MAIN_HAND : hand == InteractionHand.OFF_HAND;
        ModelPart arm = right ? rightArm : leftArm;
        GunRenderingHandler renderingHandler = GunRenderingHandler.get();
        if (renderingHandler.isThirdPersonMeleeAttacking()) {
            this.applySimplifiedMeleePose(player, arm, renderingHandler.getThirdPersonMeleeProgress());
        } else {
            IHeldAnimation.copyModelAngles(head, arm);
            arm.f_104203_ += (float)Math.toRadians(-90.0);
            if (player.m_21211_().m_41720_() == Items.f_42740_) {
                arm.f_104203_ = (float)Math.toRadians(-30.0);
            }
        }
    }

    private void applySimplifiedMeleePose(Player player, ModelPart arm, float progress) {
        if (progress < 0.2f) {
            float lowerProgress = progress / 0.2f;
            arm.f_104203_ = (float)Math.toRadians(-70.0f - 10.0f * lowerProgress);
            arm.f_104204_ = 0.0f;
        } else if (progress < 0.7f) {
            float swingProgress = (progress - 0.2f) / 0.5f;
            arm.f_104203_ = (float)Math.toRadians(-80.0f + 80.0f * swingProgress);
            arm.f_104204_ = 0.0f;
        } else {
            float returnProgress = (progress - 0.7f) / 0.3f;
            arm.f_104203_ = (float)Math.toRadians(0.0f - 70.0f * returnProgress);
            arm.f_104204_ = 0.0f;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderFirstPersonArms(Player player, HumanoidArm hand, ItemStack stack, PoseStack poseStack, MultiBufferSource buffer, int light, float partialTicks) {
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        if (stack.m_41720_() instanceof AnimatedGunItem) {
            return;
        }
        BakedModel model = Minecraft.m_91087_().m_91291_().m_174264_(stack, player.m_9236_(), (LivingEntity)player, 0);
        float translateX = model.m_7442_().f_111790_.f_111756_.x();
        float translateZ = model.m_7442_().f_111790_.f_111756_.z();
        int side = hand.m_20828_() == HumanoidArm.RIGHT ? 1 : -1;
        poseStack.m_252880_(translateX * (float)side, 0.0f, -translateZ - 0.1f);
        boolean slim = Minecraft.m_91087_().f_91074_.m_108564_().equals("slim");
        float armWidth = slim ? 3.0f : 4.0f;
        poseStack.m_85841_(0.55f, 0.55f, 0.55f);
        poseStack.m_85837_(-0.25 * (double)side, 0.0, 0.0);
        poseStack.m_85837_(-((double)armWidth / 2.0) * 0.0625 * (double)side, 0.0, 0.1);
        poseStack.m_85837_(0.0, 0.22, -1.0);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(75.0f));
        RenderUtil.renderFirstPersonArm((LocalPlayer)player, hand, poseStack, buffer, light);
    }

    @Override
    public boolean applyOffhandTransforms(Player player, PlayerModel model, ItemStack stack, PoseStack poseStack, float partialTicks) {
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        if (player.m_6047_()) {
            poseStack.m_85837_(-0.28125, -0.9375, -0.25);
        } else if (!player.m_6844_(EquipmentSlot.LEGS).m_41619_()) {
            poseStack.m_85837_(-0.25, -0.8125, 0.0625);
        } else {
            poseStack.m_85837_(-0.21875, -0.8125, 0.0625);
        }
        poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(75.0f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_((float)(Math.toDegrees(model.f_102813_.f_104203_) / 10.0)));
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        return true;
    }

    @Override
    public boolean canApplySprintingAnimation() {
        return false;
    }

    @Override
    public boolean canRenderOffhandItem() {
        return true;
    }

    @Override
    public double getFallSwayZOffset() {
        return 0.5;
    }
}

