/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import top.ribs.scguns.Config;
import top.ribs.scguns.common.FireMode;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.common.network.ServerPlayHandler;
import top.ribs.scguns.init.ModTags;

public class BeamHandlerCommon {

    public static class BeamMiningManager {
        private static final Map<UUID, Integer> playerBreakingIds = new HashMap<UUID, Integer>();
        private static final Map<BlockPos, MiningProgress> miningProgress = new HashMap<BlockPos, MiningProgress>();
        private static int nextBreakerId = 1;
        private static final long RESET_TIMEOUT = 1000L;
        private static final double GLASS_PENETRATION_DAMAGE_REDUCTION = 0.15;

        public static HitResult getBeamHitResult(Level world, Vec3 startVec, Vec3 endVec, Entity shooter, double maxDistance) {
            Vec3 currentPos = startVec;
            Vec3 direction = endVec.m_82546_(startVec).m_82541_();
            ArrayList<BlockHitResult> glassPenetrations = new ArrayList<BlockHitResult>();
            double distanceTraveled = 0.0;
            double remainingDamageMultiplier = 1.0;
            while (distanceTraveled < maxDistance) {
                Vec3 nextEndVec = currentPos.m_82549_(direction.m_82490_(maxDistance - distanceTraveled));
                BlockHitResult blockHit = world.m_45547_(new ClipContext(currentPos, nextEndVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, shooter));
                if (blockHit.m_6662_() == HitResult.Type.MISS) {
                    EntityHitResult entityHit = ServerPlayHandler.rayTraceEntities(world, shooter, currentPos, nextEndVec);
                    if (entityHit != null) {
                        ExtendedEntityHitResult extendedEntityHit = ExtendedEntityHitResult.fromEntityHitResult(entityHit);
                        extendedEntityHit.setDamageMultiplier(remainingDamageMultiplier);
                        return extendedEntityHit;
                    }
                    return blockHit;
                }
                BlockState hitState = world.m_8055_(blockHit.m_82425_());
                if (BeamMiningManager.isGlassBlock(hitState)) {
                    glassPenetrations.add(blockHit);
                    remainingDamageMultiplier *= 0.85;
                    currentPos = blockHit.m_82450_().m_82549_(direction.m_82490_(0.01));
                    distanceTraveled = currentPos.m_82546_(startVec).m_82553_();
                    continue;
                }
                EntityHitResult entityHit = ServerPlayHandler.rayTraceEntities(world, shooter, currentPos, blockHit.m_82450_());
                if (entityHit != null) {
                    ExtendedEntityHitResult extendedEntityHit = ExtendedEntityHitResult.fromEntityHitResult(entityHit);
                    extendedEntityHit.setDamageMultiplier(remainingDamageMultiplier);
                    return extendedEntityHit;
                }
                ExtendedBlockHitResult extendedBlockHit = ExtendedBlockHitResult.fromBlockHitResult(blockHit);
                extendedBlockHit.setDamageMultiplier(remainingDamageMultiplier);
                extendedBlockHit.setGlassPenetrations(glassPenetrations);
                return extendedBlockHit;
            }
            return BlockHitResult.m_82426_((Vec3)endVec, (Direction)Direction.UP, (BlockPos)new BlockPos(Mth.m_14107_((double)endVec.f_82479_), Mth.m_14107_((double)endVec.f_82480_), Mth.m_14107_((double)endVec.f_82481_)));
        }

        private static boolean isGlassBlock(BlockState state) {
            return state.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("forge", "glass"))) || state.m_60713_(Blocks.f_50058_) || state.m_60713_(Blocks.f_50185_) || state.m_60713_(Blocks.f_152498_);
        }

        public static void updateBlockMining(Level world, BlockPos pos, ServerPlayer player, Gun modifiedGun) {
            BlockState state = world.m_8055_(pos);
            if (state.m_60795_() || BeamMiningManager.isGlassBlock(state)) {
                return;
            }
            if (BeamMiningManager.handleFragileBlock(world, pos, state, modifiedGun)) {
                return;
            }
            if (!((Boolean)Config.COMMON.gameplay.griefing.enableBeamMining.get()).booleanValue() || !modifiedGun.getGeneral().canMine()) {
                return;
            }
            BeamMiningManager.handleBeamMining(world, pos, state, player, modifiedGun);
        }

        private static boolean handleFragileBlock(Level world, BlockPos pos, BlockState state, Gun modifiedGun) {
            if (!((Boolean)Config.COMMON.gameplay.griefing.enableGlassBreaking.get()).booleanValue() || !state.m_204336_(ModTags.Blocks.FRAGILE)) {
                return false;
            }
            float destroySpeed = state.m_60800_((BlockGetter)world, pos);
            if (destroySpeed < 0.0f) {
                return false;
            }
            float baseChance = ((Double)Config.COMMON.gameplay.griefing.fragileBaseBreakChance.get()).floatValue();
            float beamModifier = modifiedGun.getGeneral().getFireMode() == FireMode.BEAM ? 2.0f : 1.5f;
            float chance = baseChance * beamModifier / (destroySpeed + 1.0f);
            if (world.f_46441_.m_188501_() < chance) {
                world.m_46961_(pos, ((Boolean)Config.COMMON.gameplay.griefing.fragileBlockDrops.get()).booleanValue());
                return true;
            }
            return false;
        }

        private static void handleBeamMining(Level world, BlockPos pos, BlockState state, ServerPlayer player, Gun modifiedGun) {
            ServerLevel serverLevel;
            float hardness = state.m_60800_((BlockGetter)world, pos);
            if (hardness < 0.0f) {
                return;
            }
            MiningProgress progress = miningProgress.computeIfAbsent(pos, k -> new MiningProgress(player.m_20148_()));
            if (!progress.minerId.equals(player.m_20148_())) {
                return;
            }
            progress.isActive = true;
            progress.lastUpdate = System.currentTimeMillis();
            float miningSpeed = modifiedGun.getGeneral().getMiningSpeed();
            float progressIncrement = miningSpeed / (hardness * 10.0f);
            progress.progress += progressIncrement;
            int newStage = Math.min((int)(progress.progress * 10.0f), 9);
            if (newStage != progress.lastStage) {
                progress.lastStage = newStage;
                if (world instanceof ServerLevel) {
                    serverLevel = (ServerLevel)world;
                    serverLevel.m_6801_(progress.breakerId, pos, newStage);
                }
            }
            if (progress.progress >= 1.0f) {
                if (world instanceof ServerLevel) {
                    serverLevel = (ServerLevel)world;
                    serverLevel.m_6801_(progress.breakerId, pos, -1);
                }
                miningProgress.remove(pos);
                if (player.f_8941_.m_9290_() == GameType.CREATIVE) {
                    world.m_7471_(pos, false);
                } else {
                    BeamMiningManager.breakBlockWithEnchantments(world, pos, state, player);
                }
            }
        }

        private static void breakBlockWithEnchantments(Level world, BlockPos pos, BlockState blockState, ServerPlayer player) {
            ItemStack weapon = player.m_21205_();
            BlockEntity blockEntity = blockState.m_155947_() ? world.m_7702_(pos) : null;
            int silkTouchLevel = weapon.getEnchantmentLevel(Enchantments.f_44985_);
            if (silkTouchLevel > 0) {
                Block.m_49881_((BlockState)blockState, (Level)world, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)player, (ItemStack)weapon);
                world.m_7471_(pos, false);
                world.m_46796_(2001, pos, Block.m_49956_((BlockState)blockState));
                return;
            }
            int fortuneLevel = weapon.getEnchantmentLevel(Enchantments.f_44987_);
            if (fortuneLevel > 0 && world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                LootParams.Builder builder = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_287286_(LootContextParams.f_81463_, (Object)weapon).m_287289_(LootContextParams.f_81455_, (Object)player).m_287289_(LootContextParams.f_81462_, (Object)blockEntity);
                List drops = blockState.m_287290_(builder);
                if (blockState.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("forge", "ores")))) {
                    for (ItemStack drop : drops) {
                        Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)drop);
                    }
                } else {
                    for (ItemStack drop : drops) {
                        Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)drop);
                    }
                }
            } else {
                Block.m_49881_((BlockState)blockState, (Level)world, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)player, (ItemStack)weapon);
            }
            world.m_7471_(pos, false);
            world.m_46796_(2001, pos, Block.m_49956_((BlockState)blockState));
        }

        public static void tickMiningProgress(Level world) {
            long currentTime = System.currentTimeMillis();
            Iterator<Map.Entry<BlockPos, MiningProgress>> iterator = miningProgress.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<BlockPos, MiningProgress> entry = iterator.next();
                MiningProgress progress = entry.getValue();
                if (!progress.isActive && currentTime - progress.lastUpdate >= 1000L) {
                    if (world instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)world;
                        serverLevel.m_6801_(progress.breakerId, entry.getKey(), -1);
                    }
                    iterator.remove();
                    continue;
                }
                if (!progress.isActive && currentTime - progress.lastUpdate >= 50L) continue;
                progress.isActive = false;
            }
        }

        public static class ExtendedEntityHitResult
        extends EntityHitResult {
            private double damageMultiplier = 1.0;

            public ExtendedEntityHitResult(Entity entity, Vec3 location) {
                super(entity, location);
            }

            public void setDamageMultiplier(double multiplier) {
                this.damageMultiplier = multiplier;
            }

            public double getDamageMultiplier() {
                return this.damageMultiplier;
            }

            public static ExtendedEntityHitResult fromEntityHitResult(EntityHitResult original) {
                return new ExtendedEntityHitResult(original.m_82443_(), original.m_82450_());
            }
        }

        public static class ExtendedBlockHitResult
        extends BlockHitResult {
            private double damageMultiplier = 1.0;
            private List<BlockHitResult> glassPenetrations = new ArrayList<BlockHitResult>();

            public ExtendedBlockHitResult(Vec3 location, Direction direction, BlockPos blockPos, boolean insideBlock) {
                super(location, direction, blockPos, insideBlock);
            }

            public static ExtendedBlockHitResult fromBlockHitResult(BlockHitResult original) {
                return new ExtendedBlockHitResult(original.m_82450_(), original.m_82434_(), original.m_82425_(), original.m_82436_());
            }

            public void setDamageMultiplier(double multiplier) {
                this.damageMultiplier = multiplier;
            }

            public double getDamageMultiplier() {
                return this.damageMultiplier;
            }

            public void setGlassPenetrations(List<BlockHitResult> penetrations) {
                this.glassPenetrations = penetrations;
            }

            public List<BlockHitResult> getGlassPenetrations() {
                return this.glassPenetrations;
            }
        }

        private static class MiningProgress {
            float progress = 0.0f;
            long lastUpdate = System.currentTimeMillis();
            UUID minerId;
            int breakerId;
            boolean isActive;
            int lastStage;

            public MiningProgress(UUID minerId) {
                this.minerId = minerId;
                this.breakerId = playerBreakingIds.computeIfAbsent(minerId, k -> nextBreakerId++);
                this.isActive = true;
                this.lastStage = -1;
            }
        }
    }
}

