/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.config;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="scguns")
public class MerchantTradeConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, List<TradeData>> TRADE_SECTIONS = new HashMap<String, List<TradeData>>();
    private static final Map<String, Integer> SECTION_LIMITS = new HashMap<String, Integer>();
    private static int maxTotalOffers = 9;
    private static final ResourceLocation CONFIG_LOCATION = new ResourceLocation("scguns", "entity/merchant_trades.json");

    public static void loadConfig(ResourceManager resourceManager) {
        block15: {
            TRADE_SECTIONS.clear();
            SECTION_LIMITS.clear();
            try {
                Resource resource = resourceManager.m_213713_(CONFIG_LOCATION).orElse(null);
                if (resource != null) {
                    try (InputStreamReader reader = new InputStreamReader(resource.m_215507_(), StandardCharsets.UTF_8);){
                        Gson gson = new Gson();
                        JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                        if (json.has("max_total_offers")) {
                            maxTotalOffers = json.get("max_total_offers").getAsInt();
                        }
                        if (json.has("section_limits")) {
                            JsonObject limitsObj = json.getAsJsonObject("section_limits");
                            for (Map.Entry entry : limitsObj.entrySet()) {
                                SECTION_LIMITS.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsInt());
                            }
                        }
                        if (json.has("sections")) {
                            JsonObject sectionsObj = json.getAsJsonObject("sections");
                            for (Map.Entry sectionEntry : sectionsObj.entrySet()) {
                                String sectionName = (String)sectionEntry.getKey();
                                JsonArray tradesArray = ((JsonElement)sectionEntry.getValue()).getAsJsonArray();
                                ArrayList<TradeData> sectionTrades = new ArrayList<TradeData>();
                                for (JsonElement element : tradesArray) {
                                    JsonObject tradeObj = element.getAsJsonObject();
                                    TradeData trade = MerchantTradeConfig.parseTradeData(tradeObj, sectionName);
                                    if (trade == null) continue;
                                    sectionTrades.add(trade);
                                }
                                TRADE_SECTIONS.put(sectionName, sectionTrades);
                            }
                        }
                        LOGGER.info("Loaded merchant trade config: {} sections with {} max offers", (Object)TRADE_SECTIONS.size(), (Object)maxTotalOffers);
                        for (Map.Entry<String, List<TradeData>> entry : TRADE_SECTIONS.entrySet()) {
                            LOGGER.info("Section '{}': {} trades (limit: {})", (Object)entry.getKey(), (Object)entry.getValue().size(), (Object)SECTION_LIMITS.getOrDefault(entry.getKey(), 999));
                        }
                        break block15;
                    }
                }
                LOGGER.warn("Merchant trades config not found at {}, using defaults", (Object)CONFIG_LOCATION);
                MerchantTradeConfig.loadDefaultTrades();
            }
            catch (Exception e) {
                LOGGER.error("Failed to load merchant trades config at {}, using defaults", (Object)CONFIG_LOCATION, (Object)e);
                MerchantTradeConfig.loadDefaultTrades();
            }
        }
    }

    private static TradeData parseTradeData(JsonObject tradeObj, String section) {
        try {
            JsonObject sellItemObj;
            ItemStack sellItem;
            JsonObject buyItemObj = tradeObj.getAsJsonObject("buy_item");
            ItemStack buyItem = MerchantTradeConfig.parseItemStack(buyItemObj);
            if (buyItem.m_41619_()) {
                LOGGER.warn("Invalid buy_item in trade config for section {}", (Object)section);
                return null;
            }
            ItemStack buyItem2 = ItemStack.f_41583_;
            if (tradeObj.has("buy_item_2")) {
                JsonObject buyItem2Obj = tradeObj.getAsJsonObject("buy_item_2");
                buyItem2 = MerchantTradeConfig.parseItemStack(buyItem2Obj);
            }
            if ((sellItem = MerchantTradeConfig.parseItemStack(sellItemObj = tradeObj.getAsJsonObject("sell_item"))).m_41619_()) {
                LOGGER.warn("Invalid sell_item in trade config for section {}", (Object)section);
                return null;
            }
            int maxUses = tradeObj.has("max_uses") ? tradeObj.get("max_uses").getAsInt() : 2;
            int xpReward = tradeObj.has("xp_reward") ? tradeObj.get("xp_reward").getAsInt() : 5;
            float priceMultiplier = tradeObj.has("price_multiplier") ? tradeObj.get("price_multiplier").getAsFloat() : 0.05f;
            return new TradeData(buyItem, buyItem2, sellItem, maxUses, xpReward, priceMultiplier, section);
        }
        catch (Exception e) {
            LOGGER.error("Error parsing trade data for section {}", (Object)section, (Object)e);
            return null;
        }
    }

    private static ItemStack parseItemStack(JsonObject itemObj) {
        try {
            String itemId = itemObj.get("item").getAsString();
            int count = itemObj.has("count") ? itemObj.get("count").getAsInt() : 1;
            ResourceLocation itemLocation = new ResourceLocation(itemId);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(itemLocation);
            if (item == null || item == Items.f_41852_) {
                LOGGER.warn("Unknown item: {}", (Object)itemId);
                return ItemStack.f_41583_;
            }
            return new ItemStack((ItemLike)item, count);
        }
        catch (Exception e) {
            LOGGER.error("Error parsing item stack", (Throwable)e);
            return ItemStack.f_41583_;
        }
    }

    private static void loadDefaultTrades() {
    }

    public static MerchantOffers createMerchantOffers() {
        return MerchantTradeConfig.createRandomizedOffers(new Random());
    }

    public static MerchantOffers createRandomizedOffers(Random random) {
        MerchantOffers offers = new MerchantOffers();
        List selectedTrades = new ArrayList();
        for (Map.Entry<String, List<TradeData>> sectionEntry : TRADE_SECTIONS.entrySet()) {
            String sectionName = sectionEntry.getKey();
            List<TradeData> sectionTrades = sectionEntry.getValue();
            int sectionLimit = SECTION_LIMITS.getOrDefault(sectionName, Math.min(3, sectionTrades.size()));
            if (sectionTrades.isEmpty()) continue;
            ArrayList<TradeData> shuffledTrades = new ArrayList<TradeData>(sectionTrades);
            Collections.shuffle(shuffledTrades, random);
            int tradesToAdd = Math.min(sectionLimit, shuffledTrades.size());
            selectedTrades.addAll(shuffledTrades.subList(0, tradesToAdd));
        }
        if (selectedTrades.size() > maxTotalOffers) {
            Collections.shuffle(selectedTrades, random);
            selectedTrades = selectedTrades.subList(0, maxTotalOffers);
        }
        for (TradeData trade : selectedTrades) {
            offers.add((Object)trade.toMerchantOffer());
        }
        return offers;
    }

    public static int getMaxTotalOffers() {
        return maxTotalOffers;
    }

    public static Map<String, Integer> getSectionLimits() {
        return new HashMap<String, Integer>(SECTION_LIMITS);
    }

    @SubscribeEvent
    public static void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new SimplePreparableReloadListener<Void>(){

            protected Void prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
                return null;
            }

            protected void apply(Void object, ResourceManager resourceManager, ProfilerFiller profiler) {
                MerchantTradeConfig.loadConfig(resourceManager);
            }
        });
    }

    public static class TradeData {
        public final ItemStack buyItem;
        public final ItemStack buyItem2;
        public final ItemStack sellItem;
        public final int maxUses;
        public final int xpReward;
        public final float priceMultiplier;
        public final String section;

        public TradeData(ItemStack buyItem, ItemStack buyItem2, ItemStack sellItem, int maxUses, int xpReward, float priceMultiplier, String section) {
            this.buyItem = buyItem;
            this.buyItem2 = buyItem2;
            this.sellItem = sellItem;
            this.maxUses = maxUses;
            this.xpReward = xpReward;
            this.priceMultiplier = priceMultiplier;
            this.section = section;
        }

        public MerchantOffer toMerchantOffer() {
            if (this.buyItem2.m_41619_()) {
                return new MerchantOffer(this.buyItem, this.sellItem, this.maxUses, this.xpReward, this.priceMultiplier);
            }
            return new MerchantOffer(this.buyItem, this.buyItem2, this.sellItem, this.maxUses, this.xpReward, this.priceMultiplier);
        }
    }
}

