/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.config;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.ribs.scguns.entity.player.GunTier;
import top.ribs.scguns.entity.player.GunTierRegistry;

@Mod.EventBusSubscriber(modid="scguns")
public class TieredWeaponConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, List<Item>> TIER_WEAPONS = new HashMap<String, List<Item>>();
    private static final ResourceLocation CONFIG_LOCATION = new ResourceLocation("scguns", "entity/tier_weapons.json");

    public static void loadConfig(ResourceManager resourceManager) {
        block13: {
            TIER_WEAPONS.clear();
            try {
                Resource resource = resourceManager.m_213713_(CONFIG_LOCATION).orElse(null);
                if (resource != null) {
                    try (InputStreamReader reader = new InputStreamReader(resource.m_215507_(), StandardCharsets.UTF_8);){
                        Gson gson = new Gson();
                        JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                        if (json != null) {
                            for (Map.Entry entry : json.entrySet()) {
                                String tierIdOrName = (String)entry.getKey();
                                JsonArray weaponsArray = ((JsonElement)entry.getValue()).getAsJsonArray();
                                GunTier tier = GunTierRegistry.getTier(tierIdOrName.toLowerCase());
                                if (tier == null) {
                                    LOGGER.warn("Unknown tier in tier_weapons.json: {}", (Object)tierIdOrName);
                                    continue;
                                }
                                ArrayList<Item> weapons = new ArrayList<Item>();
                                for (JsonElement weaponElement : weaponsArray) {
                                    String weaponId = weaponElement.getAsString();
                                    Item weapon = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(weaponId));
                                    if (weapon != null) {
                                        weapons.add(weapon);
                                        continue;
                                    }
                                    LOGGER.warn("Unknown weapon item for tier {}: {}", (Object)tierIdOrName, (Object)weaponId);
                                }
                                TIER_WEAPONS.put(tier.getId(), weapons);
                            }
                        }
                        LOGGER.info("Loaded tiered weapon config: {} tiers configured", (Object)TIER_WEAPONS.size());
                        break block13;
                    }
                }
                LOGGER.warn("Tiered weapon config not found at {}", (Object)CONFIG_LOCATION);
                TieredWeaponConfig.loadDefaults();
            }
            catch (Exception e) {
                LOGGER.error("Failed to load tiered weapon config at {}", (Object)CONFIG_LOCATION, (Object)e);
                TieredWeaponConfig.loadDefaults();
            }
        }
    }

    private static void loadDefaults() {
        LOGGER.info("Loading default tiered weapon configuration");
    }

    @Nullable
    public static Item getRandomWeaponForTier(GunTier tier, RandomSource random) {
        if (tier == null) {
            return null;
        }
        List<Item> weapons = TIER_WEAPONS.get(tier.getId());
        if (weapons == null || weapons.isEmpty()) {
            return null;
        }
        return weapons.get(random.m_188503_(weapons.size()));
    }

    public static List<Item> getWeaponsForTier(GunTier tier) {
        if (tier == null) {
            return Collections.emptyList();
        }
        return TIER_WEAPONS.getOrDefault(tier.getId(), Collections.emptyList());
    }

    public static boolean hasTierWeapons(GunTier tier) {
        if (tier == null) {
            return false;
        }
        List<Item> weapons = TIER_WEAPONS.get(tier.getId());
        return weapons != null && !weapons.isEmpty();
    }

    @SubscribeEvent
    public static void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new SimplePreparableReloadListener<Void>(){

            protected Void prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
                return null;
            }

            protected void apply(Void object, ResourceManager resourceManager, ProfilerFiller profiler) {
                TieredWeaponConfig.loadConfig(resourceManager);
            }
        });
    }
}

