/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.ai;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import top.ribs.scguns.entity.util.GoldConsumptionHelper;
import top.ribs.scguns.entity.util.IGoldConsumingEntity;

public class GoldSeekingGoal
extends Goal {
    private final Mob entity;
    private final IGoldConsumingEntity goldConsumer;
    private final double speed;
    private final float searchRange;
    private ItemEntity targetGold;

    public GoldSeekingGoal(Mob entity, IGoldConsumingEntity goldConsumer, double speed, float searchRange) {
        this.entity = entity;
        this.goldConsumer = goldConsumer;
        this.speed = speed;
        this.searchRange = searchRange;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.goldConsumer.isEatingGold() || this.goldConsumer.isPreparingToEat()) {
            return false;
        }
        this.targetGold = this.findNearestGold();
        return this.targetGold != null;
    }

    public boolean m_8045_() {
        if (this.goldConsumer.isEatingGold() || this.goldConsumer.isPreparingToEat()) {
            return false;
        }
        return this.targetGold != null && !this.targetGold.m_213877_();
    }

    public void m_8056_() {
        if (this.targetGold != null) {
            this.entity.m_21573_().m_5624_((Entity)this.targetGold, this.speed);
        }
    }

    public void m_8041_() {
        this.targetGold = null;
        this.entity.m_21573_().m_26573_();
    }

    public void m_8037_() {
        if (this.targetGold != null && this.entity.m_21573_().m_26571_()) {
            this.entity.m_21573_().m_5624_((Entity)this.targetGold, this.speed);
        }
    }

    private ItemEntity findNearestGold() {
        AABB searchArea = AABB.m_82333_((Vec3)this.entity.m_20182_()).m_82400_((double)this.searchRange);
        return this.entity.m_9236_().m_45976_(ItemEntity.class, searchArea).stream().filter(item -> !item.m_213877_()).filter(item -> GoldConsumptionHelper.isGoldItem(item.m_32055_())).min((item1, item2) -> Double.compare(this.entity.m_20280_((Entity)item1), this.entity.m_20280_((Entity)item2))).orElse(null);
    }
}

