/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import org.jetbrains.annotations.NotNull;
import top.ribs.scguns.entity.monster.FinforcerEntity;
import top.ribs.scguns.item.GunItem;

public class FinforcerModel<T extends FinforcerEntity>
extends HierarchicalModel<T>
implements ArmedModel {
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart right_arm;
    private final ModelPart left_arm;
    private final ModelPart tail;
    private final ModelPart tail_fin;
    private final ModelPart back_fin;
    private final PartPose bodyDefault;
    private final PartPose headDefault;
    private final PartPose tailDefault;
    private final PartPose rightArmDefault;
    private final PartPose leftArmDefault;
    private final PartPose backFinDefault;
    private float attackStartTime = -1.0f;
    private int lastAttackTimeout = 0;
    private static final float ATTACK_DURATION = 12.0f;

    public FinforcerModel(ModelPart root) {
        this.root = root;
        this.body = root.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.right_arm = this.body.m_171324_("right_arm");
        this.left_arm = this.body.m_171324_("left_arm");
        this.tail = root.m_171324_("tail");
        this.tail_fin = this.tail.m_171324_("tail_fin");
        this.back_fin = this.body.m_171324_("back_fin");
        this.bodyDefault = this.body.m_171308_();
        this.headDefault = this.head.m_171308_();
        this.tailDefault = this.tail.m_171308_();
        this.rightArmDefault = this.right_arm.m_171308_();
        this.leftArmDefault = this.left_arm.m_171308_();
        this.backFinDefault = this.back_fin.m_171308_();
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)-3.0f));
        PartDefinition body_r1 = body.m_171599_("body_r1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -1.0f, 7.0f, 3.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)-19.5f, (float)2.25f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition body_r2 = body.m_171599_("body_r2", CubeListBuilder.m_171558_().m_171514_(42, 10).m_171488_(-5.0f, -8.0f, 8.0f, 9.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)-20.0f, (float)2.5f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition body_r3 = body.m_171599_("body_r3", CubeListBuilder.m_171558_().m_171514_(42, 0).m_171488_(-3.5f, -3.5f, -2.5f, 7.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-23.75f, (float)5.0f, (float)-2.3562f, (float)0.0f, (float)0.0f));
        PartDefinition body_r4 = body.m_171599_("body_r4", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -7.0f, -3.0f, 8.0f, 7.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-20.0f, (float)3.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171488_(-4.5f, -7.6f, -6.25f, 9.0f, 4.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(38, 27).m_171488_(-4.5f, -3.6f, -1.25f, 9.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(32, 34).m_171488_(-4.0f, -7.5f, -5.5f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 60).m_171488_(-1.5f, -5.5f, 2.5f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(14, 51).m_171488_(-1.0f, -2.75f, -9.5f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 51).m_171488_(-1.0f, 0.0f, -8.5f, 2.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-23.5f, (float)4.5f));
        PartDefinition head_r1 = head.m_171599_("head_r1", CubeListBuilder.m_171558_().m_171514_(62, 52).m_171488_(0.0f, 0.0f, 0.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(42, 62).m_171488_(7.0f, 0.0f, 0.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.5f, (float)-1.75f, (float)-6.75f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition head_r2 = head.m_171599_("head_r2", CubeListBuilder.m_171558_().m_171514_(36, 62).m_171488_(0.0f, 0.0f, 0.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.9142f, (float)-1.75f, (float)-5.3358f, (float)-0.7854f, (float)0.7854f, (float)0.0f));
        PartDefinition head_r3 = head.m_171599_("head_r3", CubeListBuilder.m_171558_().m_171514_(54, 61).m_171488_(-2.0f, 0.0f, 0.0f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.1488f, (float)-1.75f, (float)-3.488f, (float)2.3562f, (float)1.1781f, (float)3.1416f));
        PartDefinition head_r4 = head.m_171599_("head_r4", CubeListBuilder.m_171558_().m_171514_(62, 10).m_171488_(-2.0f, 0.0f, 0.0f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.3835f, (float)-1.75f, (float)0.3597f, (float)0.0f, (float)1.5708f, (float)0.7854f));
        PartDefinition head_r5 = head.m_171599_("head_r5", CubeListBuilder.m_171558_().m_171514_(62, 54).m_171488_(0.0f, 0.0f, 0.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.3835f, (float)-2.4077f, (float)3.8663f, (float)0.7854f, (float)1.1781f, (float)1.5708f));
        PartDefinition head_r6 = head.m_171599_("head_r6", CubeListBuilder.m_171558_().m_171514_(62, 56).m_171488_(0.9068f, -0.3533f, -4.2073f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-2.4743f, (float)4.3152f, (float)1.8744f, (float)0.5797f, (float)2.1488f));
        PartDefinition head_r7 = head.m_171599_("head_r7", CubeListBuilder.m_171558_().m_171514_(62, 50).m_171488_(-2.9068f, -0.3533f, -4.2073f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-2.4743f, (float)4.3152f, (float)1.8744f, (float)-0.5797f, (float)-2.1488f));
        PartDefinition head_r8 = head.m_171599_("head_r8", CubeListBuilder.m_171558_().m_171514_(48, 62).m_171488_(-2.0f, 0.0f, 0.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.3835f, (float)-2.4077f, (float)3.8663f, (float)0.7854f, (float)-1.1781f, (float)-1.5708f));
        PartDefinition head_r9 = head.m_171599_("head_r9", CubeListBuilder.m_171558_().m_171514_(30, 60).m_171488_(-2.0f, 0.0f, 0.0f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.3835f, (float)-1.75f, (float)0.3597f, (float)0.0f, (float)-1.5708f, (float)-0.7854f));
        PartDefinition head_r10 = head.m_171599_("head_r10", CubeListBuilder.m_171558_().m_171514_(40, 56).m_171488_(-2.0f, 0.0f, 0.0f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)5.1488f, (float)-1.75f, (float)-3.488f, (float)2.3562f, (float)-1.1781f, (float)-3.1416f));
        PartDefinition head_r11 = head.m_171599_("head_r11", CubeListBuilder.m_171558_().m_171514_(30, 62).m_171488_(-2.0f, 0.0f, 0.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)5.9142f, (float)-1.75f, (float)-5.3358f, (float)-0.7854f, (float)-0.7854f, (float)0.0f));
        PartDefinition head_r12 = head.m_171599_("head_r12", CubeListBuilder.m_171558_().m_171514_(8, 60).m_171488_(-3.0f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)6.0f, (float)-3.0f, (float)4.35f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition head_r13 = head.m_171599_("head_r13", CubeListBuilder.m_171558_().m_171514_(26, 51).m_171488_(2.0f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-6.0f, (float)-2.7f, (float)4.45f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition head_r14 = head.m_171599_("head_r14", CubeListBuilder.m_171558_().m_171514_(32, 50).m_171488_(-3.0f, -2.0f, -2.0f, 6.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.95f, (float)4.45f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition head_r15 = head.m_171599_("head_r15", CubeListBuilder.m_171558_().m_171514_(26, 56).m_171488_(-2.0f, -1.0f, -1.0f, 5.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)-1.0f, (float)-6.75f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition helmet_r1 = head.m_171599_("helmet_r1", CubeListBuilder.m_171558_().m_171514_(54, 63).m_171488_(0.0f, 0.0f, -0.5f, 0.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.5f, (float)-2.6f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition helmet_r2 = head.m_171599_("helmet_r2", CubeListBuilder.m_171558_().m_171514_(56, 63).m_171488_(0.0f, 0.0f, -0.5f, 0.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.5f, (float)-2.6f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition right_arm = body.m_171599_("right_arm", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)4.25f, (float)-22.0f, (float)5.5f, (float)0.0f, (float)0.0f, (float)-1.5708f));
        PartDefinition right_arm_r1 = right_arm.m_171599_("right_arm_r1", CubeListBuilder.m_171558_().m_171514_(54, 59).m_171488_(-5.5f, -0.505f, -0.505f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(62, 16).m_171488_(-0.5f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(62, 12).m_171488_(-7.5f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)1.25f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition right_arm_r2 = right_arm.m_171599_("right_arm_r2", CubeListBuilder.m_171558_().m_171514_(40, 59).m_171488_(-2.0f, 0.0f, -1.5f, 4.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-11.5f, (float)1.25f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition right_arm_r3 = right_arm.m_171599_("right_arm_r3", CubeListBuilder.m_171558_().m_171514_(0, 57).m_171488_(-3.0f, 0.0f, -1.5f, 4.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-10.5f, (float)1.25f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_arm_r4 = right_arm.m_171599_("right_arm_r4", CubeListBuilder.m_171558_().m_171514_(22, 60).m_171488_(3.0f, -3.0f, -1.5f, 1.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(14, 57).m_171488_(4.0f, -4.0f, -1.5f, 1.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.5f, (float)1.25f, (float)-2.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = body.m_171599_("left_arm", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-4.0f, (float)-22.0f, (float)5.5f, (float)0.0f, (float)0.0f, (float)1.5708f));
        PartDefinition left_arm_r1 = left_arm.m_171599_("left_arm_r1", CubeListBuilder.m_171558_().m_171514_(54, 59).m_171480_().m_171488_(0.5f, -0.505f, -0.505f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(62, 16).m_171480_().m_171488_(-1.5f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(62, 12).m_171480_().m_171488_(5.5f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)2.0f, (float)1.5f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm_r2 = left_arm.m_171599_("left_arm_r2", CubeListBuilder.m_171558_().m_171514_(40, 59).m_171480_().m_171488_(-2.0f, 0.0f, -1.5f, 4.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)11.5f, (float)1.5f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm_r3 = left_arm.m_171599_("left_arm_r3", CubeListBuilder.m_171558_().m_171514_(0, 57).m_171480_().m_171488_(-1.0f, 0.0f, -1.5f, 4.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)10.5f, (float)1.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm_r4 = left_arm.m_171599_("left_arm_r4", CubeListBuilder.m_171558_().m_171514_(22, 60).m_171480_().m_171488_(-4.0f, -3.0f, -1.5f, 1.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(14, 57).m_171480_().m_171488_(-5.0f, -4.0f, -1.5f, 1.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)4.5f, (float)1.5f, (float)-2.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition tail = partdefinition.m_171599_("tail", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)13.5f, (float)3.0f));
        PartDefinition tail_r1 = tail.m_171599_("tail_r1", CubeListBuilder.m_171558_().m_171514_(0, 34).m_171488_(-2.0f, -3.0f, -1.0f, 4.0f, 5.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.5f, (float)-0.5f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition tail_fin = tail.m_171599_("tail_fin", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)11.25f, (float)1.5f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition tail_fin_r1 = tail_fin.m_171599_("tail_fin_r1", CubeListBuilder.m_171558_().m_171514_(38, 20).m_171488_(-5.0f, -3.0f, 19.5f, 10.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-20.25f, (float)-2.5f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition back_fin = body.m_171599_("back_fin", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-19.25f, (float)10.25f));
        PartDefinition back_fin_r1 = back_fin.m_171599_("back_fin_r1", CubeListBuilder.m_171558_().m_171514_(50, 50).m_171488_(-0.5f, -11.0f, 3.0f, 1.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-5.75f, (float)-7.25f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(@NotNull T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.body.m_171322_(this.bodyDefault);
        this.head.m_171322_(this.headDefault);
        this.tail.m_171322_(this.tailDefault);
        this.right_arm.m_171322_(this.rightArmDefault);
        this.left_arm.m_171322_(this.leftArmDefault);
        this.back_fin.m_171322_(this.backFinDefault);
        boolean holdingGun = entity.m_21205_().m_41720_() instanceof GunItem;
        float squirmTime = ageInTicks * 0.4f;
        float squirmAmount = 0.15f;
        if (limbSwingAmount > 0.01f) {
            float walkSquirm = Mth.m_14031_((float)(limbSwing * 0.5f)) * limbSwingAmount;
            this.body.f_104205_ = walkSquirm * 0.12f;
            this.tail.f_104205_ = walkSquirm * -0.2f;
            this.tail.f_104204_ = walkSquirm * 0.2f;
        } else {
            float idleWobble;
            this.body.f_104205_ = idleWobble = Mth.m_14031_((float)squirmTime) * squirmAmount * 0.08f;
            this.tail.f_104205_ = Mth.m_14031_((float)(squirmTime + 1.0f)) * squirmAmount * -0.12f;
            this.tail.f_104204_ = Mth.m_14089_((float)squirmTime) * squirmAmount * 0.1f;
        }
        this.tail_fin.f_104204_ = Mth.m_14031_((float)(ageInTicks * 0.3f)) * 0.2f;
        if (holdingGun) {
            this.left_arm.f_104203_ = 0.0f;
            this.left_arm.f_104204_ = 1.6f;
            this.left_arm.f_104205_ = 1.5708f;
            this.right_arm.f_104203_ = 0.0f;
            this.right_arm.f_104204_ = -2.2f;
            this.right_arm.f_104205_ = -3.5f;
        } else if (((FinforcerEntity)((Object)entity)).isAttacking() && ((FinforcerEntity)((Object)entity)).getAttackTimeout() > 0) {
            this.animateAttackSmooth(((FinforcerEntity)((Object)entity)).getAttackTimeout(), ageInTicks);
        } else {
            float idleArmSwing;
            this.right_arm.f_104203_ = idleArmSwing = Mth.m_14031_((float)(ageInTicks * 0.1f)) * 0.05f;
            this.left_arm.f_104203_ = -idleArmSwing;
        }
        float clampedYaw = Mth.m_14036_((float)netHeadYaw, (float)-75.0f, (float)75.0f);
        float clampedPitch = Mth.m_14036_((float)headPitch, (float)-30.0f, (float)30.0f);
        this.head.f_104204_ = clampedYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = clampedPitch * ((float)Math.PI / 180);
    }

    private void animateAttackSmooth(int attackTimeout, float ageInTicks) {
        if (attackTimeout <= 0) {
            this.left_arm.f_104203_ = 0.0f;
            this.left_arm.f_104204_ = 0.0f;
            this.left_arm.f_104205_ = 1.5708f;
            this.attackStartTime = -1.0f;
            this.lastAttackTimeout = 0;
            return;
        }
        if (attackTimeout > this.lastAttackTimeout || this.attackStartTime < 0.0f) {
            this.attackStartTime = ageInTicks;
        }
        this.lastAttackTimeout = attackTimeout;
        float elapsedTime = ageInTicks - this.attackStartTime;
        float attackProgress = elapsedTime / 12.0f;
        attackProgress = Mth.m_14036_((float)attackProgress, (float)0.0f, (float)1.0f);
        float swingCurve = Mth.m_14031_((float)(attackProgress * (float)Math.PI));
        this.left_arm.f_104203_ = 0.0f;
        this.left_arm.f_104204_ = swingCurve * 1.8f;
        this.left_arm.f_104205_ = 1.5708f;
    }

    public void m_7695_(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.tail.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void m_6002_(HumanoidArm pSide, PoseStack pPoseStack) {
        if (pSide == HumanoidArm.LEFT) {
            this.body.m_104299_(pPoseStack);
            this.left_arm.m_104299_(pPoseStack);
            pPoseStack.m_252781_(Axis.f_252403_.m_252961_(-1.5708f));
            pPoseStack.m_85837_(-0.15, 0.2, 0.05);
            pPoseStack.m_85841_(1.0f, 1.0f, 1.0f);
        }
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

