/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import org.jetbrains.annotations.NotNull;
import top.ribs.scguns.entity.monster.SubjugatorEntity;
import top.ribs.scguns.item.GunItem;

public class SubjugatorModel<T extends SubjugatorEntity>
extends HierarchicalModel<T>
implements ArmedModel {
    private final ModelPart root;
    private final ModelPart left_leg;
    private final ModelPart right_leg;
    private final ModelPart torso;
    private final ModelPart head;
    private final ModelPart left_ear;
    private final ModelPart right_ear;
    private final ModelPart left_arm;
    private final ModelPart right_arm;
    private final PartPose headDefault;
    private final PartPose torsoDefault;
    private final PartPose leftArmDefault;
    private final PartPose rightArmDefault;
    private final PartPose leftLegDefault;
    private final PartPose rightLegDefault;
    private float attackStartTime = -1.0f;
    private int lastAttackTimeout = 0;
    private static final float ATTACK_DURATION = 12.0f;

    public SubjugatorModel(ModelPart root) {
        this.root = root;
        this.left_leg = root.m_171324_("left_leg");
        this.right_leg = root.m_171324_("right_leg");
        this.torso = root.m_171324_("torso");
        this.head = root.m_171324_("head");
        this.left_ear = this.head.m_171324_("left_ear");
        this.right_ear = this.head.m_171324_("right_ear");
        this.left_arm = root.m_171324_("left_arm");
        this.right_arm = root.m_171324_("right_arm");
        this.headDefault = this.head.m_171308_();
        this.torsoDefault = this.torso.m_171308_();
        this.leftArmDefault = this.left_arm.m_171308_();
        this.rightArmDefault = this.right_arm.m_171308_();
        this.leftLegDefault = this.left_leg.m_171308_();
        this.rightLegDefault = this.right_leg.m_171308_();
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition left_leg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(20, 49).m_171488_(-1.6f, -0.5215f, -1.576f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(32, 28).m_171488_(-1.6f, 6.4785f, -1.576f, 5.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.55f, (float)8.75f, (float)-0.4f));
        PartDefinition right_leg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(20, 49).m_171480_().m_171488_(-2.4f, -0.5215f, -1.576f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(32, 28).m_171480_().m_171488_(-3.4f, 6.4785f, -1.576f, 5.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-1.65f, (float)8.75f, (float)-0.4f));
        PartDefinition torso = partdefinition.m_171599_("torso", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171488_(-0.8668f, -10.924f, -5.5044f, 9.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(32, 41).m_171488_(-0.3668f, -10.924f, 1.4956f, 8.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(32, 0).m_171488_(-0.3668f, -3.7551f, -5.0693f, 8.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.6332f, (float)8.2892f, (float)2.4902f));
        PartDefinition cube_r1 = torso.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(0.4f, 0.55f, -1.6f, 0.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)6.8831f, (float)-9.9795f, (float)-5.6969f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition cube_r2 = torso.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171488_(-0.5f, -0.25f, -1.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)6.8831f, (float)-9.9795f, (float)-5.6969f, (float)0.0f, (float)1.5708f, (float)0.7854f));
        PartDefinition body_r1 = torso.m_171599_("body_r1", CubeListBuilder.m_171558_().m_171514_(37, 59).m_171488_(-1.5056f, 2.287f, 3.7218f, 6.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.7501f, (float)-1.2181f, (float)-3.5637f, (float)0.0f, (float)-1.5708f, (float)0.2094f));
        PartDefinition body_r2 = torso.m_171599_("body_r2", CubeListBuilder.m_171558_().m_171514_(60, 0).m_171488_(-3.4944f, 2.4699f, 3.2833f, 6.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.7826f, (float)-1.1905f, (float)-2.5637f, (float)0.0f, (float)1.5708f, (float)-0.288f));
        PartDefinition body_r3 = torso.m_171599_("body_r3", CubeListBuilder.m_171558_().m_171514_(52, 54).m_171488_(-4.1289f, 2.5388f, 4.4934f, 8.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.7621f, (float)-1.6856f, (float)-3.8566f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -7.59f, -3.5625f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 16).m_171488_(-4.5f, -2.59f, -3.9475f, 9.0f, 3.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(24, 0).m_171488_(-1.5f, -5.015f, -4.0475f, 5.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(32, 10).m_171488_(-4.5f, -4.59f, 2.0525f, 9.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.9544f, (float)-0.0525f));
        PartDefinition head_r1 = head.m_171599_("head_r1", CubeListBuilder.m_171558_().m_171514_(20, 43).m_171488_(-1.5f, -1.5f, -0.5f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)-4.015f, (float)-3.6475f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition left_ear = head.m_171599_("left_ear", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)5.4413f, (float)-5.571f, (float)2.8206f));
        PartDefinition ear_r1 = left_ear.m_171599_("ear_r1", CubeListBuilder.m_171558_().m_171514_(0, 51).m_171488_(0.0f, -1.5f, -4.0f, 0.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)2.25f, (float)0.45f, (float)0.0f, (float)0.3923f, (float)0.0181f));
        PartDefinition right_ear = head.m_171599_("right_ear", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-5.4413f, (float)-5.571f, (float)2.8206f));
        PartDefinition ear_r2 = right_ear.m_171599_("ear_r2", CubeListBuilder.m_171558_().m_171514_(52, 44).m_171488_(0.0f, -1.5f, -4.0f, 0.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)2.25f, (float)0.45f, (float)0.0f, (float)-0.3923f, (float)-0.0181f));
        PartDefinition left_arm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)4.5f, (float)-1.25f, (float)0.25f));
        PartDefinition left_arm_r1 = left_arm.m_171599_("left_arm_r1", CubeListBuilder.m_171558_().m_171514_(56, 18).m_171480_().m_171488_(-0.75f, 2.875f, -1.7f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.1f)).m_171555_(false), PartPose.m_171423_((float)1.25f, (float)4.3282f, (float)0.2387f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r3 = left_arm.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(14, 51).m_171488_(0.2f, -1.4902f, -1.0348f, 0.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.2f, (float)3.4783f, (float)0.4904f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r4 = left_arm.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(30, 60).m_171488_(-0.7f, -2.0922f, -2.043f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.2f, (float)3.4783f, (float)0.4904f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm_r2 = left_arm.m_171599_("left_arm_r2", CubeListBuilder.m_171558_().m_171514_(36, 15).m_171488_(-4.2673f, -7.0235f, -2.5f, 5.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.75f, (float)5.3282f, (float)0.0637f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition left_arm_r3 = left_arm.m_171599_("left_arm_r3", CubeListBuilder.m_171558_().m_171514_(60, 6).m_171488_(1.0f, -1.5f, 1.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.5f, (float)7.7032f, (float)1.8637f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition left_arm_r4 = left_arm.m_171599_("left_arm_r4", CubeListBuilder.m_171558_().m_171514_(14, 60).m_171488_(-1.25f, -0.125f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(36, 49).m_171488_(-1.75f, -6.125f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.75f, (float)5.3282f, (float)0.0637f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm_r5 = left_arm.m_171599_("left_arm_r5", CubeListBuilder.m_171558_().m_171514_(52, 36).m_171488_(-1.25f, 3.875f, -2.5f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.25f, (float)5.3282f, (float)0.5637f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_arm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-4.5f, (float)-1.25f, (float)0.25f));
        PartDefinition cube_r5 = right_arm.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(26, 60).m_171488_(-0.2f, -1.4902f, -1.0348f, 0.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.2f, (float)3.4783f, (float)0.4904f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r6 = right_arm.m_171599_("cube_r6", CubeListBuilder.m_171558_().m_171514_(6, 61).m_171488_(-0.3f, -2.0922f, -2.043f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.2f, (float)3.4783f, (float)0.4904f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition right_arm_r1 = right_arm.m_171599_("right_arm_r1", CubeListBuilder.m_171558_().m_171514_(0, 43).m_171488_(-0.7327f, -7.0235f, -2.5f, 5.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.75f, (float)5.3282f, (float)0.0637f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition right_arm_r2 = right_arm.m_171599_("right_arm_r2", CubeListBuilder.m_171558_().m_171514_(56, 18).m_171488_(-2.25f, 2.875f, -1.7f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.1f)), PartPose.m_171423_((float)-1.25f, (float)4.3282f, (float)0.2387f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_arm_r3 = right_arm.m_171599_("right_arm_r3", CubeListBuilder.m_171558_().m_171514_(0, 61).m_171488_(-3.0f, -1.5f, 1.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.5f, (float)7.7032f, (float)1.8637f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition right_arm_r4 = right_arm.m_171599_("right_arm_r4", CubeListBuilder.m_171558_().m_171514_(50, 23).m_171488_(-1.75f, -2.125f, -1.5f, 3.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(56, 10).m_171488_(-2.25f, -6.125f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.75f, (float)5.3282f, (float)0.0637f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(@NotNull T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.m_171322_(this.headDefault);
        this.torso.m_171322_(this.torsoDefault);
        this.left_arm.m_171322_(this.leftArmDefault);
        this.right_arm.m_171322_(this.rightArmDefault);
        this.left_leg.m_171322_(this.leftLegDefault);
        this.right_leg.m_171322_(this.rightLegDefault);
        boolean holdingGun = entity.m_21205_().m_41720_() instanceof GunItem;
        float legSwing = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        float armSwing = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.0f * limbSwingAmount;
        this.right_leg.f_104203_ += legSwing;
        this.left_leg.f_104203_ -= legSwing;
        if (!holdingGun && ((SubjugatorEntity)((Object)entity)).isAttacking() && ((SubjugatorEntity)((Object)entity)).getAttackTimeout() > 0) {
            this.animateAttackSmooth(((SubjugatorEntity)((Object)entity)).getAttackTimeout(), ageInTicks);
        }
        this.left_arm.f_104203_ -= armSwing;
        float earTime = ageInTicks * 0.08f + limbSwing * 0.4f;
        float earAmount = 0.05f + limbSwingAmount * 0.2f;
        this.left_ear.f_104205_ = Mth.m_14089_((float)(earTime * 1.1f)) * earAmount;
        this.right_ear.f_104205_ = -Mth.m_14089_((float)earTime) * earAmount;
        float clampedYaw = Mth.m_14036_((float)netHeadYaw, (float)-60.0f, (float)60.0f);
        float clampedPitch = Mth.m_14036_((float)headPitch, (float)-25.0f, (float)25.0f);
        this.head.f_104204_ += clampedYaw * ((float)Math.PI / 180);
        this.head.f_104203_ += clampedPitch * ((float)Math.PI / 180) * 0.5f;
        if (holdingGun) {
            this.right_arm.f_104203_ = -1.5708f;
            this.right_arm.f_104204_ = 0.0f;
            this.right_arm.f_104205_ = 0.0f;
            this.left_arm.f_104203_ = -1.3f;
            this.left_arm.f_104204_ = 0.6f;
            this.left_arm.f_104205_ = 0.3f;
        }
    }

    private void animateAttackSmooth(int attackTimeout, float ageInTicks) {
        if (attackTimeout <= 0) {
            this.right_arm.f_104203_ = 0.0f;
            this.right_arm.f_104204_ = 0.0f;
            this.attackStartTime = -1.0f;
            this.lastAttackTimeout = 0;
            return;
        }
        if (attackTimeout > this.lastAttackTimeout || this.attackStartTime < 0.0f) {
            this.attackStartTime = ageInTicks;
        }
        this.lastAttackTimeout = attackTimeout;
        float elapsedTime = ageInTicks - this.attackStartTime;
        float attackProgress = elapsedTime / 12.0f;
        attackProgress = Mth.m_14036_((float)attackProgress, (float)0.0f, (float)1.0f);
        float swingCurve = Mth.m_14031_((float)(attackProgress * (float)Math.PI));
        this.right_arm.f_104203_ = -swingCurve * 2.0f;
        this.right_arm.f_104204_ = 0.0f;
    }

    public void m_7695_(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.left_leg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.right_leg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.torso.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.left_arm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.right_arm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void m_6002_(HumanoidArm pSide, PoseStack pPoseStack) {
        if (pSide == HumanoidArm.RIGHT) {
            this.right_arm.m_104299_(pPoseStack);
            pPoseStack.m_85837_(-0.05, 0.25, -0.0);
            pPoseStack.m_85841_(1.0f, 1.0f, 1.0f);
        }
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

