/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.client;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import top.ribs.scguns.entity.monster.ZombifiedHornlinEntity;
import top.ribs.scguns.item.GunItem;

public class ZombifiedHornlinModel
extends HumanoidModel<ZombifiedHornlinEntity> {
    private final ModelPart leftEar;
    private final ModelPart rightEar;
    private final PartPose headDefault;
    private final PartPose bodyDefault;
    private final PartPose leftArmDefault;
    private final PartPose rightArmDefault;

    public ZombifiedHornlinModel(ModelPart root) {
        super(root);
        this.leftEar = this.f_102808_.m_171324_("left_ear");
        this.rightEar = this.f_102808_.m_171324_("right_ear");
        this.headDefault = this.f_102808_.m_171308_();
        this.bodyDefault = this.f_102810_.m_171308_();
        this.leftArmDefault = this.f_102812_.m_171308_();
        this.rightArmDefault = this.f_102811_.m_171308_();
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-5.0f, -8.0f, -4.0f, 10.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(36, 50).m_171488_(-2.0f, -4.0f, -5.0f, 4.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(46, 12).m_171488_(2.0f, -2.0f, -5.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(50, 12).m_171488_(-3.0f, -2.0f, -5.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        head.m_171599_("head_r1", CubeListBuilder.m_171558_().m_171514_(46, 50).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.8f, (float)-7.75f, (float)-4.75f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        head.m_171599_("head_r2", CubeListBuilder.m_171558_().m_171514_(38, 12).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.15f, (float)-5.0f, (float)-4.375f, (float)-0.4215f, (float)0.3614f, (float)-0.1572f));
        head.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(16, 49).m_171488_(0.0f, 0.0f, -2.0f, 1.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(32, 44).m_171488_(-1.0f, 3.75f, 0.0f, 3.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.5f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6109f));
        head.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(26, 49).m_171488_(-1.0f, 0.0f, -2.0f, 1.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.5f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.6109f));
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.5f, 6.0f, -4.0f, 11.0f, 8.0f, 8.0f, new CubeDeformation(0.2f)).m_171514_(0, 32).m_171488_(-5.5f, 14.0f, -4.0f, 11.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(36, 16).m_171488_(-5.0f, 0.0f, -3.5f, 10.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(38, 39).m_171488_(-5.0f, -1.0f, -2.0f, 5.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(0, 44).m_171488_(-4.0f, 5.0f, -1.25f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(16, 44).m_171488_(-4.0f, -2.0f, -1.25f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)1.0f, (float)0.0f));
        partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(38, 39).m_171480_().m_171488_(0.0f, -1.0f, -2.0f, 5.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 44).m_171480_().m_171488_(0.0f, 5.0f, -1.25f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(16, 44).m_171480_().m_171488_(0.0f, -2.0f, -1.25f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)5.0f, (float)1.0f, (float)0.0f));
        partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(53, 33).m_171488_(-3.0f, 7.0f, -2.5f, 5.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(54, 5).m_171488_(-3.0f, 1.0f, -3.5f, 5.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)12.0f, (float)0.0f));
        partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(53, 33).m_171480_().m_171488_(-2.0f, 7.0f, -2.5f, 5.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(54, 5).m_171480_().m_171488_(-2.0f, 1.0f, -3.5f, 5.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)0.0f));
        partdefinition.m_171599_("hat", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(ZombifiedHornlinEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.f_102808_.m_171322_(this.headDefault);
        this.f_102810_.m_171322_(this.bodyDefault);
        this.f_102812_.m_171322_(this.leftArmDefault);
        this.f_102811_.m_171322_(this.rightArmDefault);
        boolean isEating = entity.isEatingGold();
        boolean isPreparing = entity.isPreparingToEat();
        boolean holdingGun = entity.m_21205_().m_41720_() instanceof GunItem;
        if (!isEating && !isPreparing) {
            super.m_6973_((LivingEntity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        } else {
            this.f_102813_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.f_102814_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.f_102813_.f_104204_ = 0.0f;
            this.f_102814_.f_104204_ = 0.0f;
            this.f_102813_.f_104205_ = 0.0f;
            this.f_102814_.f_104205_ = 0.0f;
        }
        float earWiggle = 0.5235988f;
        float earTime = ageInTicks * 0.08f + limbSwing * 0.4f;
        float earAmount = 0.06f + limbSwingAmount * 0.3f;
        this.leftEar.f_104205_ = -earWiggle - Mth.m_14089_((float)(earTime * 1.1f)) * earAmount;
        this.rightEar.f_104205_ = earWiggle + Mth.m_14089_((float)(earTime * 0.9f)) * earAmount;
        if (isEating || isPreparing) {
            this.animateEating(entity, ageInTicks, isEating, isPreparing);
        } else if (holdingGun) {
            this.f_102811_.f_104203_ = -1.5708f;
            this.f_102811_.f_104204_ = 0.0f;
            this.f_102811_.f_104205_ = 0.0f;
            this.f_102812_.f_104203_ = -1.1f;
            this.f_102812_.f_104204_ = 0.8f;
            this.f_102812_.f_104205_ = 0.5f;
            this.f_102812_.f_104200_ -= 1.0f;
        }
    }

    private void animateEating(ZombifiedHornlinEntity entity, float ageInTicks, boolean isEating, boolean isPreparing) {
        if (isPreparing) {
            float progress = entity.getHeldFoodItem().m_41619_() ? 0.0f : 1.0f;
            this.f_102812_.f_104203_ = Mth.m_14179_((float)progress, (float)0.0f, (float)-1.8f);
            this.f_102812_.f_104204_ = Mth.m_14179_((float)progress, (float)0.0f, (float)0.4f);
            this.f_102812_.f_104205_ = Mth.m_14179_((float)progress, (float)0.0f, (float)0.3f);
            this.f_102808_.f_104203_ += Mth.m_14179_((float)progress, (float)0.0f, (float)0.15f);
        } else if (isEating) {
            this.f_102812_.f_104203_ = -1.8f;
            this.f_102812_.f_104204_ = 0.4f;
            this.f_102812_.f_104205_ = 0.3f;
            float eatBob = Mth.m_14031_((float)(ageInTicks * 0.35f)) * 0.06f;
            this.f_102812_.f_104203_ += eatBob;
            this.f_102808_.f_104203_ += 0.15f + Mth.m_14031_((float)(ageInTicks * 0.3f)) * 0.04f;
            float zombieEarWiggle = Mth.m_14031_((float)(ageInTicks * 0.4f)) * 0.12f;
            this.leftEar.f_104205_ += zombieEarWiggle;
            this.rightEar.f_104205_ -= zombieEarWiggle;
        }
    }
}

