/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.item;

import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import top.ribs.scguns.init.ModParticleTypes;

public class CogLocatorItem
extends Item {
    public CogLocatorItem(Item.Properties properties) {
        super(properties.m_41503_(8));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (!level.f_46443_) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos playerPos = player.m_20183_();
            BlockPos structurePos = this.findNearestCogChambers(serverLevel, playerPos);
            if (structurePos != null) {
                Vec3 playerVec = player.m_20182_();
                Vec3 structureVec = Vec3.m_82512_((Vec3i)structurePos);
                Vec3 direction = structureVec.m_82546_(playerVec).m_82541_();
                this.createPlasmaRingLine(serverLevel, playerVec, direction);
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11736_, SoundSource.PLAYERS, 0.6f, 1.2f);
                itemStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                return InteractionResultHolder.m_19090_((Object)itemStack);
            }
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11738_, SoundSource.PLAYERS, 0.5f, 0.8f);
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.m_5776_());
    }

    private BlockPos findNearestCogChambers(ServerLevel level, BlockPos playerPos) {
        ResourceKey cogChambersKey;
        Registry structureRegistry = level.m_9598_().m_175515_(Registries.f_256944_);
        Optional cogChambers = structureRegistry.m_203636_(cogChambersKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation("scguns", "cog_chambers")));
        if (cogChambers.isPresent()) {
            HolderSet.Direct holderSet = HolderSet.m_205809_((Holder[])new Holder[]{(Holder)cogChambers.get()});
            Pair structurePos = level.m_7726_().m_8481_().m_223037_(level, (HolderSet)holderSet, playerPos, 100, false);
            if (structurePos != null) {
                return (BlockPos)structurePos.getFirst();
            }
        }
        return null;
    }

    private void createPlasmaRingLine(ServerLevel level, Vec3 start, Vec3 direction) {
        int i;
        double lineLength = 25.0;
        int ringCount = 8;
        for (i = 0; i < ringCount; ++i) {
            double progress = (double)i / (double)(ringCount - 1);
            Vec3 ringPos = start.m_82520_(direction.f_82479_ * lineLength * progress, direction.f_82480_ * lineLength * progress + 1.5, direction.f_82481_ * lineLength * progress);
            double offsetX = (level.f_46441_.m_188500_() - 0.5) * 0.2;
            double offsetY = (level.f_46441_.m_188500_() - 0.5) * 0.2;
            double offsetZ = (level.f_46441_.m_188500_() - 0.5) * 0.2;
            level.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.PLASMA_RING.get()), ringPos.f_82479_ + offsetX, ringPos.f_82480_ + offsetY, ringPos.f_82481_ + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
        }
        for (i = 0; i < 12; ++i) {
            double angle = (double)i / 12.0 * 2.0 * Math.PI;
            double radius = 1.0 + level.f_46441_.m_188500_() * 0.5;
            double offsetX = Math.cos(angle) * radius;
            double offsetZ = Math.sin(angle) * radius;
            double offsetY = (level.f_46441_.m_188500_() - 0.5) * 0.5;
            level.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.GREEN_FLAME.get()), start.f_82479_ + offsetX, start.f_82480_ + 1.0 + offsetY, start.f_82481_ + offsetZ, 1, 0.0, 0.1, 0.0, 0.05);
        }
    }

    public boolean m_142522_(ItemStack stack) {
        return stack.m_41768_();
    }

    public int m_142159_(ItemStack stack) {
        return 65416;
    }
}

