/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class TeamLogItem
extends Item {
    public TeamLogItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, @NotNull InteractionHand hand) {
        Entity entity;
        EntityHitResult hitResult;
        ItemStack itemStack = player.m_21120_(hand);
        if (!level.m_5776_() && (hitResult = this.rayTraceEntities(level, player)) != null && (entity = hitResult.m_82443_()) instanceof LivingEntity) {
            LivingEntity targetEntity = (LivingEntity)entity;
            if (player.m_6144_()) {
                boolean added = this.addEntityTypeToBlacklist(itemStack, targetEntity);
                if (added) {
                    player.m_5661_((Component)Component.m_237113_((String)("Added all " + targetEntity.m_6095_().m_20676_().getString() + " to blacklist")), true);
                } else {
                    player.m_5661_((Component)Component.m_237113_((String)(targetEntity.m_6095_().m_20676_().getString() + " is already blacklisted")), true);
                }
            } else {
                boolean added = this.addEntityToTeamLog(itemStack, targetEntity);
                if (added) {
                    player.m_5661_((Component)Component.m_237113_((String)("Added " + targetEntity.m_7755_().getString() + " to Team Log")), true);
                } else {
                    player.m_5661_((Component)Component.m_237113_((String)(targetEntity.m_7755_().getString() + " is already in Team Log")), true);
                }
            }
            this.logCurrentEntities(itemStack, player);
        }
        return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.m_5776_());
    }

    EntityHitResult rayTraceEntities(Level level, Player player) {
        Vec3 eyePosition = player.m_146892_();
        Vec3 lookVector = player.m_20154_();
        Vec3 endPos = eyePosition.m_82549_(lookVector.m_82490_(5.0));
        AABB searchBox = player.m_20191_().m_82369_(lookVector.m_82490_(5.0)).m_82377_(1.0, 1.0, 1.0);
        List entities = level.m_6249_((Entity)player, searchBox, entity -> entity instanceof LivingEntity && entity != player);
        EntityHitResult closestHitResult = null;
        double closestDistance = Double.MAX_VALUE;
        for (Entity entity2 : entities) {
            double distance;
            AABB boundingBox = entity2.m_20191_();
            Vec3 intercept = boundingBox.m_82371_(eyePosition, endPos).orElse(null);
            if (intercept == null || !((distance = eyePosition.m_82554_(intercept)) < closestDistance)) continue;
            closestDistance = distance;
            closestHitResult = new EntityHitResult(entity2, intercept);
        }
        return closestHitResult;
    }

    boolean addEntityToTeamLog(ItemStack stack, LivingEntity targetEntity) {
        CompoundTag tag = stack.m_41784_();
        ListTag listTag = tag.m_128437_("Entities", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag existingTag = listTag.m_128728_(i);
            if (!existingTag.m_128342_("UUID").equals(targetEntity.m_20148_())) continue;
            return false;
        }
        CompoundTag entityTag = new CompoundTag();
        entityTag.m_128362_("UUID", targetEntity.m_20148_());
        entityTag.m_128359_("Name", targetEntity.m_7755_().getString());
        entityTag.m_128359_("EntityType", EntityType.m_20613_((EntityType)targetEntity.m_6095_()).toString());
        listTag.add((Object)entityTag);
        tag.m_128365_("Entities", (Tag)listTag);
        stack.m_41751_(tag);
        return true;
    }

    boolean addEntityTypeToBlacklist(ItemStack stack, LivingEntity targetEntity) {
        CompoundTag tag = stack.m_41784_();
        ListTag blacklistTag = tag.m_128437_("Blacklist", 8);
        String entityTypeKey = EntityType.m_20613_((EntityType)targetEntity.m_6095_()).toString();
        for (int i = 0; i < blacklistTag.size(); ++i) {
            if (!blacklistTag.m_128778_(i).equals(entityTypeKey)) continue;
            return false;
        }
        blacklistTag.add((Object)StringTag.m_129297_((String)entityTypeKey));
        tag.m_128365_("Blacklist", (Tag)blacklistTag);
        stack.m_41751_(tag);
        return true;
    }

    void logCurrentEntities(ItemStack stack, Player player) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            int i;
            if (tag.m_128425_("Entities", 9)) {
                ListTag listTag = tag.m_128437_("Entities", 10);
                if (!listTag.isEmpty()) {
                    player.m_5661_((Component)Component.m_237113_((String)"Entities in Team Log:"), true);
                    for (i = 0; i < listTag.size(); ++i) {
                        CompoundTag entityTag = listTag.m_128728_(i);
                        String entityName = entityTag.m_128461_("Name");
                        String entityType = entityTag.m_128461_("EntityType");
                        player.m_5661_((Component)Component.m_237113_((String)("- " + entityName + " (" + entityType + ")")), true);
                    }
                } else {
                    player.m_5661_((Component)Component.m_237113_((String)"No specific entities logged."), true);
                }
            }
            if (tag.m_128425_("Blacklist", 9)) {
                ListTag blacklistTag = tag.m_128437_("Blacklist", 8);
                if (!blacklistTag.isEmpty()) {
                    player.m_5661_((Component)Component.m_237113_((String)"Blacklisted Entity Types:"), true);
                    for (i = 0; i < blacklistTag.size(); ++i) {
                        String entityType = blacklistTag.m_128778_(i);
                        player.m_5661_((Component)Component.m_237113_((String)("- " + entityType)), true);
                    }
                } else {
                    player.m_5661_((Component)Component.m_237113_((String)"No entity types blacklisted."), true);
                }
            }
        } else {
            player.m_5661_((Component)Component.m_237113_((String)"No entities or types logged in the item."), true);
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            ListTag blacklistTag;
            int i;
            ListTag listTag;
            if (tag.m_128425_("Entities", 9) && !(listTag = tag.m_128437_("Entities", 10)).isEmpty()) {
                tooltip.add((Component)Component.m_237113_((String)"Logged Entities:"));
                for (i = 0; i < listTag.size(); ++i) {
                    CompoundTag entityTag = listTag.m_128728_(i);
                    String entityName = entityTag.m_128461_("Name");
                    String entityType = entityTag.m_128461_("EntityType");
                    tooltip.add((Component)Component.m_237113_((String)("- " + entityName + " (" + entityType + ")")));
                }
            }
            if (tag.m_128425_("Blacklist", 9) && !(blacklistTag = tag.m_128437_("Blacklist", 8)).isEmpty()) {
                tooltip.add((Component)Component.m_237113_((String)"Blacklisted Entity Types:"));
                for (i = 0; i < blacklistTag.size(); ++i) {
                    String entityType = blacklistTag.m_128778_(i);
                    tooltip.add((Component)Component.m_237113_((String)("- " + entityType)));
                }
            }
        } else {
            tooltip.add((Component)Component.m_237113_((String)"No entities or types logged"));
        }
    }

    public boolean m_5812_(@NotNull ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            ListTag whitelistTypeTag;
            ListTag whitelistTag;
            ListTag blacklistTag;
            ListTag listTag;
            if (tag.m_128425_("Entities", 9) && !(listTag = tag.m_128437_("Entities", 10)).isEmpty()) {
                return true;
            }
            if (tag.m_128425_("Blacklist", 9) && !(blacklistTag = tag.m_128437_("Blacklist", 8)).isEmpty()) {
                return true;
            }
            if (tag.m_128425_("Whitelist", 9) && !(whitelistTag = tag.m_128437_("Whitelist", 10)).isEmpty()) {
                return true;
            }
            if (tag.m_128425_("WhitelistEntityTypes", 9) && !(whitelistTypeTag = tag.m_128437_("WhitelistEntityTypes", 8)).isEmpty()) {
                return true;
            }
        }
        return false;
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        return ItemStack.f_41583_;
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return false;
    }
}

