/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.network.message;

import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.api.network.message.PlayMessage;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import top.ribs.scguns.client.handler.ReloadHandler;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.common.ReloadType;
import top.ribs.scguns.init.ModSyncedDataKeys;
import top.ribs.scguns.item.GunItem;

public class C2SMessageReload
extends PlayMessage<C2SMessageReload> {
    private boolean reload;

    public C2SMessageReload() {
    }

    public C2SMessageReload(boolean reload) {
        this.reload = reload;
    }

    public void encode(C2SMessageReload message, FriendlyByteBuf buffer) {
        buffer.writeBoolean(message.reload);
    }

    public C2SMessageReload decode(FriendlyByteBuf buffer) {
        return new C2SMessageReload(buffer.readBoolean());
    }

    public void handle(C2SMessageReload message, MessageContext context) {
        context.execute(() -> {
            ServerPlayer player = context.getPlayer();
            if (player != null && !player.m_5833_()) {
                ItemStack heldItem = player.m_21205_();
                if (!(heldItem.m_41720_() instanceof GunItem) || !heldItem.m_41720_().getClass().getPackageName().startsWith("top.ribs.scguns")) {
                    return;
                }
                CompoundTag tag = heldItem.m_41784_();
                Gun gun = ((GunItem)heldItem.m_41720_()).getModifiedGun(heldItem);
                boolean currentlyReloading = (Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player);
                boolean currentlyAiming = (Boolean)ModSyncedDataKeys.AIMING.getValue((Entity)player);
                boolean inCriticalPhase = tag.m_128471_("InCriticalReloadPhase");
                if (message.reload) {
                    if (!currentlyReloading && !inCriticalPhase) {
                        if (currentlyAiming) {
                            ModSyncedDataKeys.AIMING.setValue((Entity)player, (Object)false);
                        }
                        ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)true);
                        tag.m_128379_("IsReloading", true);
                        tag.m_128379_("scguns:IsReloading", true);
                        if (gun.getReloads().getReloadType() != ReloadType.MANUAL) {
                            tag.m_128379_("InCriticalReloadPhase", true);
                        }
                        tag.m_128473_("scguns:ReloadState");
                    }
                } else {
                    if (gun.getReloads().getReloadType() != ReloadType.MANUAL && inCriticalPhase) {
                        return;
                    }
                    ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)false);
                    tag.m_128473_("IsReloading");
                    tag.m_128473_("scguns:IsReloading");
                    tag.m_128473_("InCriticalReloadPhase");
                    tag.m_128473_("scguns:ReloadState");
                    if (gun.getReloads().getReloadType() == ReloadType.MANUAL && tag.m_128471_("scguns:IsReloading") && !tag.m_128471_("scguns:IsPlayingReloadStop")) {
                        tag.m_128379_("scguns:IsPlayingReloadStop", true);
                        tag.m_128359_("scguns:ReloadState", "STOPPING");
                        ReloadHandler.loaded((Player)player);
                    }
                }
            }
        });
        context.setHandled(true);
    }
}

