/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.network.message;

import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.api.network.message.PlayMessage;
import com.mrcrayfish.framework.network.message.IMessage;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import top.ribs.scguns.common.AmmoContext;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.common.ReloadType;
import top.ribs.scguns.init.ModSyncedDataKeys;
import top.ribs.scguns.item.GunItem;
import top.ribs.scguns.network.PacketHandler;
import top.ribs.scguns.network.message.S2CMessageReload;
import top.ribs.scguns.network.message.S2CMessageUpdateAmmo;

public class C2SMessageSwapAmmo
extends PlayMessage<C2SMessageSwapAmmo> {
    public void encode(C2SMessageSwapAmmo message, FriendlyByteBuf buffer) {
    }

    public C2SMessageSwapAmmo decode(FriendlyByteBuf buffer) {
        return new C2SMessageSwapAmmo();
    }

    public void handle(C2SMessageSwapAmmo message, MessageContext context) {
        context.execute(() -> {
            String ammoType;
            ServerPlayer player = context.getPlayer();
            if (player == null) {
                return;
            }
            ItemStack heldItem = player.m_21205_();
            Item patt1446$temp = heldItem.m_41720_();
            if (!(patt1446$temp instanceof GunItem)) {
                return;
            }
            GunItem gunItem = (GunItem)patt1446$temp;
            Gun modifiedGun = gunItem.getModifiedGun(heldItem);
            Gun.General general = modifiedGun.getGeneral();
            if (!general.allowsAmmoChange()) {
                player.m_240418_((Component)Component.m_237115_((String)"message.scguns.ammo_swap.not_supported").m_130940_(ChatFormatting.RED), true);
                return;
            }
            if (general.getAvailableAmmoTypes().isEmpty()) {
                player.m_240418_((Component)Component.m_237115_((String)"message.scguns.ammo_swap.no_types").m_130940_(ChatFormatting.RED), true);
                return;
            }
            CompoundTag tag = heldItem.m_41784_();
            int currentAmmo = tag.m_128451_("AmmoCount");
            if (currentAmmo > 0 && !player.m_7500_()) {
                Item currentAmmoItem = modifiedGun.getProjectile(heldItem).getItem();
                assert (currentAmmoItem != null);
                ItemStack ammoStack = new ItemStack((ItemLike)currentAmmoItem, currentAmmo);
                if (!player.m_150109_().m_36054_(ammoStack)) {
                    player.m_36176_(ammoStack, false);
                }
            }
            tag.m_128405_("AmmoCount", 0);
            PacketHandler.getPlayChannel().sendToPlayer(() -> player, (IMessage)new S2CMessageUpdateAmmo(0));
            int currentIndex = general.getCurrentAmmoTypeIndex();
            int nextIndex = (currentIndex + 1) % general.getAvailableAmmoTypes().size();
            CompoundTag gunTag = tag.m_128469_("Gun");
            CompoundTag generalTag = gunTag.m_128469_("General");
            generalTag.m_128405_("CurrentAmmoTypeIndex", nextIndex);
            gunTag.m_128365_("General", (Tag)generalTag);
            tag.m_128365_("Gun", (Tag)gunTag);
            modifiedGun.getGeneral().setCurrentAmmoTypeIndex(nextIndex);
            String displayName = ammoType = general.getAvailableAmmoTypes().get(nextIndex);
            if (ammoType.contains(":")) {
                displayName = ammoType.substring(ammoType.indexOf(":") + 1);
            }
            displayName = displayName.replace("_", " ");
            String[] words = displayName.split(" ");
            StringBuilder titleCase = new StringBuilder();
            for (String word : words) {
                if (word.isEmpty()) continue;
                titleCase.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1).toLowerCase()).append(" ");
            }
            MutableComponent statusMessage = Component.m_237115_((String)"message.scguns.ammo_swap.changed").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)titleCase.toString().trim()).m_130940_(ChatFormatting.YELLOW));
            player.m_240418_((Component)statusMessage, true);
            AmmoContext ammoContext = Gun.findAmmo((Player)player, modifiedGun.getProjectile(heldItem).getItem());
            if (!ammoContext.stack().m_41619_() || player.m_7500_()) {
                ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)true);
                tag.m_128379_("IsReloading", true);
                tag.m_128379_("scguns:IsReloading", true);
                if (modifiedGun.getReloads().getReloadType() == ReloadType.MANUAL) {
                    tag.m_128379_("IsManualReload", true);
                    tag.m_128359_("scguns:ReloadState", "NONE");
                } else {
                    tag.m_128379_("InCriticalReloadPhase", true);
                }
                PacketHandler.getPlayChannel().sendToPlayer(() -> player, (IMessage)new S2CMessageReload(true));
            }
        });
        context.setHandled(true);
    }
}

