/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.network.message;

import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.api.network.message.PlayMessage;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.ribs.scguns.common.exosuit.ExoSuitData;
import top.ribs.scguns.common.exosuit.ExoSuitFlightHandler;
import top.ribs.scguns.common.exosuit.ExoSuitPowerManager;
import top.ribs.scguns.common.exosuit.ExoSuitUpgrade;
import top.ribs.scguns.common.exosuit.ExoSuitUpgradeManager;
import top.ribs.scguns.item.animated.ExoSuitItem;
import top.ribs.scguns.item.exosuit.GasMaskModuleItem;
import top.ribs.scguns.item.exosuit.NightVisionModuleItem;
import top.ribs.scguns.item.exosuit.RebreatherModuleItem;
import top.ribs.scguns.item.exosuit.TargetTrackerModuleItem;

public class C2SMessageToggleExoSuitPower
extends PlayMessage<C2SMessageToggleExoSuitPower> {
    private PowerType powerType;

    public C2SMessageToggleExoSuitPower() {
    }

    public C2SMessageToggleExoSuitPower(PowerType powerType) {
        this.powerType = powerType;
    }

    public void encode(C2SMessageToggleExoSuitPower message, FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)message.powerType);
    }

    public C2SMessageToggleExoSuitPower decode(FriendlyByteBuf buffer) {
        C2SMessageToggleExoSuitPower message = new C2SMessageToggleExoSuitPower();
        message.powerType = (PowerType)buffer.m_130066_(PowerType.class);
        return message;
    }

    public void handle(C2SMessageToggleExoSuitPower message, MessageContext context) {
        context.execute(() -> {
            ServerPlayer player = context.getPlayer();
            if (player == null) {
                return;
            }
            if ("jetpack".equals(message.powerType.getUpgradeType())) {
                boolean currentState = ExoSuitPowerManager.isPowerEnabled((Player)player, "utility");
                boolean newState = !currentState;
                ExoSuitPowerManager.setPowerEnabled((Player)player, "utility", newState);
                ExoSuitFlightHandler.setJetpackActive((Player)player, newState);
                String statusKey = newState ? "exosuit.message.enabled" : "exosuit.message.disabled";
                ChatFormatting statusColor = newState ? ChatFormatting.GREEN : ChatFormatting.RED;
                MutableComponent feedbackMessage = Component.m_237115_((String)"exosuit.message.prefix").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237110_((String)statusKey, (Object[])new Object[]{Component.m_237115_((String)"exosuit.upgrade.jetpack")}).m_130940_(statusColor));
                player.m_240418_((Component)feedbackMessage, true);
                if (newState) {
                    player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.3f, 1.2f);
                } else {
                    player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.3f, 0.8f);
                }
                return;
            }
            if (!ExoSuitPowerManager.canUpgradeFunction((Player)player, message.powerType.getUpgradeType())) {
                String moduleTranslationKey = C2SMessageToggleExoSuitPower.getSpecificModuleTranslationKey(player, message.powerType.getUpgradeType());
                MutableComponent feedbackMessage = Component.m_237115_((String)"exosuit.message.prefix").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237110_((String)"exosuit.message.not_available", (Object[])new Object[]{Component.m_237115_((String)moduleTranslationKey)}).m_130940_(ChatFormatting.RED));
                player.m_240418_((Component)feedbackMessage, true);
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 0.5f, 0.8f);
                return;
            }
            boolean newState = ExoSuitPowerManager.togglePower((Player)player, message.powerType.getUpgradeType());
            String moduleTranslationKey = C2SMessageToggleExoSuitPower.getSpecificModuleTranslationKey(player, message.powerType.getUpgradeType());
            String statusKey = newState ? "exosuit.message.enabled" : "exosuit.message.disabled";
            ChatFormatting statusColor = newState ? ChatFormatting.GREEN : ChatFormatting.RED;
            MutableComponent feedbackMessage = Component.m_237115_((String)"exosuit.message.prefix").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237110_((String)statusKey, (Object[])new Object[]{Component.m_237115_((String)moduleTranslationKey)}).m_130940_(statusColor));
            player.m_240418_((Component)feedbackMessage, true);
            if (newState) {
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.3f, 1.2f);
            } else {
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.3f, 0.8f);
            }
        });
        context.setHandled(true);
    }

    private static String getSpecificModuleTranslationKey(ServerPlayer player, String upgradeType) {
        if ("hud".equals(upgradeType)) {
            ItemStack hudModule = C2SMessageToggleExoSuitPower.findHudModule(player);
            if (!hudModule.m_41619_()) {
                if (hudModule.m_41720_() instanceof NightVisionModuleItem) {
                    return "exosuit.upgrade.night_vision";
                }
                if (hudModule.m_41720_() instanceof TargetTrackerModuleItem) {
                    return "exosuit.upgrade.target_tracker";
                }
                if (hudModule.m_41720_() instanceof GasMaskModuleItem) {
                    return "exosuit.upgrade.gas_mask";
                }
                if (hudModule.m_41720_() instanceof RebreatherModuleItem) {
                    return "exosuit.upgrade.rebreather";
                }
            }
            return "exosuit.upgrade.hud";
        }
        return "exosuit.upgrade." + upgradeType;
    }

    private static ItemStack findHudModule(ServerPlayer player) {
        for (ItemStack armorStack : player.m_6168_()) {
            ExoSuitItem exosuit;
            Item item = armorStack.m_41720_();
            if (!(item instanceof ExoSuitItem) || (exosuit = (ExoSuitItem)item).m_266204_() != ArmorItem.Type.HELMET) continue;
            for (int slot = 0; slot < 4; ++slot) {
                ExoSuitUpgrade upgrade;
                ItemStack upgradeItem = ExoSuitData.getUpgradeInSlot(armorStack, slot);
                if (upgradeItem.m_41619_() || (upgrade = ExoSuitUpgradeManager.getUpgradeForItem(upgradeItem)) == null || !upgrade.getType().equals("hud")) continue;
                return upgradeItem;
            }
        }
        return ItemStack.f_41583_;
    }

    public static enum PowerType {
        HELMET_HUD("hud", "HUD Module"),
        BOOTS_MOBILITY("mobility", "Mobility Enhancement"),
        JETPACK("jetpack", "Jetpack");

        private final String upgradeType;
        private final String displayName;

        private PowerType(String upgradeType, String displayName) {
            this.upgradeType = upgradeType;
            this.displayName = displayName;
        }

        public String getUpgradeType() {
            return this.upgradeType;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

