/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.network.message;

import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.api.network.message.PlayMessage;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import top.ribs.scguns.client.handler.BeamHandler;

public class S2CMessageBeamImpact
extends PlayMessage<S2CMessageBeamImpact> {
    private Vec3 hitPosition;
    private UUID playerUUID;

    public S2CMessageBeamImpact() {
    }

    public S2CMessageBeamImpact(Vec3 hitPosition, UUID playerUUID) {
        this.hitPosition = hitPosition;
        this.playerUUID = playerUUID;
    }

    public void encode(S2CMessageBeamImpact message, FriendlyByteBuf buffer) {
        buffer.writeDouble(message.hitPosition.f_82479_);
        buffer.writeDouble(message.hitPosition.f_82480_);
        buffer.writeDouble(message.hitPosition.f_82481_);
        buffer.m_130077_(message.playerUUID);
    }

    public S2CMessageBeamImpact decode(FriendlyByteBuf buffer) {
        double x = buffer.readDouble();
        double y = buffer.readDouble();
        double z = buffer.readDouble();
        Vec3 hitPosition = new Vec3(x, y, z);
        UUID playerUUID = buffer.m_130259_();
        return new S2CMessageBeamImpact(hitPosition, playerUUID);
    }

    public void handle(S2CMessageBeamImpact message, MessageContext context) {
        context.execute(() -> {
            Player player;
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            if (world != null && (player = world.m_46003_(message.playerUUID)) != null) {
                BeamHandler.spawnBeamImpactParticles(world, message.hitPosition, player);
            }
        });
        context.setHandled(true);
    }
}

