/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.world;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import top.ribs.scguns.block.NiterLayerBlock;
import top.ribs.scguns.world.NiterPatchConfiguration;

public class NiterPatchFeature
extends Feature<NiterPatchConfiguration> {
    public NiterPatchFeature(Codec<NiterPatchConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NiterPatchConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos origin = context.m_159777_();
        RandomSource random = context.m_225041_();
        NiterPatchConfiguration config = (NiterPatchConfiguration)context.m_159778_();
        if (config.niterBlock() == null) {
            return false;
        }
        if (!this.isInCave(level, origin)) {
            return false;
        }
        BlockPos floorPos = this.findFloor(level, origin);
        if (floorPos == null) {
            return false;
        }
        int placed = 0;
        int attempts = config.spreadAttempts();
        for (int i = 0; i < attempts; ++i) {
            BlockPos placePos;
            BlockState placeAtState;
            int offsetZ;
            int offsetX = random.m_188503_(config.spreadRadius() * 2 + 1) - config.spreadRadius();
            BlockPos targetPos = floorPos.m_7918_(offsetX, 0, offsetZ = random.m_188503_(config.spreadRadius() * 2 + 1) - config.spreadRadius());
            BlockPos foundFloor = this.findFloor(level, targetPos);
            if (foundFloor == null || !(placeAtState = level.m_8055_(placePos = foundFloor.m_7494_())).m_60795_() && !placeAtState.m_247087_() || !level.m_8055_(foundFloor).m_60783_((BlockGetter)level, foundFloor, Direction.UP)) continue;
            int layers = random.m_188503_(config.maxLayers() - config.minLayers() + 1) + config.minLayers();
            BlockState niterState = config.niterBlock().m_49966_();
            if (!niterState.m_61138_((Property)NiterLayerBlock.f_56581_)) continue;
            niterState = (BlockState)niterState.m_61124_((Property)NiterLayerBlock.f_56581_, (Comparable)Integer.valueOf(layers));
            level.m_7731_(placePos, niterState, 3);
            ++placed;
        }
        return placed > 0;
    }

    private boolean isInCave(WorldGenLevel level, BlockPos pos) {
        return level.m_8055_(pos).m_60795_() && level.m_8055_(pos.m_7494_()).m_60795_();
    }

    private BlockPos findFloor(WorldGenLevel level, BlockPos startPos) {
        BlockState aboveState;
        BlockState currentState;
        int y;
        BlockPos.MutableBlockPos mutablePos = startPos.m_122032_();
        for (y = 0; y < 10; ++y) {
            currentState = level.m_8055_((BlockPos)mutablePos);
            aboveState = level.m_8055_(mutablePos.m_7494_());
            if (currentState.m_60783_((BlockGetter)level, (BlockPos)mutablePos, Direction.UP) && (aboveState.m_60795_() || aboveState.m_247087_())) {
                return mutablePos.m_7949_();
            }
            mutablePos.m_122173_(Direction.DOWN);
        }
        mutablePos.m_122190_((Vec3i)startPos);
        for (y = 0; y < 10; ++y) {
            currentState = level.m_8055_((BlockPos)mutablePos);
            aboveState = level.m_8055_(mutablePos.m_7494_());
            if (currentState.m_60783_((BlockGetter)level, (BlockPos)mutablePos, Direction.UP) && (aboveState.m_60795_() || aboveState.m_247087_())) {
                return mutablePos.m_7949_();
            }
            mutablePos.m_122173_(Direction.UP);
        }
        return null;
    }
}

