/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.client;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.abyssoul.abyssoulswildlife.client.CustomBossBar;
import net.abyssoul.abyssoulswildlife.client.ScreenShakeHandler;
import net.abyssoul.abyssoulswildlife.configuration.AbyssoulsWildlifeConfigConfiguration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.CustomizeGuiOverlayEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

@EventBusSubscriber
public class ClientEvents {
    public static final Map<UUID, Integer> bossBarRenderTypes = new HashMap<UUID, Integer>();

    public ClientEvents() {
        NeoForge.EVENT_BUS.addListener(ClientEvents::onCameraSetup);
        NeoForge.EVENT_BUS.addListener(ClientEvents::onLevelTickPost);
        NeoForge.EVENT_BUS.addListener(ClientEvents::onRenderBossBar);
    }

    @SubscribeEvent
    public static void onCameraSetup(ViewportEvent.ComputeCameraAngles event) {
        LocalPlayer player = Minecraft.getInstance().player;
        double distance = new Vec3(player.getX() - ScreenShakeHandler.x, player.getY() - ScreenShakeHandler.y, player.getZ() - ScreenShakeHandler.z).length();
        float delta = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
        float ticksExistedDelta = (float)player.tickCount + delta;
        if (ScreenShakeHandler.isShaking() && ((Boolean)AbyssoulsWildlifeConfigConfiguration.ENABLE_SCREENSHAKE.get()).booleanValue() && distance < ScreenShakeHandler.maxdistance) {
            double offset = ScreenShakeHandler.getShakeOffset();
            event.setPitch(event.getPitch() + (float)(offset * (Double)AbyssoulsWildlifeConfigConfiguration.SCREENSHAKE_INTENSITY.get() / 100.0 * Math.cos(ticksExistedDelta * 3.0f + 2.0f)) * (float)(1.0 - distance / ScreenShakeHandler.maxdistance));
            event.setRoll(event.getRoll() + (float)(offset * (Double)AbyssoulsWildlifeConfigConfiguration.SCREENSHAKE_INTENSITY.get() / 100.0 * Math.cos(ticksExistedDelta * 4.0f)) * (float)(1.0 - distance / ScreenShakeHandler.maxdistance));
            event.setYaw(event.getYaw() + (float)(offset * (Double)AbyssoulsWildlifeConfigConfiguration.SCREENSHAKE_INTENSITY.get() / 100.0 * Math.cos(ticksExistedDelta * 5.0f + 1.0f)) * (float)(1.0 - distance / ScreenShakeHandler.maxdistance));
        }
    }

    @SubscribeEvent
    public static void onLevelTickPost(LevelTickEvent.Post event) {
        if (event.getLevel().isClientSide()) {
            ScreenShakeHandler.tick();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRenderBossBar(CustomizeGuiOverlayEvent.BossEventProgress event) {
        if (bossBarRenderTypes.containsKey(event.getBossEvent().getId())) {
            int renderTypeFor = bossBarRenderTypes.get(event.getBossEvent().getId());
            CustomBossBar customBossBar = CustomBossBar.customBossBars.getOrDefault(renderTypeFor, null);
            if (customBossBar == null) {
                return;
            }
            event.setCanceled(true);
            customBossBar.renderBossBar(event);
        }
    }
}

