/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import net.abyssoul.abyssoulswildlife.init.AbyssoulsWildlifeModScreens;
import net.abyssoul.abyssoulswildlife.network.SailfishTextGUIButtonMessage;
import net.abyssoul.abyssoulswildlife.procedures.SailfishGUIProcedure;
import net.abyssoul.abyssoulswildlife.procedures.SailfishTextProcedure;
import net.abyssoul.abyssoulswildlife.world.inventory.SailfishTextGUIMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.network.PacketDistributor;

public class SailfishTextGUIScreen
extends AbstractContainerScreen<SailfishTextGUIMenu>
implements AbyssoulsWildlifeModScreens.ScreenAccessor {
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private boolean menuStateUpdateActive = false;
    ImageButton imagebutton_left;

    public SailfishTextGUIScreen(SailfishTextGUIMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 0;
        this.imageHeight = 0;
    }

    @Override
    public void updateMenuState(int elementType, String name, Object elementState) {
        this.menuStateUpdateActive = true;
        this.menuStateUpdateActive = false;
    }

    public boolean isPauseScreen() {
        return true;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        Entity entity = SailfishGUIProcedure.execute((LevelAccessor)this.world);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            AbyssoulsWildlifeModScreens.renderEntityInInventoryFollowsAngle(guiGraphics, 0, -92, 15, 0.0f + (float)Math.atan((double)(this.leftPos + 5 - mouseX) / 40.0), (float)Math.atan((double)(this.topPos + -70 - mouseY) / 40.0), livingEntity);
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(ResourceLocation.parse((String)"abyssouls_wildlife:textures/screens/chapter.png"), this.leftPos + -172, this.topPos + -124, 0.0f, 0.0f, 356, 246, 356, 246);
        guiGraphics.blit(ResourceLocation.parse((String)"abyssouls_wildlife:textures/screens/can_eat.png"), this.leftPos + -46, this.topPos + -116, 0.0f, 0.0f, 16, 24, 16, 24);
        guiGraphics.blit(ResourceLocation.parse((String)"abyssouls_wildlife:textures/item/sardine.png"), this.leftPos + -64, this.topPos + -107, 0.0f, 0.0f, 16, 16, 16, 16);
        guiGraphics.blit(ResourceLocation.parse((String)"abyssouls_wildlife:textures/screens/can_get.png"), this.leftPos + 40, this.topPos + -116, 0.0f, 0.0f, 16, 24, 16, 24);
        guiGraphics.blit(ResourceLocation.parse((String)"abyssouls_wildlife:textures/item/raw_sailfish.png"), this.leftPos + 67, this.topPos + -107, 0.0f, 0.0f, 16, 16, 16, 16);
        guiGraphics.blit(ResourceLocation.parse((String)"abyssouls_wildlife:textures/item/sailfish_fin.png"), this.leftPos + 85, this.topPos + -107, 0.0f, 0.0f, 16, 16, 16, 16);
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        return super.keyPressed(key, b, c);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        String content = SailfishTextProcedure.execute();
        String[] paragraphs = content.split("%!%");
        float scale = 0.67f;
        int startX = (int)(-150.0f / scale);
        int startY = (int)(-80.0f / scale);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(scale, scale, 1.0f);
        for (String para : paragraphs) {
            if (para.trim().isEmpty()) continue;
            MutableComponent paragraph = Component.literal((String)para);
            List lines = this.font.split((FormattedText)paragraph, (int)(306.0f / scale));
            for (FormattedCharSequence line : lines) {
                guiGraphics.drawString(this.font, line, startX, startY, -16777216, false);
                Objects.requireNonNull(this.font);
                startY += 9 + 2;
            }
        }
    }

    public void init() {
        super.init();
        this.imagebutton_left = new ImageButton(this, this.leftPos + -140, this.topPos + 91, 18, 10, new WidgetSprites(ResourceLocation.parse((String)"abyssouls_wildlife:textures/screens/left.png"), ResourceLocation.parse((String)"abyssouls_wildlife:textures/screens/left_check.png")), e -> {
            int x = this.x;
            int y = this.y;
            PacketDistributor.sendToServer((CustomPacketPayload)new SailfishTextGUIButtonMessage(0, x, y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            SailfishTextGUIButtonMessage.handleButtonAction(this.entity, 0, x, y, this.z);
        }){

            public void renderWidget(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
                guiGraphics.blit(this.sprites.get(this.isActive(), this.isHoveredOrFocused()), this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
            }
        };
        this.addRenderableWidget((GuiEventListener)this.imagebutton_left);
    }
}

