/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class ModelBaldEagle<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"abyssouls_wildlife", (String)"model_bald_eagle"), "main");
    public final ModelPart main;
    public final ModelPart body;
    public final ModelPart torso;
    public final ModelPart win2;
    public final ModelPart win1;
    public final ModelPart headbase;
    public final ModelPart neck;
    public final ModelPart head;
    public final ModelPart leg1;
    public final ModelPart leg2;

    public ModelBaldEagle(ModelPart root) {
        this.main = root.getChild("main");
        this.body = this.main.getChild("body");
        this.torso = this.body.getChild("torso");
        this.win2 = this.torso.getChild("win2");
        this.win1 = this.torso.getChild("win1");
        this.headbase = this.body.getChild("headbase");
        this.neck = this.headbase.getChild("neck");
        this.head = this.neck.getChild("head");
        this.leg1 = this.body.getChild("leg1");
        this.leg2 = this.body.getChild("leg2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition main = partdefinition.addOrReplaceChild("main", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)19.0f, (float)0.0f));
        PartDefinition body = main.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition torso = body.addOrReplaceChild("torso", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = torso.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 24).addBox(-3.5f, -1.0f, 6.0f, 7.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(26, 5).addBox(-2.5f, -1.5f, 4.0f, 5.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-2.5f, -3.0f, -4.0f, 5.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition win2 = torso.addOrReplaceChild("win2", CubeListBuilder.create().texOffs(0, 18).addBox(-10.5f, -0.5f, -1.0f, 11.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(26, 0).addBox(-15.5f, 0.0f, -1.0f, 5.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)-1.5f, (float)-2.0f));
        PartDefinition win1 = torso.addOrReplaceChild("win1", CubeListBuilder.create().texOffs(0, 12).addBox(-0.5f, -0.5f, -1.0f, 11.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(22, 24).addBox(10.5f, 0.0f, -1.0f, 5.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)-1.5f, (float)-2.0f));
        PartDefinition headbase = body.addOrReplaceChild("headbase", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-2.0f, (float)-4.0f));
        PartDefinition neck = headbase.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 28).addBox(-1.5f, -3.0f, -2.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.2f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)1.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(12, 29).addBox(-1.5f, -3.0f, -2.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.1f)).texOffs(32, 14).addBox(-1.0f, -2.2479f, -3.3674f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(32, 17).addBox(-0.5f, -2.4966f, -3.3478f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.5554f, (float)-0.0639f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = head.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(26, 10).addBox(-0.5f, 0.762f, -0.5641f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.01f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)-2.4f, (float)-1.2217f, (float)0.0f, (float)0.0f));
        PartDefinition leg1 = body.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(24, 33).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(24, 29).addBox(-1.5f, 3.0f, -1.5f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(32, 21).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.1f)), PartPose.offset((float)-1.75f, (float)1.0f, (float)0.0f));
        PartDefinition leg2 = body.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(26, 33).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(32, 10).addBox(-1.5f, 3.0f, -1.5f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(32, 21).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.1f)), PartPose.offset((float)1.75f, (float)1.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.headbase.yRot = netHeadYaw / 57.295776f;
        this.headbase.xRot = headPitch / 57.295776f;
        if (!entity.onGround()) {
            this.main.xRot = -((float)Math.toDegrees(Math.asin(new Vec3(entity.getDeltaMovement().x(), entity.getDeltaMovement().y(), entity.getDeltaMovement().z()).normalize().y()))) / 90.0f;
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.main.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }
}

