/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ModelElephantSeal<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"abyssouls_wildlife", (String)"model_elephant_seal"), "main");
    public final ModelPart body;
    public final ModelPart neck;
    public final ModelPart head;
    public final ModelPart nose;
    public final ModelPart jaw;
    public final ModelPart tail;
    public final ModelPart tail2;
    public final ModelPart leftfin;
    public final ModelPart rightfin;
    public final ModelPart leftclaw;
    public final ModelPart rightclaw;

    public ModelElephantSeal(ModelPart root) {
        this.body = root.getChild("body");
        this.neck = this.body.getChild("neck");
        this.head = this.neck.getChild("head");
        this.nose = this.head.getChild("nose");
        this.jaw = this.head.getChild("jaw");
        this.tail = this.body.getChild("tail");
        this.tail2 = this.tail.getChild("tail2");
        this.leftfin = this.tail2.getChild("leftfin");
        this.rightfin = this.tail2.getChild("rightfin");
        this.leftclaw = this.body.getChild("leftclaw");
        this.rightclaw = this.body.getChild("rightclaw");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-10.0f, -13.0f, -12.0f, 20.0f, 20.0f, 24.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)17.0f, (float)0.0f));
        PartDefinition neck = body.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(54, 44).addBox(-8.0f, -16.0f, -8.0f, 16.0f, 16.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)5.0f, (float)-12.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 73).addBox(-6.0f, -7.0f, -10.0f, 12.0f, 8.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(88, 0).addBox(-6.0f, 1.0f, -7.0f, 12.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-8.0f, (float)-8.0f));
        PartDefinition nose = head.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(96, 101).addBox(-3.0f, -3.0f, -5.0f, 6.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(68, 93).addBox(-4.0f, 1.0f, -6.0f, 8.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-5.0f, (float)-9.0f));
        PartDefinition jaw = head.addOrReplaceChild("jaw", CubeListBuilder.create().texOffs(96, 93).addBox(-5.0f, 0.0f, -5.0f, 10.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(48, 73).addBox(-3.0f, -1.0f, -4.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(48, 75).addBox(2.0f, -1.0f, -4.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.0f, (float)-5.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 44).addBox(-7.0f, -9.0f, -1.0f, 14.0f, 16.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)11.0f));
        PartDefinition tail2 = tail.addOrReplaceChild("tail2", CubeListBuilder.create().texOffs(54, 69).addBox(-6.0f, -7.0f, -3.0f, 12.0f, 12.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)12.0f));
        PartDefinition leftfin = tail2.addOrReplaceChild("leftfin", CubeListBuilder.create().texOffs(88, 12).addBox(3.75f, -10.0f, 5.0f, 2.0f, 10.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        PartDefinition rightfin = tail2.addOrReplaceChild("rightfin", CubeListBuilder.create().texOffs(0, 93).addBox(-5.75f, -10.0f, 5.0f, 2.0f, 10.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        PartDefinition leftclaw = body.addOrReplaceChild("leftclaw", CubeListBuilder.create().texOffs(88, 34).addBox(0.0f, -1.25f, -4.0f, 13.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)7.0f, (float)6.0f, (float)-3.0f));
        PartDefinition rightclaw = body.addOrReplaceChild("rightclaw", CubeListBuilder.create().texOffs(28, 93).addBox(-13.0f, -1.25f, -4.0f, 13.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-7.0f, (float)6.0f, (float)-3.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
    }
}

