/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ModelGrizzlyBear<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"abyssouls_wildlife", (String)"model_grizzly_bear"), "main");
    public final ModelPart body;
    public final ModelPart torso;
    public final ModelPart chest;
    public final ModelPart headbase;
    public final ModelPart head;
    public final ModelPart frontleftleg;
    public final ModelPart frontrightleg;
    public final ModelPart rightleg;
    public final ModelPart leftleg;

    public ModelGrizzlyBear(ModelPart root) {
        this.body = root.getChild("body");
        this.torso = this.body.getChild("torso");
        this.chest = this.torso.getChild("chest");
        this.headbase = this.torso.getChild("headbase");
        this.head = this.headbase.getChild("head");
        this.frontleftleg = this.body.getChild("frontleftleg");
        this.frontrightleg = this.body.getChild("frontrightleg");
        this.rightleg = this.body.getChild("rightleg");
        this.leftleg = this.body.getChild("leftleg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)13.5f, (float)1.8333f));
        PartDefinition torso = body.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -5.5f, -3.8333f, 10.0f, 11.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(30, 18).addBox(-4.5f, -5.0f, 3.1667f, 9.0f, 10.0f, 6.0f, new CubeDeformation(0.65f)).texOffs(30, 18).addBox(-4.5f, -5.0f, 3.1667f, 9.0f, 10.0f, 6.0f, new CubeDeformation(0.65f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition chest = torso.addOrReplaceChild("chest", CubeListBuilder.create().texOffs(0, 18).addBox(-5.0f, -8.0f, 0.0f, 9.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.5f, (float)1.6f, (float)-8.8333f));
        PartDefinition headbase = torso.addOrReplaceChild("headbase", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-1.324f, (float)-8.8333f));
        PartDefinition head = headbase.addOrReplaceChild("head", CubeListBuilder.create().texOffs(34, 0).addBox(-3.0f, -2.676f, -5.0f, 6.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(34, 11).addBox(-1.5f, 0.324f, -7.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = head.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(24, 36).addBox(-1.0f, -1.0f, -0.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.25f)), PartPose.offsetAndRotation((float)2.0f, (float)-2.576f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)0.0873f));
        PartDefinition cube_r2 = head.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(18, 36).addBox(-1.0f, -1.0f, -0.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.25f)), PartPose.offsetAndRotation((float)-2.0f, (float)-2.576f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        PartDefinition frontleftleg = body.addOrReplaceChild("frontleftleg", CubeListBuilder.create().texOffs(18, 48).addBox(-2.0f, -1.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.75f, (float)3.5f, (float)-6.0833f));
        PartDefinition frontrightleg = body.addOrReplaceChild("frontrightleg", CubeListBuilder.create().texOffs(34, 48).addBox(-2.0f, -1.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.75f, (float)3.5f, (float)-6.0833f));
        PartDefinition rightleg = body.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(30, 34).addBox(-2.0f, -2.5f, -2.5f, 4.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.75f, (float)4.0f, (float)6.5667f));
        PartDefinition leftleg = body.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(0, 36).addBox(-2.0f, -2.5f, -2.5f, 4.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.75f, (float)4.0f, (float)6.5667f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.headbase.yRot = netHeadYaw / 57.295776f;
        this.headbase.xRot = headPitch / 57.295776f;
    }
}

