/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ModelWildboar<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"abyssouls_wildlife", (String)"model_wildboar"), "main");
    public final ModelPart body;
    public final ModelPart frontleftleg;
    public final ModelPart frontrightleg;
    public final ModelPart rightleg;
    public final ModelPart leftleg;
    public final ModelPart headbase;
    public final ModelPart head;
    public final ModelPart rightear;
    public final ModelPart leftear;

    public ModelWildboar(ModelPart root) {
        this.body = root.getChild("body");
        this.frontleftleg = this.body.getChild("frontleftleg");
        this.frontrightleg = this.body.getChild("frontrightleg");
        this.rightleg = this.body.getChild("rightleg");
        this.leftleg = this.body.getChild("leftleg");
        this.headbase = this.body.getChild("headbase");
        this.head = this.headbase.getChild("head");
        this.rightear = this.head.getChild("rightear");
        this.leftear = this.head.getChild("leftear");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -13.0f, -9.0f, 10.0f, 9.0f, 10.0f, new CubeDeformation(0.5f)).texOffs(0, 19).addBox(-4.5f, -12.0f, 2.0f, 9.0f, 8.0f, 7.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition frontleftleg = body.addOrReplaceChild("frontleftleg", CubeListBuilder.create().texOffs(32, 32).addBox(-1.5f, -2.0f, -1.5f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)-5.0f, (float)-5.0f));
        PartDefinition frontrightleg = body.addOrReplaceChild("frontrightleg", CubeListBuilder.create().texOffs(0, 34).addBox(-1.5f, -2.0f, -1.5f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)-5.0f, (float)-5.0f));
        PartDefinition rightleg = body.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(12, 34).addBox(-1.5f, -2.0f, -1.0f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)-5.0f, (float)6.0f));
        PartDefinition leftleg = body.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(40, 0).addBox(-1.5f, -2.0f, -1.0f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)-5.0f, (float)6.0f));
        PartDefinition headbase = body.addOrReplaceChild("headbase", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-7.25f, (float)-8.0f));
        PartDefinition head = headbase.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = head.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(34, 42).addBox(-3.25f, 1.0f, -3.5f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)-5.0f, (float)-1.3963f, (float)0.0f, (float)-0.0873f));
        PartDefinition cube_r2 = head.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(24, 42).addBox(2.25f, 1.0f, -3.5f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)-5.0f, (float)-1.3963f, (float)0.0f, (float)0.0873f));
        PartDefinition cube_r3 = head.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(40, 10).addBox(-2.0f, 0.25f, -2.5f, 4.0f, 4.0f, 3.0f, new CubeDeformation(0.25f)).texOffs(32, 19).addBox(-4.0f, -6.0f, -6.0f, 8.0f, 6.0f, 7.0f, new CubeDeformation(0.5f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)-5.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition rightear = head.addOrReplaceChild("rightear", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-1.0f, (float)-5.75f));
        PartDefinition cube_r4 = rightear.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(24, 34).addBox(-0.8f, -0.9224f, -0.7102f, 1.0f, 3.0f, 3.0f, new CubeDeformation(-0.25f)), PartPose.offsetAndRotation((float)-4.45f, (float)-4.2331f, (float)3.0872f, (float)-1.3299f, (float)-0.2026f, (float)-0.3094f));
        PartDefinition leftear = head.addOrReplaceChild("leftear", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-1.0f, (float)-5.75f));
        PartDefinition cube_r5 = leftear.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(0, 44).addBox(-0.2f, -0.9224f, -0.7102f, 1.0f, 3.0f, 3.0f, new CubeDeformation(-0.25f)), PartPose.offsetAndRotation((float)4.45f, (float)-4.2331f, (float)3.0872f, (float)-1.3299f, (float)0.2026f, (float)0.3094f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.rightleg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.headbase.yRot = netHeadYaw / 57.295776f;
        this.headbase.xRot = headPitch / 57.295776f;
        this.leftleg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.frontrightleg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.frontleftleg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
    }
}

